/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;

public abstract class HighlightHandlerBase {
    static void setupFindModel(Project project) {
        FindManager findManager = FindManager.getInstance((Project)project);
        FindModel model = findManager.getFindNextModel();
        if (model == null) {
            model = findManager.getFindInFileModel();
        }
        model.setSearchHighlighters(true);
        findManager.setFindWasPerformed();
        findManager.setFindNextModel(model);
    }

    protected static void setLineTextErrorStripeTooltip(RangeHighlighter highlighter) {
        Document document = highlighter.getDocument();
        int lineNumber = document.getLineNumber(highlighter.getStartOffset());
        String lineText = document.getText().substring(document.getLineStartOffset(lineNumber), document.getLineEndOffset(lineNumber));
        highlighter.setErrorStripeTooltip((Object)("  " + StringUtil.escapeXml((String)lineText.trim()) + "  "));
    }
}

