/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.FileCopyPatcher;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.xml.util.XmlUtil;

public class XmlAutoLookupHandler
extends CodeCompletionHandlerBase {
    public XmlAutoLookupHandler() {
        super(CompletionType.BASIC);
    }

    @Override
    protected boolean mayAutocompleteOnInvocation() {
        return false;
    }

    @Override
    protected boolean isAutocompleteCommonPrefixOnInvocation() {
        return false;
    }

    @Override
    protected void handleEmptyLookup(CompletionContext context, CompletionParameters parameters, CompletionProgressIndicator indicator) {
    }

    @Override
    protected void doComplete(int offset1, int offset2, CompletionContext context, FileCopyPatcher dummyIdentifier, Editor editor, int invocationCount) {
        Language templateDataLanguage;
        FileViewProvider fileViewProvider;
        PsiFile file = context.file;
        int offset = context.getStartOffset();
        PsiElement lastElement = InjectedLanguageUtil.findElementAtNoCommit(file, offset - 1);
        if (lastElement == null) {
            return;
        }
        if (!this.doCompleteIfNeeded(offset1, offset2, context, dummyIdentifier, editor, invocationCount, file, lastElement) && (fileViewProvider = file.getViewProvider()) instanceof TemplateLanguageFileViewProvider && (templateDataLanguage = ((TemplateLanguageFileViewProvider)fileViewProvider).getTemplateDataLanguage()) != lastElement.getParent().getLanguage()) {
            lastElement = fileViewProvider.findElementAt(offset - 1, templateDataLanguage);
            if (lastElement == null) {
                return;
            }
            this.doCompleteIfNeeded(offset1, offset2, context, dummyIdentifier, editor, invocationCount, file, lastElement);
        }
    }

    private boolean doCompleteIfNeeded(int offset1, int offset2, CompletionContext context, FileCopyPatcher dummyIdentifier, Editor editor, int invocationCount, PsiFile file, PsiElement lastElement) {
        Ref isRelevantLanguage = new Ref();
        Ref isAnt = new Ref();
        String text = lastElement.getText();
        int len = context.getStartOffset() - lastElement.getTextRange().getStartOffset();
        if (len < text.length()) {
            text = text.substring(0, len);
        }
        if (text.equals("<") && XmlAutoLookupHandler.isLanguageRelevant(lastElement, file, (Ref<Boolean>)isRelevantLanguage, (Ref<Boolean>)isAnt) || text.equals(" ") && XmlAutoLookupHandler.isLanguageRelevant(lastElement, file, (Ref<Boolean>)isRelevantLanguage, (Ref<Boolean>)isAnt) || text.endsWith("${") && XmlAutoLookupHandler.isLanguageRelevant(lastElement, file, (Ref<Boolean>)isRelevantLanguage, (Ref<Boolean>)isAnt) && (Boolean)isAnt.get() != false || text.endsWith("@{") && XmlAutoLookupHandler.isLanguageRelevant(lastElement, file, (Ref<Boolean>)isRelevantLanguage, (Ref<Boolean>)isAnt) && (Boolean)isAnt.get() != false || text.endsWith("</") && XmlAutoLookupHandler.isLanguageRelevant(lastElement, file, (Ref<Boolean>)isRelevantLanguage, (Ref<Boolean>)isAnt)) {
            super.doComplete(offset1, offset2, context, dummyIdentifier, editor, invocationCount);
            return true;
        }
        return false;
    }

    private static boolean isLanguageRelevant(PsiElement element, PsiFile file, Ref<Boolean> isRelevantLanguage, Ref<Boolean> isAnt) {
        Boolean result;
        Boolean isAntFile = (Boolean)isAnt.get();
        if (isAntFile == null) {
            isAntFile = XmlUtil.isAntFile(file);
            isAnt.set((Object)isAntFile);
        }
        if ((result = (Boolean)isRelevantLanguage.get()) == null) {
            Language language = element.getLanguage();
            if (element instanceof PsiWhiteSpace) {
                language = element.getParent().getLanguage();
            }
            result = language instanceof XMLLanguage || isAntFile != false;
            isRelevantLanguage.set((Object)result);
        }
        return result;
    }
}

