/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.Loader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClasspathCache {
    private final Map<String, List<Loader>> myClassPackagesCache = new HashMap<String, List<Loader>>();
    private final Map<String, List<Loader>> myResourcePackagesCache = new HashMap<String, List<Loader>>();

    public void addResourceEntry(String resourcePath, Loader loader) {
        List<Loader> loaders = this.getLoaders(resourcePath);
        if (!loaders.contains(loader)) {
            loaders.add(loader);
        }
    }

    public List<Loader> getLoaders(String resourcePath) {
        int idx;
        String packageName;
        boolean isClassFile = resourcePath.endsWith(".class");
        Map<String, List<Loader>> map = isClassFile ? this.myClassPackagesCache : this.myResourcePackagesCache;
        List<Loader> list = map.get(packageName = (idx = resourcePath.lastIndexOf(47)) > 0 ? resourcePath.substring(0, idx) : "");
        if (list == null) {
            list = new ArrayList<Loader>(1);
            map.put(packageName, list);
        }
        return list;
    }
}

