/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.testng.internal.TestNGProperty;

public class Constants {
    private static final String NAMESPACE = "testng";
    public static final String PROP_OUTPUT_DIR = "testng.outputDir";
    private static final TestNGProperty[] COMMAND_LINE_PARAMETERS;
    private static final Map<String, TestNGProperty> m_propertiesByName;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static TestNGProperty getProperty(String propertyName) {
        TestNGProperty result = m_propertiesByName.get(propertyName);
        if (!$assertionsDisabled && null == result) {
            throw new AssertionError((Object)("Unknown property : " + propertyName));
        }
        return result;
    }

    public static String getPropertyValue(Properties p, String propertyName) {
        TestNGProperty r = Constants.getProperty(propertyName);
        if (!$assertionsDisabled && null == r) {
            throw new AssertionError((Object)("Unknown property : " + propertyName));
        }
        String result = p.getProperty(r.getName());
        return result;
    }

    public static boolean getBooleanPropertyValue(Properties properties, String propertyName) {
        TestNGProperty p = Constants.getProperty(propertyName);
        String r = properties.getProperty(propertyName, p.getDefault());
        boolean result = "true".equalsIgnoreCase(r);
        return result;
    }

    public static int getIntegerPropertyValue(Properties properties, String propertyName) {
        TestNGProperty p = Constants.getProperty(propertyName);
        String r = properties.getProperty(propertyName, p.getDefault());
        int result = Integer.parseInt(r);
        return result;
    }

    public static String getDefaultValueFor(String propertyName) {
        TestNGProperty p = Constants.getProperty(propertyName);
        return p.getDefault();
    }

    public static String displayStatus(int status) {
        if (3 == status) {
            return "SKIP";
        }
        if (1 == status) {
            return "SUCCESS";
        }
        if (2 == status) {
            return "FAILURE";
        }
        return "UNKNOWN_STATUS";
    }

    static {
        $assertionsDisabled = !Constants.class.desiredAssertionStatus();
        COMMAND_LINE_PARAMETERS = new TestNGProperty[]{new TestNGProperty("-d", PROP_OUTPUT_DIR, "Directory where the result files will be created.", "test-output")};
        m_propertiesByName = new HashMap<String, TestNGProperty>();
        for (int i = 0; i < COMMAND_LINE_PARAMETERS.length; ++i) {
            m_propertiesByName.put(COMMAND_LINE_PARAMETERS[i].getName(), COMMAND_LINE_PARAMETERS[i]);
        }
    }
}

