/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.actions;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.maddyhome.idea.copyright.actions.AbstractFileProcessor;
import com.maddyhome.idea.copyright.actions.RecursionDlg;
import com.maddyhome.idea.copyright.actions.UpdateCopyrightProcessor;
import com.maddyhome.idea.copyright.pattern.FileUtil;
import com.maddyhome.idea.copyright.util.FileTypeUtil;
import java.util.ArrayList;

public class UpdateCopyrightAction
extends AnAction {
    public void update(AnActionEvent event) {
        boolean enabled = UpdateCopyrightAction.isEnabled(event);
        event.getPresentation().setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)event.getPlace())) {
            event.getPresentation().setVisible(enabled);
        }
    }

    private static boolean isEnabled(AnActionEvent event) {
        PsiElement[] elems;
        DataContext context = event.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(context);
        if (project == null) {
            return false;
        }
        VirtualFile[] files = (VirtualFile[])PlatformDataKeys.VIRTUAL_FILE_ARRAY.getData(context);
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(context);
        if (editor != null) {
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file == null || !FileTypeUtil.getInstance().isSupportedFile(file)) {
                return false;
            }
        } else if (files != null && FileUtil.areFiles(files)) {
            boolean copyrightEnabled = false;
            for (VirtualFile vfile : files) {
                if (!FileTypeUtil.getInstance().isSupportedFile(vfile)) continue;
                copyrightEnabled = true;
                break;
            }
            if (!copyrightEnabled) {
                return false;
            }
        } else if ((files == null || files.length != 1) && LangDataKeys.MODULE_CONTEXT.getData(context) == null && PlatformDataKeys.PROJECT_CONTEXT.getData(context) == null && (elems = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(context)) != null) {
            boolean copyrightEnabled = false;
            for (PsiElement elem : elems) {
                PsiFile file;
                if (elem instanceof PsiDirectory || (file = elem.getContainingFile()) != null && FileTypeUtil.getInstance().isSupportedFile(file.getVirtualFile())) continue;
                copyrightEnabled = true;
                break;
            }
            if (!copyrightEnabled) {
                return false;
            }
        }
        return true;
    }

    public void actionPerformed(AnActionEvent event) {
        PsiDirectory dir;
        DataContext context = event.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(context);
        assert (project != null);
        Module module = (Module)LangDataKeys.MODULE.getData(context);
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        VirtualFile[] files = (VirtualFile[])PlatformDataKeys.VIRTUAL_FILE_ARRAY.getData(context);
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(context);
        PsiFile file = null;
        if (editor != null) {
            file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file == null) {
                return;
            }
            dir = file.getContainingDirectory();
        } else {
            if (FileUtil.areFiles(files)) {
                new UpdateCopyrightProcessor(project, null, FileUtil.convertToPsiFiles(files, project)).run();
                return;
            }
            Module modCtx = (Module)LangDataKeys.MODULE_CONTEXT.getData(context);
            if (modCtx != null) {
                new UpdateCopyrightProcessor(project, module).run();
                return;
            }
            Module[] modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(context);
            if (modules != null && modules.length > 0) {
                ArrayList<PsiFile> psiFiles = new ArrayList<PsiFile>();
                for (Module mod : modules) {
                    AbstractFileProcessor.findFiles(mod, psiFiles);
                }
                new UpdateCopyrightProcessor(project, null, psiFiles.toArray(new PsiFile[psiFiles.size()])).run();
                return;
            }
            PsiElement psielement = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(context);
            if (psielement == null) {
                return;
            }
            if (psielement instanceof PsiPackage) {
                dir = ((PsiPackage)psielement).getDirectories()[0];
            } else if (psielement instanceof PsiDirectory) {
                dir = (PsiDirectory)psielement;
            } else {
                file = psielement.getContainingFile();
                if (file == null) {
                    return;
                }
                dir = file.getContainingDirectory();
            }
        }
        RecursionDlg recDlg = new RecursionDlg(project, file != null ? file.getVirtualFile() : dir.getVirtualFile());
        recDlg.show();
        if (!recDlg.isOK()) {
            return;
        }
        if (recDlg.isAll()) {
            new UpdateCopyrightProcessor(project, module, dir, recDlg.includeSubdirs()).run();
        } else {
            new UpdateCopyrightProcessor(project, module, file).run();
        }
    }
}

