/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.ui.GitUIUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class BasicAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/actions/BasicAction.actionPerformed must not be null");
        }
        final Project project = (Project)event.getData(PlatformDataKeys.PROJECT);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                FileDocumentManager.getInstance().saveAllDocuments();
            }
        });
        VirtualFile[] vFiles = (VirtualFile[])event.getData(PlatformDataKeys.VIRTUAL_FILE_ARRAY);
        assert (vFiles != null) : "The action is only available when files are selected";
        assert (project != null);
        GitVcs vcs = GitVcs.getInstance(project);
        if (!ProjectLevelVcsManager.getInstance((Project)project).checkAllFilesAreUnder((AbstractVcs)vcs, vFiles)) {
            return;
        }
        final String actionName = this.getActionName();
        final ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        final VirtualFile[] affectedFiles = this.collectAffectedFiles(project, vFiles);
        boolean background = this.perform(project, vcs, exceptions, affectedFiles);
        if (!background) {
            vcs.runInBackground(new Task.Backgroundable(project, this.getActionName()){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/actions/BasicAction$2.run must not be null");
                    }
                    GitUtil.refreshFiles(project, Arrays.asList(affectedFiles));
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            GitUIUtil.showOperationErrors(project, exceptions, actionName);
                        }
                    });
                }
            });
        }
    }

    protected abstract boolean perform(@NotNull Project var1, GitVcs var2, @NotNull List<VcsException> var3, @NotNull VirtualFile[] var4);

    protected boolean toBackground(final Project project, GitVcs vcs, final VirtualFile[] affectedFiles, final List<VcsException> exceptions, final Consumer<ProgressIndicator> action) {
        vcs.runInBackground(new Task.Backgroundable(project, this.getActionName()){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/actions/BasicAction$3.run must not be null");
                }
                action.consume((Object)indicator);
                GitUtil.refreshFiles(project, Arrays.asList(affectedFiles));
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        GitUIUtil.showOperationErrors(project, exceptions, BasicAction.this.getActionName());
                    }
                });
            }
        });
        return true;
    }

    @NotNull
    protected VirtualFile[] collectAffectedFiles(@NotNull Project project, @NotNull VirtualFile[] files) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/actions/BasicAction.collectAffectedFiles must not be null");
        }
        if (files == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/actions/BasicAction.collectAffectedFiles must not be null");
        }
        ArrayList<VirtualFile> affectedFiles = new ArrayList<VirtualFile>(files.length);
        ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        for (VirtualFile file : files) {
            if (!file.isDirectory() && projectLevelVcsManager.getVcsFor(file) instanceof GitVcs) {
                affectedFiles.add(file);
                continue;
            }
            if (!file.isDirectory() || !this.isRecursive()) continue;
            this.addChildren(project, affectedFiles, file);
        }
        VirtualFile[] virtualFileArray = VfsUtil.toVirtualFileArray(affectedFiles);
        if (virtualFileArray == null) {
            throw new IllegalStateException("@NotNull method git4idea/actions/BasicAction.collectAffectedFiles must not return null");
        }
        return virtualFileArray;
    }

    private void addChildren(@NotNull Project project, @NotNull List<VirtualFile> files, @NotNull VirtualFile file) {
        VirtualFile[] children;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/actions/BasicAction.addChildren must not be null");
        }
        if (files == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/actions/BasicAction.addChildren must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of git4idea/actions/BasicAction.addChildren must not be null");
        }
        for (VirtualFile child : children = file.getChildren()) {
            if (!child.isDirectory() && this.appliesTo(project, child)) {
                files.add(child);
                continue;
            }
            if (!child.isDirectory() || !this.isRecursive()) continue;
            this.addChildren(project, files, child);
        }
    }

    @NotNull
    protected abstract String getActionName();

    protected boolean isRecursive() {
        return true;
    }

    protected boolean appliesTo(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/actions/BasicAction.appliesTo must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/actions/BasicAction.appliesTo must not be null");
        }
        return !file.isDirectory();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/actions/BasicAction.update must not be null");
        }
        super.update(e);
        Presentation presentation = e.getPresentation();
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        VirtualFile[] vFiles = (VirtualFile[])e.getData(PlatformDataKeys.VIRTUAL_FILE_ARRAY);
        if (vFiles == null || vFiles.length == 0) {
            presentation.setEnabled(false);
            presentation.setVisible(true);
            return;
        }
        GitVcs vcs = GitVcs.getInstance(project);
        boolean enabled = ProjectLevelVcsManager.getInstance((Project)project).checkAllFilesAreUnder((AbstractVcs)vcs, vFiles) && this.isEnabled(project, vcs, vFiles);
        presentation.setEnabled(enabled);
        presentation.setVisible(enabled);
    }

    protected abstract boolean isEnabled(@NotNull Project var1, @NotNull GitVcs var2, VirtualFile ... var3);

    public static void saveAll() {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                FileDocumentManager.getInstance().saveAllDocuments();
            }
        });
    }
}

