#!/bin/sh
echo 'name: snap-core
version: 0.5.3.1
id: snap-core-0.5.3.1-998d67849801009f39c366b7d57e08cd

license: BSD3
copyright:
maintainer: snap@snapframework.com
stability:
homepage: http://snapframework.com/
package-url:
description: Snap is a simple and fast web development framework and server written in
             Haskell. For more information or to download the latest version, you can
             visit the Snap project website at <http://snapframework.com/>.
             .
             This library contains the core definitions and types for the Snap framework,
             including:
             .
             1. Primitive types and functions for HTTP (requests, responses, cookies,
             post/query parameters, etc)
             .
             2. Type aliases and helper functions for Iteratee I/O
             .
             3. A monad for programming web handlers called \"Snap\", inspired by
             happstack'\''s (<http://happstack.com/index.html>), which allows:
             .
             * Stateful access to the HTTP request and response objects
             .
             * Monadic failure (i.e. MonadPlus/Alternative instances) for declining
             to handle requests and chaining handlers together
             .
             * Early termination of the computation if you know early what you want
             to return and want to prevent further monadic processing
             .
             /Quick start/: The '\''Snap'\'' monad and HTTP definitions are in "Snap.Types",
             some iteratee utilities are in "Snap.Iteratee".
             .
             Higher-level facilities for building web applications (like user/session
             management, component interfaces, data modeling, etc.) are planned but not
             yet implemented, so this release will mostly be of interest for those who:
             .
             * need a fast and minimal HTTP API at roughly the same level of abstraction
             as Java servlets, or
             .
             * are interested in contributing to the Snap Framework project.
category: Web
author: James Sanders, Shu-yu Guo, Gregory Collins, Doug Beardsley
pkgpath: www/hs-snap-core
exposed: True
exposed-modules: Snap.Types Snap.Iteratee Snap.Internal.Debug
                 Snap.Internal.Http.Types Snap.Internal.Iteratee.Debug
                 Snap.Internal.Parsing Snap.Util.FileServe Snap.Util.FileUploads
                 Snap.Util.GZip Snap.Util.Readable
hidden-modules: Snap.Internal.Instances
                Snap.Internal.Iteratee.BoyerMooreHorspool Snap.Internal.Routing
                Snap.Internal.Types
import-dirs: /usr/local/lib/ghc/snap-core-0.5.3.1
library-dirs: /usr/local/lib/ghc/snap-core-0.5.3.1
hs-libraries: HSsnap-core-0.5.3.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: MonadCatchIO-transformers-0.2.2.0-21f55e3743ac58803f508355a9eecc56
         attoparsec-0.8.6.1-0be93c0db37da3d9d9d5934e440ceea4
         attoparsec-enumerator-0.2.0.3-5c479f5651a8203b081194e7d5dda58a
         base-4.3.1.0-ee15f259a627d341af7c80a17e8b0e66
         blaze-builder-0.2.1.4-bfcede572046050679f95fe80b55244e
         bytestring-0.9.1.10-4e62762ee9b2a5d0cc5bc2fbaaeefd53
         bytestring-nums-0.3.2-963561c5ca3aa36f42500414fb3aea1c
         case-insensitive-0.3.0.1-4af9524f4c290b81b29e4dcfd15ad577
         containers-0.4.0.0-f1307d32d8f4b51a1487c01f0997b6d9
         deepseq-1.1.0.2-ce16381c4a634f8997917e5081cb960a
         directory-1.1.0.0-ca04ddcf1c341deb4150c220bedd97c0
         dlist-0.5-a01ba402f7d2fb6ade284cfdae50bfed
         enumerator-0.4.14-63fedf341c69a69125c64fd58230de7c
         filepath-1.2.0.0-956a4b0c127b8c317f6cac3946b0b803
         mtl-2.0.1.0-3e464329054b7660133198d73c31aca5
         old-locale-1.0.0.2-25ff1e5e0486bb3cf2cb85cb7daf8f22
         old-time-1.0.0.6-249d424df19da9487f0cb7da3ccb0868
         text-0.11.1.5-a9f0a532672121c1439a824b6891e297
         time-1.2.0.3-ad46a3ade48e0011608895f44cc02a52
         transformers-0.2.2.0-89265f646be3aed4f502cfc5eccd7c93
         unix-compat-0.2-95c69a4141f1f166fd9d504e2e3aa283
         vector-0.7.1-3cb4afeb6b20e182ed5daf2f17289745
         zlib-0.5.3.1-3c6d04702765b68fe92c99674060e068
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-snap-core-0.5.3.1/html/snap-core.haddock
haddock-html: /usr/local/share/doc/hs-snap-core-0.5.3.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
