#!/bin/sh
echo 'name: hashed-storage
version: 0.5.4
id: hashed-storage-0.5.4-3e321b51e4528617a68757d460be1770

license: BSD3
copyright: 2009 Petr Rockai <me@mornfall.net>
maintainer: Petr Rockai <me@mornfall.net>
stability:
homepage:
package-url:
description: Support code for reading and manipulating hashed file storage
             (where each file and directory is associated with a
             cryptographic hash, for corruption-resistant storage and fast
             comparisons).
             .
             The supported storage formats include darcs hashed pristine, a
             plain filesystem tree and an indexed plain tree (where the index
             maintains hashes of the plain files and directories).
category: System
author: Petr Rockai <me@mornfall.net>
pkgpath: devel/hs-hashed-storage
exposed: True
exposed-modules: Storage.Hashed Storage.Hashed.AnchoredPath
                 Storage.Hashed.Index Storage.Hashed.Monad Storage.Hashed.Tree
                 Storage.Hashed.Hash Storage.Hashed.Packed Storage.Hashed.Plain
                 Storage.Hashed.Darcs
hidden-modules: Bundled.Posix Bundled.SHA256 Storage.Hashed.Utils
import-dirs: /usr/local/lib/ghc/hashed-storage-0.5.4
library-dirs: /usr/local/lib/ghc/hashed-storage-0.5.4
hs-libraries: HShashed-storage-0.5.4
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.3.1.0-ee15f259a627d341af7c80a17e8b0e66
         binary-0.5.0.2-9ce4ac1edaeb172504c9442cbc6071e0
         bytestring-0.9.1.10-4e62762ee9b2a5d0cc5bc2fbaaeefd53
         containers-0.4.0.0-f1307d32d8f4b51a1487c01f0997b6d9
         dataenc-0.13.0.4-66e1dc61ea6d5210b96712752871209d
         directory-1.1.0.0-ca04ddcf1c341deb4150c220bedd97c0
         extensible-exceptions-0.1.1.2-d8c5b906654260efd7249f497d17a831
         filepath-1.2.0.0-956a4b0c127b8c317f6cac3946b0b803
         mmap-0.5.6-559bb734c87373444e7949c05a75e5cd
         mtl-2.0.1.0-3e464329054b7660133198d73c31aca5
         zlib-0.5.3.1-3c6d04702765b68fe92c99674060e068
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-hashed-storage-0.5.4/html/hashed-storage.haddock
haddock-html: /usr/local/share/doc/hs-hashed-storage-0.5.4/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
