#!/bin/sh
echo 'name: atom
version: 1.0.9
id: atom-1.0.9-2108638a09702d6e3e7d075441c375bf

license: BSD3
copyright:
maintainer: Tom Hawkins <tomahawkins@gmail.com>, Lee Pike <leepike@gmail.com>
stability:
homepage: http://tomahawkins.org
package-url:
description: Atom is a Haskell DSL for designing hard realtime embedded software.
             Based on guarded atomic actions (similar to STM), Atom enables
             highly concurrent programming without the need for mutex locking.
             In addition, Atom performs compile-time task scheduling and generates code
             with deterministic execution time and constant memory use, simplifying the
             process of timing verification and memory consumption in hard realtime applications.
             Without mutex locking and run-time task scheduling, Atom eliminates
             the need and overhead of RTOSs for many embedded applications.
category: Language, Embedded
author: Tom Hawkins <tomahawkins@gmail.com>
pkgpath: devel/hs-atom
exposed: True
exposed-modules: Language.Atom Language.Atom.Analysis
                 Language.Atom.Code Language.Atom.Common Language.Atom.Compile
                 Language.Atom.Elaboration Language.Atom.Example
                 Language.Atom.Expressions Language.Atom.Language
                 Language.Atom.Scheduling Language.Atom.Unit Language.Atom.UeMap
hidden-modules:
import-dirs: /usr/local/lib/ghc/atom-1.0.9
library-dirs: /usr/local/lib/ghc/atom-1.0.9
hs-libraries: HSatom-1.0.9
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.3.1.0-ee15f259a627d341af7c80a17e8b0e66
         bimap-0.2.4-5cf708989fb19dd1948d7a6870201bac
         containers-0.4.0.0-f1307d32d8f4b51a1487c01f0997b6d9
         mtl-2.0.1.0-3e464329054b7660133198d73c31aca5
         process-1.0.1.5-99e45a86cf1678266024ae9c30d1f778
         syb-0.3.3-daedbadc9dc041093c4210b3087b5f0b
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-atom-1.0.9/html/atom.haddock
haddock-html: /usr/local/share/doc/hs-atom-1.0.9/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
