/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;

public final class UID
implements Serializable {
    private static final long serialVersionUID = 1086053664494604050L;
    private static short uidCounter = Short.MIN_VALUE;
    private static long last;
    private static final int machineId;
    private short count;
    private int unique;
    private long time;

    static {
        machineId = UID.getMachineId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UID() {
        Class<UID> clazz = UID.class;
        synchronized (UID.class) {
            this.time = System.currentTimeMillis();
            this.unique = machineId;
            if (this.time > last) {
                last = this.time;
                uidCounter = Short.MIN_VALUE;
                this.count = Short.MIN_VALUE;
            } else {
                if (uidCounter == Short.MAX_VALUE) {
                    try {
                        Thread.sleep(2L);
                    }
                    catch (InterruptedException interruptedException) {}
                    uidCounter = Short.MIN_VALUE;
                    this.time = last = System.currentTimeMillis();
                }
                this.count = uidCounter = (short)(uidCounter + 1);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public UID(short wellKnownId) {
        this.unique = wellKnownId;
    }

    public int hashCode() {
        return (int)((long)this.unique ^ this.time ^ (long)this.count);
    }

    public boolean equals(Object other) {
        if (other instanceof UID) {
            UID ui = (UID)other;
            return this.unique == ui.unique && this.time == ui.time && this.count == ui.count;
        }
        return false;
    }

    public static UID read(DataInput in) throws IOException {
        UID uid = new UID();
        uid.unique = in.readInt();
        uid.time = in.readLong();
        uid.count = in.readShort();
        return uid;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.unique);
        out.writeLong(this.time);
        out.writeShort(this.count);
    }

    static int getMachineId() {
        int hostIpHash;
        try {
            String host = InetAddress.getLocalHost().toString();
            hostIpHash = host.hashCode();
        }
        catch (Exception exception) {
            hostIpHash = 0;
        }
        return new Object().hashCode() ^ (int)System.currentTimeMillis() ^ hostIpHash;
    }

    public String toString() {
        int max = 36;
        long lc = this.count - Short.MIN_VALUE & 0xFFFF;
        return String.valueOf(Long.toString(this.unique, max)) + ":" + Long.toString(this.time, max) + "." + Long.toString(lc, max);
    }
}

