/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageFilter;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public class BufferedImageFilter
extends ImageFilter
implements Cloneable {
    private BufferedImageOp op;

    public BufferedImageFilter(BufferedImageOp op) {
        if (op == null) {
            throw new NullPointerException("BufferedImageFilter null op in constructor");
        }
        this.op = op;
    }

    public BufferedImageOp getBufferedImageOp() {
        return this.op;
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        DataBufferByte db = new DataBufferByte(pixels, scansize * h + off, off);
        SampleModel sm = model.createCompatibleSampleModel(scansize, h);
        WritableRaster wr = new WritableRaster(sm, db, new Point(0, 0));
        BufferedImage in = new BufferedImage(model, wr, model.isAlphaPremultiplied(), null);
        BufferedImage out = this.op.createCompatibleDestImage(in, model);
        this.op.filter(in, out);
        DataBuffer dbout = out.getRaster().getDataBuffer();
        super.setPixels(0, 0, w, h, model, ((DataBufferByte)dbout).getData(), 0, scansize);
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        DataBufferInt db = new DataBufferInt(pixels, scansize * h + off, off);
        SampleModel sm = model.createCompatibleSampleModel(scansize, h);
        WritableRaster wr = new WritableRaster(sm, db, new Point(0, 0));
        BufferedImage in = new BufferedImage(model, wr, model.isAlphaPremultiplied(), null);
        BufferedImage out = this.op.createCompatibleDestImage(in, model);
        this.op.filter(in, out);
        DataBuffer dbout = out.getRaster().getDataBuffer();
        super.setPixels(0, 0, w, h, model, ((DataBufferInt)dbout).getData(), 0, scansize);
    }
}

