/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.xml.xpath.Expr;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

final class EqualityExpr
extends Expr {
    final Expr lhs;
    final Expr rhs;
    final boolean invert;

    EqualityExpr(Expr lhs, Expr rhs, boolean invert) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.invert = invert;
    }

    public Object evaluate(Node context, int pos, int len) {
        boolean val = this.evaluateImpl(context, pos, len);
        if (this.invert) {
            return val ? Boolean.FALSE : Boolean.TRUE;
        }
        return val ? Boolean.TRUE : Boolean.FALSE;
    }

    private boolean evaluateImpl(Node context, int pos, int len) {
        Object left = this.lhs.evaluate(context, pos, len);
        Object right = this.rhs.evaluate(context, pos, len);
        boolean flns = left instanceof Collection;
        boolean frns = right instanceof Collection;
        if (flns && frns) {
            Collection lns = (Collection)left;
            Collection rns = (Collection)right;
            if (lns.isEmpty()) {
                return false;
            }
            boolean all = true;
            for (Node ltest : lns) {
                for (Node rtest : rns) {
                    if (ltest == rtest || ltest.equals(rtest)) {
                        if (this.invert) continue;
                        return true;
                    }
                    if (EqualityExpr.stringValue(ltest).equals(EqualityExpr.stringValue(rtest))) {
                        if (this.invert) continue;
                        return true;
                    }
                    all = false;
                }
            }
            return all;
        }
        boolean fln = left instanceof Double;
        boolean frn = right instanceof Double;
        if (flns && frn || frns && fln) {
            Collection ns = flns ? (Collection)left : (Collection)right;
            double n = fln ? ((Double)left).doubleValue() : ((Double)right).doubleValue();
            boolean all = true;
            for (Node test : ns) {
                double nn = EqualityExpr._number(context, EqualityExpr.stringValue(test));
                if (nn == n) {
                    if (this.invert) continue;
                    return true;
                }
                all = false;
            }
            return this.invert ? all : false;
        }
        boolean fls = left instanceof String;
        boolean frs = right instanceof String;
        if (flns && frs || frns && fls) {
            Collection ns = flns ? (Collection)left : (Collection)right;
            String s = fls ? (String)left : (String)right;
            boolean all = true;
            for (Node test : ns) {
                if (EqualityExpr.stringValue(test).equals(s)) {
                    if (this.invert) continue;
                    return true;
                }
                all = false;
            }
            return this.invert ? all : false;
        }
        boolean flb = left instanceof Boolean;
        boolean frb = right instanceof Boolean;
        if (flns && frb || frns && flb) {
            boolean b;
            Collection ns = flns ? (Collection)left : (Collection)right;
            boolean bl = b = flb ? ((Boolean)left).booleanValue() : ((Boolean)right).booleanValue();
            return EqualityExpr._boolean(context, ns) == b;
        }
        if (flb || frb) {
            boolean rb;
            boolean lb = flb ? (Boolean)left : EqualityExpr._boolean(context, left);
            boolean bl = rb = frb ? (Boolean)right : EqualityExpr._boolean(context, right);
            return lb == rb;
        }
        if (fln || frn) {
            double rn;
            double ln = fln ? (Double)left : EqualityExpr._number(context, left);
            double d = rn = frn ? (Double)right : EqualityExpr._number(context, right);
            return ln == rn;
        }
        String ls = fls ? (String)left : EqualityExpr._string(context, left);
        String rs = frs ? (String)right : EqualityExpr._string(context, right);
        return ls.equals(rs);
    }

    public Expr clone(Object context) {
        return new EqualityExpr(this.lhs.clone(context), this.rhs.clone(context), this.invert);
    }

    public boolean references(QName var) {
        return this.lhs.references(var) || this.rhs.references(var);
    }

    public String toString() {
        if (this.invert) {
            return this.lhs + " != " + this.rhs;
        }
        return this.lhs + " = " + this.rhs;
    }
}

