/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class DateTimeType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{4, 5, 6, 7, 8, 10, 9};

    DateTimeType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "dateTime"), TypeLibrary.ANY_SIMPLE_TYPE);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkValue(String value, ValidationContext context) throws DatatypeException {
        super.checkValid(value, context);
        int len = value.length();
        int state = 0;
        int start = 0;
        int i = 0;
        while (i < len) {
            block37: {
                char c;
                block36: {
                    c = value.charAt(i);
                    if (c != '-' || i != 0) break block36;
                    ++start;
                    break block37;
                }
                if (c >= '0' && c <= '9') break block37;
                switch (state) {
                    case 0: {
                        if (c != '-') throw new DatatypeException(i, "invalid dateTime value");
                        String year = value.substring(start, i);
                        if ("0000".equals(year) || year.length() < 4) {
                            throw new DatatypeException(i, "invalid dateTime value");
                        }
                        state = 1;
                        start = i + 1;
                        break;
                    }
                    case 1: {
                        if (c != '-') throw new DatatypeException(i, "invalid dateTime value");
                        if (i - start != 2) {
                            throw new DatatypeException(i, "invalid dateTime value");
                        }
                        state = 2;
                        start = i + 1;
                        break;
                    }
                    case 2: {
                        if (c != 'T') throw new DatatypeException(i, "invalid dateTime value");
                        if (i - start != 2) {
                            throw new DatatypeException(i, "invalid dateTime value");
                        }
                        state = 3;
                        start = i + 1;
                        break;
                    }
                    case 3: {
                        if (c != ':') throw new DatatypeException(i, "invalid dateTime value");
                        if (i - start != 2) {
                            throw new DatatypeException(i, "invalid dateTime value");
                        }
                        state = 4;
                        start = i + 1;
                        break;
                    }
                    case 4: {
                        if (c != ':') throw new DatatypeException(i, "invalid dateTime value");
                        if (i - start != 2) {
                            throw new DatatypeException(i, "invalid dateTime value");
                        }
                        state = 5;
                        start = i + 1;
                        break;
                    }
                    case 5: {
                        if (c == '.') {
                            if (i - start != 2) {
                                throw new DatatypeException(i, "invalid dateTime value");
                            }
                            state = 6;
                            start = i + 1;
                            break;
                        }
                        if (c != ' ') throw new DatatypeException(i, "invalid dateTime value");
                        if (i - start != 2) {
                            throw new DatatypeException(i, "invalid dateTime value");
                        }
                        state = 7;
                        start = i + 1;
                        break;
                    }
                    case 6: {
                        if (c != ' ') throw new DatatypeException(i, "invalid dateTime value");
                        state = 7;
                        start = i + 1;
                        break;
                    }
                    case 7: {
                        if (start == i) {
                            if (c == '+' || c == '-') break;
                            if (c == 'Z') {
                                state = 9;
                                start = i + 1;
                                break;
                            }
                        }
                        if (c != ':') throw new DatatypeException(i, "invalid dateTime value");
                        if (i - start != 2) {
                            throw new DatatypeException(i, "invalid dateTime value");
                        }
                        state = 8;
                        start = i + 1;
                        break;
                    }
                    default: {
                        throw new DatatypeException(i, "invalid dateTime value");
                    }
                }
            }
            ++i;
        }
        switch (state) {
            case 5: {
                if (len - start == 2) return;
                throw new DatatypeException(len, "invalid dateTime value");
            }
            case 6: {
                return;
            }
            case 8: {
                if (len - start == 2) return;
                throw new DatatypeException(len, "invalid dateTime value");
            }
            case 9: {
                return;
            }
            default: {
                throw new DatatypeException(len, "invalid dateTime value");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object createValue(String value, ValidationContext context) {
        int len = value.length();
        int state = 0;
        int start = 0;
        GregorianCalendar cal = new GregorianCalendar();
        try {
            int i;
            String timezone;
            block17: {
                TimeZone tz;
                int i2 = 0;
                while (true) {
                    if (i2 >= len) {
                        if (len - start <= 0) return cal.getTime();
                        if (state != 7) return cal.getTime();
                        timezone = value.substring(len - start);
                        i = timezone.indexOf(58);
                        if (i == -1) {
                            if ("Z".equals(timezone)) {
                                timezone = "UTC";
                            }
                            if ((tz = TimeZone.getTimeZone(timezone)) != null) break;
                            return null;
                        }
                        break block17;
                    }
                    char c = value.charAt(i2);
                    if (c == '-' && i2 == 0) {
                        ++start;
                    } else if (c < '0' || c > '9') {
                        switch (state) {
                            case 0: {
                                if (c != '-') break;
                                cal.set(1, Integer.parseInt(value.substring(0, i2)));
                                state = 1;
                                start = i2 + 1;
                                break;
                            }
                            case 1: {
                                if (c != '-') break;
                                cal.set(2, Integer.parseInt(value.substring(start, i2)));
                                state = 2;
                                start = i2 + 1;
                                break;
                            }
                            case 2: {
                                if (c != 'T') break;
                                cal.set(5, Integer.parseInt(value.substring(start, i2)));
                                state = 3;
                                start = i2 + 1;
                                break;
                            }
                            case 3: {
                                if (c != ':') break;
                                cal.set(10, Integer.parseInt(value.substring(start, i2)));
                                state = 4;
                                start = i2 + 1;
                                break;
                            }
                            case 4: {
                                if (c != ':') break;
                                cal.set(12, Integer.parseInt(value.substring(start, i2)));
                                state = 5;
                                start = i2 + 1;
                                break;
                            }
                            case 5: {
                                if (c != ' ') break;
                                float second = Float.parseFloat(value.substring(start, i2));
                                cal.set(13, (int)second);
                                state = 7;
                                start = i2 + 1;
                                break;
                            }
                        }
                    }
                    ++i2;
                }
                cal.set(15, tz.getRawOffset());
                return cal.getTime();
            }
            String tzh = timezone.substring(0, i);
            String tzm = timezone.substring(i + 1);
            int offset = Integer.parseInt(tzh) * 360000;
            offset = offset < 0 ? (offset -= Integer.parseInt(tzm) * 60000) : (offset += Integer.parseInt(tzm) * 60000);
            cal.set(15, offset);
            return cal.getTime();
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

