/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexListParser {
    public static final String JAR_INDEX_FILE = "META-INF/INDEX.LIST";
    public static final String JAR_INDEX_VERSION_KEY = "JarIndex-Version: ";
    double versionNumber;
    LinkedHashMap<URL, Set<String>> prefixes = new LinkedHashMap();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IndexListParser(JarFile jarfile, URL baseJarURL, URL baseURL) {
        try {
            if (jarfile.getEntry(JAR_INDEX_FILE) == null) {
                this.clearAll();
                return;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(new URL(baseJarURL, JAR_INDEX_FILE).openStream()));
            String line = br.readLine();
            if (!line.startsWith(JAR_INDEX_VERSION_KEY)) {
                return;
            }
            this.versionNumber = Double.parseDouble(line.substring(JAR_INDEX_VERSION_KEY.length()).trim());
            line = br.readLine();
            if (!"".equals(line)) {
                this.clearAll();
                return;
            }
            while ((line = br.readLine()) != null) {
                URL jarURL = new URL(baseURL, line);
                HashSet<String> values = new HashSet<String>();
                while ((line = br.readLine()) != null && !"".equals(line)) {
                    values.add(line.trim());
                }
                this.prefixes.put(jarURL, values);
                if (line != null) continue;
            }
            br.close();
            return;
        }
        catch (Exception exception) {
            this.clearAll();
        }
    }

    void clearAll() {
        this.versionNumber = 0.0;
        this.prefixes = null;
    }

    public String getVersionInfo() {
        return JAR_INDEX_VERSION_KEY + this.getVersionNumber();
    }

    public double getVersionNumber() {
        return this.versionNumber;
    }

    public LinkedHashMap<URL, Set<String>> getHeaders() {
        return this.prefixes;
    }
}

