/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Security;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public abstract class SSLSocketFactory
extends SocketFactory {
    private static SSLContext context;

    public static synchronized SocketFactory getDefault() {
        TrustManager[] trustManagerArray;
        KeyManager[] keyManagerArray;
        try {
            keyManagerArray = Security.getProperty("ssl.SocketFactory.provider");
            trustManagerArray = ClassLoader.getSystemClassLoader();
            if (keyManagerArray != null && trustManagerArray != null) {
                return (SocketFactory)trustManagerArray.loadClass((String)keyManagerArray).newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (context == null) {
            Object object;
            keyManagerArray = null;
            trustManagerArray = null;
            String string = KeyManagerFactory.getDefaultAlgorithm();
            String string2 = TrustManagerFactory.getDefaultAlgorithm();
            try {
                object = KeyManagerFactory.getInstance(string);
                ((KeyManagerFactory)object).init(null, null);
                keyManagerArray = ((KeyManagerFactory)object).getKeyManagers();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                object = TrustManagerFactory.getInstance(string2);
                ((TrustManagerFactory)object).init((KeyStore)null);
                trustManagerArray = ((TrustManagerFactory)object).getTrustManagers();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                context = SSLContext.getInstance("SSLv3");
                context.init(keyManagerArray, trustManagerArray, null);
            }
            catch (Exception exception) {
                throw new RuntimeException("error instantiating default socket factory: " + exception.toString());
            }
        }
        try {
            return context.getSocketFactory();
        }
        catch (Exception exception) {
            throw new RuntimeException("no SSLSocketFactory implementation available");
        }
    }

    public abstract Socket createSocket(Socket var1, String var2, int var3, boolean var4) throws IOException;

    public abstract String[] getDefaultCipherSuites();

    public abstract String[] getSupportedCipherSuites();
}

