/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.CairoSurface;
import gnu.java.awt.peer.gtk.ComponentGraphics;
import gnu.java.awt.peer.gtk.GtkCursor;
import gnu.java.awt.peer.gtk.GtkFramePeer;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import gnu.java.awt.peer.gtk.GtkImage;
import gnu.java.awt.peer.gtk.GtkToolkit;
import gnu.java.awt.peer.gtk.GtkVolatileImage;
import gnu.java.awt.peer.gtk.GtkWindowPeer;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.PaintEvent;
import java.awt.event.TextEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.awt.peer.LightweightPeer;
import java.awt.peer.WindowPeer;
import java.util.Timer;
import java.util.TimerTask;

public class GtkComponentPeer
extends GtkGenericPeer
implements ComponentPeer {
    VolatileImage backBuffer;
    BufferCapabilities caps;
    Component awtComponent;
    Insets insets;
    private static final /* synthetic */ boolean $assertionsDisabled;

    native boolean isEnabled();

    static native boolean modalHasGrab();

    native int[] gtkWidgetGetForeground();

    native int[] gtkWidgetGetBackground();

    native void gtkWidgetGetDimensions(int[] var1);

    native void gtkWidgetGetPreferredDimensions(int[] var1);

    native void gtkWindowGetLocationOnScreen(int[] var1);

    native void gtkWidgetGetLocationOnScreen(int[] var1);

    native void gtkWidgetSetCursor(int var1, GtkImage var2, int var3, int var4);

    native void gtkWidgetSetCursorUnlocked(int var1, GtkImage var2, int var3, int var4);

    native void gtkWidgetSetBackground(int var1, int var2, int var3);

    native void gtkWidgetSetForeground(int var1, int var2, int var3);

    native void gtkWidgetSetSensitive(boolean var1);

    native void gtkWidgetSetParent(ComponentPeer var1);

    native void gtkWidgetRequestFocus();

    native void gtkWidgetDispatchKeyEvent(int var1, long var2, int var4, int var5, int var6);

    native boolean gtkWidgetHasFocus();

    native boolean gtkWidgetCanFocus();

    native void realize();

    native void setNativeEventMask();

    void create() {
        throw new RuntimeException();
    }

    native void connectSignals();

    protected GtkComponentPeer(Component component) {
        super(component);
        this.awtComponent = component;
        this.insets = new Insets(0, 0, 0, 0);
        this.create();
        this.connectSignals();
        if (component.getForeground() != null) {
            this.setForeground(component.getForeground());
        }
        if (component.getBackground() != null) {
            this.setBackground(component.getBackground());
        }
        if (component.getFont() != null) {
            this.setFont(component.getFont());
        }
        Container container = component.getParent();
        this.setParentAndBounds();
        this.setNativeEventMask();
        this.realize();
        if (component.isCursorSet()) {
            this.setCursor();
        }
    }

    void setParentAndBounds() {
        this.setParent();
        this.setComponentBounds();
        this.setVisibleAndEnabled();
    }

    void setParent() {
        ComponentPeer componentPeer;
        Component component = this.awtComponent;
        while ((componentPeer = (component = component.getParent()).getPeer()) instanceof LightweightPeer) {
        }
        if (componentPeer != null) {
            this.gtkWidgetSetParent(componentPeer);
        }
    }

    void setComponentBounds() {
        Rectangle rectangle = this.awtComponent.getBounds();
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    void setVisibleAndEnabled() {
        this.setVisible(this.awtComponent.isVisible());
        this.setEnabled(this.awtComponent.isEnabled());
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.getToolkit().checkImage(image, n, n2, imageObserver);
    }

    public Image createImage(ImageProducer imageProducer) {
        return new GtkImage(imageProducer);
    }

    public Image createImage(int n, int n2) {
        return CairoSurface.getBufferedImage(n, n2);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public void enable() {
        this.setEnabled(true);
    }

    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.getToolkit().getFontMetrics(font);
    }

    public Graphics getGraphics() {
        return ComponentGraphics.getComponentGraphics(this);
    }

    public Point getLocationOnScreen() {
        int[] nArray = new int[2];
        if (this instanceof WindowPeer) {
            this.gtkWindowGetLocationOnScreen(nArray);
        } else {
            this.gtkWidgetGetLocationOnScreen(nArray);
        }
        return new Point(nArray[0], nArray[1]);
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public void handleEvent(AWTEvent aWTEvent) {
        int n = aWTEvent.getID();
        KeyEvent keyEvent = null;
        switch (n) {
            case 800: {
                this.paintComponent((PaintEvent)aWTEvent);
                break;
            }
            case 801: {
                this.updateComponent((PaintEvent)aWTEvent);
                break;
            }
            case 401: {
                keyEvent = (KeyEvent)aWTEvent;
                this.gtkWidgetDispatchKeyEvent(keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiersEx(), keyEvent.getKeyCode(), keyEvent.getKeyLocation());
                break;
            }
            case 402: {
                keyEvent = (KeyEvent)aWTEvent;
                this.gtkWidgetDispatchKeyEvent(keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiersEx(), keyEvent.getKeyCode(), keyEvent.getKeyLocation());
            }
        }
    }

    protected void paintComponent(PaintEvent paintEvent) {
        if (!this.awtComponent.isShowing() || this.awtComponent.getWidth() < 1 || this.awtComponent.getHeight() < 1) {
            return;
        }
        Graphics graphics = this.getGraphics();
        graphics.setClip(paintEvent.getUpdateRect());
        this.awtComponent.paint(graphics);
        graphics.dispose();
    }

    protected void updateComponent(PaintEvent paintEvent) {
        if (!this.awtComponent.isShowing() || this.awtComponent.getWidth() < 1 || this.awtComponent.getHeight() < 1) {
            return;
        }
        Graphics graphics = this.getGraphics();
        graphics.setClip(paintEvent.getUpdateRect());
        this.awtComponent.update(graphics);
        graphics.dispose();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public Dimension minimumSize() {
        int[] nArray = new int[2];
        this.gtkWidgetGetPreferredDimensions(nArray);
        return new Dimension(nArray[0], nArray[1]);
    }

    public void paint(Graphics graphics) {
    }

    public Dimension preferredSize() {
        int[] nArray = new int[2];
        this.gtkWidgetGetPreferredDimensions(nArray);
        return new Dimension(nArray[0], nArray[1]);
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.getToolkit().prepareImage(image, n, n2, imageObserver);
    }

    public void print(Graphics graphics) {
        graphics.drawImage(ComponentGraphics.grab(this), 0, 0, null);
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (n3 < 1 || n4 < 1) {
            return;
        }
        if (l <= 0L) {
            GtkGenericPeer.q().postEvent(new PaintEvent(this.awtComponent, 801, new Rectangle(n, n2, n3, n4)));
        } else {
            RepaintTimerTask.schedule(l, n, n2, n3, n4, this.awtComponent);
        }
    }

    public void requestFocus() {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Call new requestFocus() method instead");
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void reshape(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3, n4);
    }

    public void setBackground(Color color) {
        this.gtkWidgetSetBackground(color.getRed(), color.getGreen(), color.getBlue());
    }

    native void setNativeBounds(int var1, int var2, int var3, int var4);

    public void setBounds(int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = n2;
        Container container = this.awtComponent.getParent();
        while (container.isLightweight()) {
            Insets insets = container.getInsets();
            n5 += container.getX() + insets.left;
            n6 += container.getY() + insets.top;
            container = container.getParent();
        }
        if (container instanceof Window) {
            GtkWindowPeer gtkWindowPeer = (GtkWindowPeer)container.getPeer();
            Insets insets = gtkWindowPeer.getInsets();
            int n7 = 0;
            if (gtkWindowPeer instanceof GtkFramePeer) {
                n7 = ((GtkFramePeer)gtkWindowPeer).getMenuBarHeight();
            }
            n5 -= insets.left;
            n6 -= insets.top;
            n6 += n7;
        }
        this.setNativeBounds(n5, n6, n3, n4);
        this.setVisible(this.awtComponent.isVisible());
    }

    void setCursor() {
        this.setCursor(this.awtComponent.getCursor());
    }

    public void setCursor(Cursor cursor) {
        int n;
        int n2;
        GtkImage gtkImage;
        int n3 = cursor.getType();
        if (cursor instanceof GtkCursor) {
            GtkCursor gtkCursor = (GtkCursor)cursor;
            gtkImage = gtkCursor.getGtkImage();
            Point point = gtkCursor.getHotspot();
            n2 = point.x;
            n = point.y;
        } else {
            gtkImage = null;
            n2 = 0;
            n = 0;
        }
        if (Thread.currentThread() == GtkToolkit.mainThread) {
            this.gtkWidgetSetCursorUnlocked(cursor.getType(), gtkImage, n2, n);
        } else {
            this.gtkWidgetSetCursor(cursor.getType(), gtkImage, n2, n);
        }
    }

    public void setEnabled(boolean bl) {
        this.gtkWidgetSetSensitive(bl);
    }

    public void setFont(Font font) {
        this.gtkWidgetModifyFont(font.getName(), font.getStyle(), font.getSize());
    }

    public void setForeground(Color color) {
        this.gtkWidgetSetForeground(color.getRed(), color.getGreen(), color.getBlue());
    }

    public Color getForeground() {
        int[] nArray = this.gtkWidgetGetForeground();
        return new Color(nArray[0], nArray[1], nArray[2]);
    }

    public Color getBackground() {
        int[] nArray = this.gtkWidgetGetBackground();
        return new Color(nArray[0], nArray[1], nArray[2]);
    }

    public native void setVisibleNative(boolean var1);

    public native void setVisibleNativeUnlocked(boolean var1);

    public void setVisible(boolean bl) {
        if (bl && !(this.awtComponent instanceof Window)) {
            Rectangle rectangle = this.awtComponent.getBounds();
            boolean bl2 = bl = rectangle.width > 0 && rectangle.height > 0;
        }
        if (Thread.currentThread() == GtkToolkit.mainThread) {
            this.setVisibleNativeUnlocked(bl);
        } else {
            this.setVisibleNative(bl);
        }
    }

    public void hide() {
        this.setVisible(false);
    }

    public void show() {
        this.setVisible(true);
    }

    protected void postMouseEvent(int n, long l, int n2, int n3, int n4, int n5, boolean bl) {
        GtkGenericPeer.q().postEvent(new MouseEvent(this.awtComponent, n, l, n2, n3, n4, n5, bl));
    }

    protected void postMouseWheelEvent(int n, long l, int n2, int n3, int n4, int n5, boolean bl, int n6, int n7, int n8) {
        GtkGenericPeer.q().postEvent(new MouseWheelEvent(this.awtComponent, n, l, n2, n3, n4, n5, bl, n6, n7, n8));
    }

    protected void postExposeEvent(int n, int n2, int n3, int n4) {
        GtkGenericPeer.q().postEvent(new PaintEvent(this.awtComponent, 800, new Rectangle(n, n2, n3, n4)));
    }

    protected void postKeyEvent(int n, long l, int n2, int n3, char c, int n4) {
        KeyEvent keyEvent = new KeyEvent(this.awtComponent, n, l, n2, n3, c, n4);
        EventQueue eventQueue = GtkGenericPeer.q();
        if (keyEvent.getID() == 401 && !keyEvent.isActionKey() && n3 != 16 && n3 != 17 && n3 != 18) {
            EventQueue eventQueue2 = eventQueue;
            synchronized (eventQueue2) {
                try {
                    eventQueue.postEvent(keyEvent);
                    keyEvent = new KeyEvent(this.awtComponent, 400, l, n2, 0, c, n4);
                    eventQueue.postEvent(keyEvent);
                }
                finally {
                    Object var11_10 = null;
                }
            }
        } else {
            eventQueue.postEvent(keyEvent);
        }
    }

    protected void postFocusEvent(int n, boolean bl) {
        GtkGenericPeer.q().postEvent(new FocusEvent(this.awtComponent, n, bl));
    }

    protected void postItemEvent(Object object, int n) {
        GtkGenericPeer.q().postEvent(new ItemEvent((ItemSelectable)((Object)this.awtComponent), 701, object, n));
    }

    protected void postTextEvent() {
        GtkGenericPeer.q().postEvent(new TextEvent(this.awtComponent, 900));
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        return graphicsDevice.getDefaultConfiguration();
    }

    public void setEventMask(long l) {
    }

    public boolean isFocusable() {
        return false;
    }

    public boolean requestFocus(Component component, boolean bl, boolean bl2, long l) {
        if (!$assertionsDisabled && component != this.awtComponent && !this.isLightweightDescendant(component)) {
            throw new AssertionError();
        }
        boolean bl3 = false;
        if (this.gtkWidgetHasFocus()) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component component2 = keyboardFocusManager.getFocusOwner();
            if (component2 == component) {
                bl3 = true;
            } else {
                this.postFocusEvent(1004, bl);
                bl3 = true;
            }
        } else if (this.gtkWidgetCanFocus()) {
            Window window;
            GtkWindowPeer gtkWindowPeer;
            if (bl2 && !(gtkWindowPeer = (GtkWindowPeer)(window = this.getWindowFor(component)).getPeer()).gtkWindowHasFocus()) {
                gtkWindowPeer.requestWindowFocus();
            }
            this.gtkWidgetRequestFocus();
            bl3 = true;
        }
        return bl3;
    }

    private Window getWindowFor(Component component) {
        Component component2 = component;
        while (!(component2 instanceof Window)) {
            component2 = component2.getParent();
        }
        return (Window)component2;
    }

    protected boolean isLightweightDescendant(Component component) {
        Component component2 = component;
        while (component2.getPeer() instanceof LightweightPeer) {
            component2 = component2.getParent();
        }
        return this.awtComponent == component2;
    }

    public boolean isObscured() {
        return false;
    }

    public boolean canDetermineObscurity() {
        return false;
    }

    public void coalescePaintEvent(PaintEvent paintEvent) {
    }

    public void updateCursorImmediately() {
        if (this.awtComponent.getCursor() != null) {
            this.setCursor(this.awtComponent.getCursor());
        }
    }

    public boolean handlesWheelScrolling() {
        return false;
    }

    public VolatileImage createVolatileImage(int n, int n2) {
        return new GtkVolatileImage(this, n, n2, null);
    }

    public void createBuffers(int n, BufferCapabilities bufferCapabilities) throws AWTException {
        if (n != 2) {
            throw new AWTException("GtkComponentPeer.createBuffers: multi-buffering not supported");
        }
        this.backBuffer = new GtkVolatileImage(this, this.awtComponent.getWidth(), this.awtComponent.getHeight(), bufferCapabilities.getBackBufferCapabilities());
        this.caps = bufferCapabilities;
    }

    public Image getBackBuffer() {
        return this.backBuffer;
    }

    public void flip(BufferCapabilities.FlipContents flipContents) {
        this.getGraphics().drawImage(this.backBuffer, this.awtComponent.getWidth(), this.awtComponent.getHeight(), null);
        if (flipContents == BufferCapabilities.FlipContents.BACKGROUND) {
            this.backBuffer = this.createVolatileImage(this.awtComponent.getWidth(), this.awtComponent.getHeight());
            this.backBuffer.getGraphics().clearRect(0, 0, this.awtComponent.getWidth(), this.awtComponent.getHeight());
        }
    }

    public void destroyBuffers() {
        this.backBuffer.flush();
    }

    public String toString() {
        return "peer of " + this.awtComponent.toString();
    }

    public Rectangle getBounds() {
        return null;
    }

    public void reparent(ContainerPeer containerPeer) {
    }

    public void setBounds(int n, int n2, int n3, int n4, int n5) {
        this.setBounds(n, n2, n3, n4);
    }

    public boolean isReparentSupported() {
        return false;
    }

    public void layout() {
    }

    static {
        $assertionsDisabled = GtkComponentPeer.class$("gnu.java.awt.peer.gtk.GtkComponentPeer").desiredAssertionStatus() ^ true;
    }

    private static class RepaintTimerTask
    extends TimerTask {
        private static final Timer repaintTimer = new Timer(true);
        private int x;
        private int y;
        private int width;
        private int height;
        private Component awtComponent;

        RepaintTimerTask(Component component, int n, int n2, int n3, int n4) {
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
            this.awtComponent = component;
        }

        public void run() {
            GtkGenericPeer.q().postEvent(new PaintEvent(this.awtComponent, 801, new Rectangle(this.x, this.y, this.width, this.height)));
        }

        static void schedule(long l, int n, int n2, int n3, int n4, Component component) {
            repaintTimer.schedule((TimerTask)new RepaintTimerTask(component, n, n2, n3, n4), l);
        }
    }
}

