module Examples.Effects.ShiftByOneOctave where

import qualified Prelude
import Feldspar
import Feldspar.Vector
import Feldspar.Compiler

-- | Generic (not compilable) algorithm to double the frequency of a signal.
-- This is an approximate solution without using FFT.
shiftByOneOctave :: (Fractional' a) => DVector a -> DVector a
shiftByOneOctave inp = half ++ half
    where
        half = everySecond $ map avg $ zip inp $ tail inp
        everySecond xs = indexed (length xs `div` 2) $ \idx -> xs ! (2*idx)
        avg (x,y) = (x + y) / 2

-- | Wrapper to fix the type and size of the vectors in shiftByOneOctave.
shiftByOneOctaveInstance :: Data [Float] -> Data [Float]
shiftByOneOctaveInstance input = freezeVector $ shiftByOneOctave input'
    where
        input' = unfreezeVector' 256 input

-- | Wrapper to fix the type and size of the vectors in shiftByOneOctave.
shiftByOneOctave_wrapped :: Data' D256 [Float] ->  Data [Float]
shiftByOneOctave_wrapped = wrap (shiftByOneOctave :: DVector Float -> DVector Float)