/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.testunit.views;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IOpenEventListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.rubypeople.rdt.internal.ui.util.StackTraceLine;
import org.rubypeople.rdt.testunit.views.CompareResultsAction;
import org.rubypeople.rdt.testunit.views.CopyTraceAction;
import org.rubypeople.rdt.testunit.views.TestRunInfo;
import org.rubypeople.rdt.testunit.views.TestUnitMessages;
import org.rubypeople.rdt.testunit.views.TestUnitView;

class FailureTrace
implements IMenuListener {
    private final Image fStackIcon = TestUnitView.createImage("obj16/stkfrm_obj.gif");
    private final Image fExceptionIcon = TestUnitView.createImage("obj16/exc_catch.gif");
    private Table fTable;
    private String fInputTrace;
    private final Clipboard fClipboard;
    private TestRunInfo fFailure;
    private CompareResultsAction fCompareAction;

    public FailureTrace(Composite composite, Clipboard clipboard, TestUnitView testUnitView, ToolBar toolBar) {
        Assert.isNotNull((Object)clipboard);
        ToolBarManager toolBarManager = new ToolBarManager(toolBar);
        this.fCompareAction = new CompareResultsAction(this);
        this.fCompareAction.setEnabled(false);
        toolBarManager.add((IAction)this.fCompareAction);
        toolBarManager.update(true);
        this.fTable = new Table(composite, 772);
        this.fClipboard = clipboard;
        OpenStrategy openStrategy = new OpenStrategy((Control)this.fTable);
        openStrategy.addOpenListener(new IOpenEventListener(){

            public void handleOpen(SelectionEvent selectionEvent) {
                Action action;
                if (FailureTrace.this.fTable.getSelectionIndex() == 0 && FailureTrace.this.fFailure.isComparisonFailure()) {
                    new CompareResultsAction(FailureTrace.this).run();
                }
                if (FailureTrace.this.fTable.getSelection().length != 0 && (action = FailureTrace.this.createOpenEditorAction(FailureTrace.this.getSelectedText())) != null) {
                    action.run();
                }
            }
        });
        this.initMenu();
        this.fTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                new StackTraceLine(FailureTrace.this.getSelectedText()).openEditor();
            }
        });
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                FailureTrace.this.disposeIcons();
            }
        });
    }

    private void initMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        Menu menu = menuManager.createContextMenu((Control)this.fTable);
        this.fTable.setMenu(menu);
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        if (this.fTable.getSelectionCount() > 0) {
            Action action = this.createOpenEditorAction(this.getSelectedText());
            if (action != null) {
                iMenuManager.add((IAction)action);
            }
            iMenuManager.add((IAction)new CopyTraceAction(this, this.fClipboard));
        }
        if (this.fFailure != null && this.fFailure.isComparisonFailure()) {
            iMenuManager.add((IAction)new CompareResultsAction(this));
        }
    }

    public String getTrace() {
        return this.fInputTrace;
    }

    private String getSelectedText() {
        return this.fTable.getSelection()[0].getText();
    }

    private Action createOpenEditorAction(String string) {
        return new OpenEditorAction(new StackTraceLine(string));
    }

    private void disposeIcons() {
        if (this.fExceptionIcon != null && !this.fExceptionIcon.isDisposed()) {
            this.fExceptionIcon.dispose();
        }
        if (this.fStackIcon != null && !this.fStackIcon.isDisposed()) {
            this.fStackIcon.dispose();
        }
    }

    Composite getComposite() {
        return this.fTable;
    }

    public void refresh() {
        this.updateTable(this.fInputTrace);
    }

    public void showFailure(TestRunInfo testRunInfo) {
        this.fFailure = testRunInfo;
        String string = "";
        this.updateEnablement(testRunInfo);
        if (testRunInfo != null) {
            string = testRunInfo.getTrace();
        }
        if (this.fInputTrace == string) {
            return;
        }
        this.fInputTrace = string;
        this.updateTable(string);
    }

    public void updateEnablement(TestRunInfo testRunInfo) {
        this.fCompareAction.setEnabled(testRunInfo != null && testRunInfo.isComparisonFailure());
    }

    private void updateTable(String string) {
        if (string == null || string.trim().equals("")) {
            this.clear();
            return;
        }
        string = string.trim();
        this.fTable.setRedraw(false);
        this.fTable.removeAll();
        this.fillTable(this.filterStack(string));
        this.fTable.setRedraw(true);
    }

    private void fillTable(String string) {
        StringReader stringReader = new StringReader(string);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        try {
            String string2 = bufferedReader.readLine();
            if (string2 == null) {
                return;
            }
            TableItem tableItem = new TableItem(this.fTable, 0);
            String string3 = string2.replace('\t', ' ');
            tableItem.setText(string3);
            tableItem.setImage(this.fExceptionIcon);
            while ((string2 = bufferedReader.readLine()) != null) {
                string3 = string2.replace('\t', ' ');
                tableItem = new TableItem(this.fTable, 0);
                if (string3.indexOf(" at ") >= 0) {
                    tableItem.setImage(this.fStackIcon);
                }
                tableItem.setText(string3);
            }
        }
        catch (IOException iOException) {
            TableItem tableItem = new TableItem(this.fTable, 0);
            tableItem.setText(string);
        }
    }

    public void setInformation(String string) {
        this.clear();
        TableItem tableItem = new TableItem(this.fTable, 0);
        tableItem.setText(string);
    }

    public void clear() {
        this.fTable.removeAll();
        this.fInputTrace = null;
    }

    private String filterStack(String string) {
        return string;
    }

    public TestRunInfo getFailedTest() {
        return this.fFailure;
    }

    public Shell getShell() {
        return this.fTable.getShell();
    }

    private class OpenEditorAction
    extends Action {
        private final StackTraceLine trace;

        public OpenEditorAction(StackTraceLine stackTraceLine) {
            super(TestUnitMessages.getString("OpenEditor.action.label"));
            this.trace = stackTraceLine;
        }

        public void run() {
            this.trace.openEditor();
        }
    }
}

