/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.Hierarchy;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionHandlerMap {
    private IdentityHashMap<InstructionHandle, List<CodeExceptionGen>> codeToHandlerMap = new IdentityHashMap();
    private IdentityHashMap<InstructionHandle, CodeExceptionGen> startInstructionToHandlerMap = new IdentityHashMap();

    public ExceptionHandlerMap(MethodGen methodGen) {
        this.build(methodGen);
    }

    public List<CodeExceptionGen> getHandlerList(InstructionHandle handle) {
        return this.codeToHandlerMap.get(handle);
    }

    public CodeExceptionGen getHandlerForStartInstruction(InstructionHandle start) {
        return this.startInstructionToHandlerMap.get(start);
    }

    private void build(MethodGen methodGen) {
        CodeExceptionGen[] handlerList;
        for (CodeExceptionGen exceptionHandler : handlerList = methodGen.getExceptionHandlers()) {
            this.startInstructionToHandlerMap.put(exceptionHandler.getHandlerPC(), exceptionHandler);
        }
        block1: for (InstructionHandle handle = methodGen.getInstructionList().getStart(); handle != null; handle = handle.getNext()) {
            int offset = handle.getPosition();
            for (CodeExceptionGen exceptionHandler : handlerList) {
                int startOfRange = exceptionHandler.getStartPC().getPosition();
                int endOfRange = exceptionHandler.getEndPC().getPosition();
                if (offset < startOfRange || offset > endOfRange) continue;
                this.addHandler(handle, exceptionHandler);
                if (Hierarchy.isUniversalExceptionHandler(exceptionHandler.getCatchType())) continue block1;
            }
        }
    }

    private void addHandler(InstructionHandle handle, CodeExceptionGen exceptionHandler) {
        List<CodeExceptionGen> handlerList = this.codeToHandlerMap.get(handle);
        if (handlerList == null) {
            handlerList = new LinkedList<CodeExceptionGen>();
            this.codeToHandlerMap.put(handle, handlerList);
        }
        handlerList.add(exceptionHandler);
    }
}

