tm Module

Bogdan-Andrei Iancu

   voice-system.ro

Jiri Kuthan

   FhG FOKUS

Juha Heinanen

   <jh@tutpro.com>

Edited by

Jiri Kuthan

Edited by

Bogdan-Andrei Iancu

Edited by

Juha Heinanen

   Copyright  2003 FhG FOKUS

   Copyright  2005 voice-system.ro

   Copyright  2008 Juha Heinanen
   Revision History
   Revision $Revision: 5797 $ $Date: 2008-10-22 10:03:56 +0200
                              (Mi, 22 Okt 2008) $
     __________________________________________________________

   Table of Contents

   1. Admin Guide

        1.1. Overview

              1.1.1. Per-Branch flags
              1.1.2. Timer-Based Failover
              1.1.3. DNS Failover

        1.2. Dependencies

              1.2.1. Kamailio Modules
              1.2.2. External Libraries or Applications

        1.3. Exported Parameters

              1.3.1. fr_timer (integer)
              1.3.2. fr_inv_timer (integer)
              1.3.3. wt_timer (integer)
              1.3.4. delete_timer (integer)
              1.3.5. T1_timer (integer)
              1.3.6. T2_timer (integer)
              1.3.7. ruri_matching (integer)
              1.3.8. via1_matching (integer)
              1.3.9. unix_tx_timeout (integer)
              1.3.10. restart_fr_on_each_reply (integer)
              1.3.11. fr_timer_avp (string)
              1.3.12. fr_inv_timer_avp (string)
              1.3.13. tw_append (string)
              1.3.14. enable_stats (integer)
              1.3.15. pass_provisional_replies (integer)
              1.3.16. syn_branch (integer)
              1.3.17. onreply_avp_mode (integer)
              1.3.18. disable_6xx_block (integer)
              1.3.19. fr_inv_timer_next (integer)
              1.3.20. contacts_avp (string)

        1.4. Exported Functions

              1.4.1. t_newtran()
              1.4.2. t_relay([flags])
              1.4.3. t_relay(proto:host:port,[flags])
              1.4.4. t_reply(code, reason_phrase)
              1.4.5. t_replicate(URI,[flags])
              1.4.6. t_release()
              1.4.7. t_check_status(re)
              1.4.8. t_flush_flags()
              1.4.9. t_local_replied(reply)
              1.4.10. t_write_req(info,fifo)
                      t_write_unix(info,sock)

              1.4.11. t_check_trans()
              1.4.12. t_was_cancelled()
              1.4.13. t_on_failure(failure_route)
              1.4.14. t_on_reply(reply_route)
              1.4.15. t_on_branch(branch_route)
              1.4.16. t_load_contacts()
              1.4.17. t_next_contacts()
              1.4.18. t_cancel_branches(which)

        1.5. Exported pseudo-variables
        1.6. Exported MI Functions

              1.6.1. t_uac_dlg
              1.6.2. t_uac_cancel
              1.6.3. t_hash
              1.6.4. t_reply

        1.7. Exported statistics

              1.7.1. received_replies
              1.7.2. relayed_replies
              1.7.3. local_replies
              1.7.4. UAS_transactions
              1.7.5. UAC_transactions
              1.7.6. 2xx_transactions
              1.7.7. 3xx_transactions
              1.7.8. 4xx_transactions
              1.7.9. 5xx_transactions
              1.7.10. 6xx_transactions
              1.7.11. inuse_transactions

   2. Developer Guide

        2.1. Functions

              2.1.1. load_tm(*import_structure)

   List of Examples

   1.1. Set fr_timer parameter
   1.2. Set fr_inv_timer parameter
   1.3. Set wt_timer parameter
   1.4. Set delete_timer parameter
   1.5. Set T1_timer parameter
   1.6. Set T2_timer parameter
   1.7. Set ruri_matching parameter
   1.8. Set via1_matching parameter
   1.9. Set unix_tx_timeout parameter
   1.10. Set restart_fr_on_each_reply parameter
   1.11. Set fr_timer_avp parameter
   1.12. Set fr_inv_timer_avp parameter
   1.13. Set tw_append parameter
   1.14. enable_stats example
   1.15. Set pass_provisional_replies parameter
   1.16. Set syn_branch parameter
   1.17. Set onreply_avp_mode parameter
   1.18. Set disable_6xx_block parameter
   1.19. Set fr_inv_timer_next parameter
   1.20. Set contacts_avp parameter
   1.21. t_newtran usage
   1.22. t_relay usage
   1.23. t_relay usage
   1.24. t_reply usage
   1.25. t_replicate usage
   1.26. t_release usage
   1.27. t_check_status usage
   1.28. t_flush_flags usage
   1.29. t_local_replied usage
   1.30. t_write_req/unix usage
   1.31. t_check_trans usage
   1.32. t_was_cancelled usage
   1.33. t_on_failure usage
   1.34. t_on_reply usage
   1.35. t_on_branch usage
   1.36. t_load_contacts usage
   1.37. t_next_contacts usage
   1.38. t_cancel_branches usage

Chapter 1. Admin Guide

1.1. Overview

   TM module enables stateful processing of SIP transactions. The
   main use of stateful logic, which is costly in terms of memory
   and CPU, is some services inherently need state. For example,
   transaction-based accounting (module acc) needs to process
   transaction state as opposed to individual messages, and any
   kinds of forking must be implemented statefully. Other use of
   stateful processing is it trading CPU caused by retransmission
   processing for memory. That makes however only sense if CPU
   consumption per request is huge. For example, if you want to
   avoid costly DNS resolution for every retransmission of a
   request to an unresolvable destination, use stateful mode.
   Then, only the initial message burdens server by DNS queries,
   subsequent retransmissions will be dropped and will not result
   in more processes blocked by DNS resolution. The price is more
   memory consumption and higher processing latency.

   From user's perspective, the major function is t_relay(). It
   setup transaction state, absorb retransmissions from upstream,
   generate downstream retransmissions and correlate replies to
   requests.

   In general, if TM is used, it copies clones of received SIP
   messages in shared memory. That costs the memory and also CPU
   time (memcpys, lookups, shmem locks, etc.) Note that non-TM
   functions operate over the received message in private memory,
   that means that any core operations will have no effect on
   statefully processed messages after creating the transactional
   state. For example, calling record_route after t_relay is
   pretty useless, as the RR is added to privately held message
   whereas its TM clone is being forwarded.

   TM is quite big and uneasy to program--lot of mutexes, shared
   memory access, malloc and free, timers--you really need to be
   careful when you do anything. To simplify TM programming, there
   is the instrument of callbacks. The callback mechanisms allow
   programmers to register their functions to specific event. See
   t_hooks.h for a list of possible events.

   Other things programmers may want to know is UAC--it is a very
   simplistic code which allows you to generate your own
   transactions. Particularly useful for things like NOTIFYs or IM
   gateways. The UAC takes care of all the transaction machinery:
   retransmissions , FR timeouts, forking, etc. See t_uac
   prototype in uac.h for more details. Who wants to see the
   transaction result may register for a callback.

1.1.1. Per-Branch flags

   First what is the idea with the branch concept: branch route is
   a route to be execute separately for each branch before being
   sent out - changes in that route should reflect only on that
   branch.

   There are several types of flags in Kamailio :
     * message/transaction flags - they are visible everywhere in
       the transaction (in all routes and in all sequential
       replies/request).
     * branch flags - flags that are visible only from a specific
       branch - in all replies and routes connected to this
       branch.
       script flags - flags that exist only during script
       execution. They are not store anywhere and are lost once
       the top level route was left.

   For example: I have a call parallel forking to GW and to a
   user. And I would like to know from which branch I will get the
   final negative reply (if so). I will set a branch route before
   relaying the calls (with the 2 branches). The branch route will
   be separately executed for each branch; in the branch going to
   GW (I can identified it by looking to RURI), I will set a
   branch flag. This flag will appear only in the onreply route
   run for replied from GW. It will be also be visible in failure
   route if the final elected reply belongs to the GW branch. This
   flags will not be visible in the other branch (in routes
   executing replies from the other branch).

   For how to define branch flags and use via script, see
   Section 1.4.15, " t_on_branch(branch_route) " and the
   setbflag(), resetbflag() and isbflagset() script functions.

   Also, modules may set branch flags before transaction creation.
   The REGISTRAR module was the first to use this type of flags.
   The NAT flag is pushed in branch flags instead in message
   flags.

1.1.2. Timer-Based Failover

   Timers can be used to trigger failover behavior. E.g. if we
   send a call a gateway and the gateway does not send a
   provisional response within 3 seconds, we want to cancel this
   call and send the call to another gateway. Another example is
   to ring a SIP client only for 30 seconds and then redirect the
   call to the voicemail.

   There are two timers in Kamailio :
     * fr_timer - this timer is used when no response was received
       yet. If there is no response after fr_timer seconds the
       timer triggers (and failure route will be executed if
       t_on_failure() was called). If a provisional response was
       received, the timer is set to fr_inv_timer for INVITE
       transactions, and RT_T2 for all other transactions. If a
       final reponse is received, the transaction has finished.
     * fr_inv_timer - this timer is used when a provisional
       reponse was received for an INVITE transaction.

   For example: You want to have failover if there is no
   provisional response after 3 seconds, but you want to ring for
   60 seconds. Thuse, set the fr_timer to 3 and fr_inv_timer to
   60.

1.1.3. DNS Failover

   DNS based failover can be use when relaying stateful requests.
   According to RFC 3263, DNS failover should be done on transport
   level or transaction level. TM module supports them both.

   Failover at transport level may be triggered by a failure of
   sending out the request message. A failure occurs if the
   corresponding interface was found for sending the request, if
   the TCP connection was refused or if a generic internal error
   happened during send. There is no ICMP error report support.

   Failover at transaction level may be triggered when the
   transaction completed either with a 503 reply, either with a
   timeout without any received reply. In such a case,
   automatically, a new branch will be forked if any other
   destination IPs can be used to deliver the requests. The new
   branch will be a clone of the winning branch.

   The set of destinations IPs is step-by-step build (on demand)
   based on the NAPTR, SRV and A records available for the
   destination domain.

   DNS-based failover is by default applied excepting when this
   failover is globally disabled (see the core parameter
   disable_dns_failover) or when the relay flag (per transaction)
   is set (see the t_relay() function).

1.2. Dependencies

1.2.1. Kamailio Modules

   The following modules must be loaded before this module:
     * No dependencies on other Kamailio modules.

1.2.2. External Libraries or Applications

   The following libraries or applications must be installed
   before running Kamailio with this module loaded:
     * None.

1.3. Exported Parameters

1.3.1. fr_timer (integer)

   Timer which hits if no final reply for a request or ACK for a
   negative INVITE reply arrives (in seconds).

   Default value is 30 seconds.

   Example 1.1. Set fr_timer parameter
...
modparam("tm", "fr_timer", 10)
...

1.3.2. fr_inv_timer (integer)

   Timer which hits if no final reply for an INVITE arrives after
   a provisional message was received (in seconds). This timer is
   started after the first provisional response. Thus, fast
   failover (no 100 trying from gateway) can be achieved by
   setting fr_timer to low values. See example below

   Default value is 120 seconds.

   Example 1.2. Set fr_inv_timer parameter
...
modparam("tm", "fr_inv_timer", 200)
...

1.3.3. wt_timer (integer)

   Time for which a transaction stays in memory to absorb delayed
   messages after it completed; also, when this timer hits,
   retransmission of local cancels is stopped (a puristic but
   complex behavior would be not to enter wait state until local
   branches are finished by a final reply or FR timer--we
   simplified).

   For non-INVITE transaction this timer relates to timer J of RFC
   3261 section 17.2.2. According to the RFC this timer should be
   64*T1 (= 32 seconds). But this would increase memory usage as
   the transactions are kept in memory very long.

   Default value is 5 seconds.

   Example 1.3. Set wt_timer parameter
...
modparam("tm", "wt_timer", 10)
...

1.3.4. delete_timer (integer)

   Time after which a to-be-deleted transaction currently ref-ed
   by a process will be tried to be deleted again.

   Default value is 2 seconds.

   Example 1.4. Set delete_timer parameter
...
modparam("tm", "delete_timer", 5)
...

1.3.5. T1_timer (integer)

   Retransmission T1 period, in milliseconds.

   Default value is 500 milliseconds.

   Example 1.5. Set T1_timer parameter
...
modparam("tm", "T1_timer", 700)
...

1.3.6. T2_timer (integer)

   Maximum retransmission period, in milliseconds.

   Default value is 4000 milliseconds.

   Example 1.6. Set T2_timer parameter
...
modparam("tm", "T2_timer", 8000)
...

1.3.7. ruri_matching (integer)

   Should be request-uri matching used as a part of pre-3261
   transaction matching as the standard wants us to do so? Turn
   only off for better interaction with devices that are broken
   and send different r-uri in CANCEL/ACK than in original INVITE.

   Default value is 1 (true).

   Example 1.7. Set ruri_matching parameter
...
modparam("tm", "ruri_matching", 0)
...

1.3.8. via1_matching (integer)

   Should be top most VIA matching used as a part of pre-3261
   transaction matching as the standard wants us to do so? Turn
   only off for better interaction with devices that are broken
   and send different top most VIA in CANCEL/ACK than in original
   INVITE.

   Default value is 1 (true).

   Example 1.8. Set via1_matching parameter
...
modparam("tm", "via1_matching", 0)
...

1.3.9. unix_tx_timeout (integer)

   Send timeout to be used by function which use UNIX sockets (as
   t_write_unix).

   Default value is 2 seconds.

   Example 1.9. Set unix_tx_timeout parameter
...
modparam("tm", "unix_tx_timeout", 5)
...

1.3.10. restart_fr_on_each_reply (integer)

   If true (non null value), the final response timer will be
   re-triggered for each received provisional reply. In this case,
   final response timeout may occure after a time longer than
   fr_inv_timer (if UAS keeps sending provisional replies).

   Default value is 1 (true).

   Example 1.10. Set restart_fr_on_each_reply parameter
...
modparam("tm", "restart_fr_on_each_reply", 0)
...

1.3.11. fr_timer_avp (string)

   Full specification (NAME, ID, Alias) of an AVP which contains a
   final response timeout value. If present, this value will
   override the static fr_timer parameter.

   If you set the AVP to an empty string, the whole mechanism for
   variable timeout will be disabled, falling back to the static
   value. Note that if you set this parameter to an empty string,
   a value of zero will be used.

   Default value is "NULL" (feature disabled).

   Example 1.11. Set fr_timer_avp parameter
...
modparam("tm", "fr_timer_avp", "$avp(i:24)")
...

1.3.12. fr_inv_timer_avp (string)

   Full specification (NAME, ID, Alias) of an AVP which contains a
   final INVITE response timeout value. If present, this value
   will override the static fr_inv_timer parameter.

   If set the AVP to an to empty string, the whole mechanism for
   variable timeout will be disabled, falling back to the static
   value. Note that if you set this parameter to an empty string,
   a value of zero will be used.

   Default value is "NULL" (feature disabled).

   Example 1.12. Set fr_inv_timer_avp parameter
...
modparam("tm", "fr_inv_timer_avp", "$avp(i:25)")
...

1.3.13. tw_append (string)

   List of additional information to be appended by t_write_req
   and t_write_unix functions.

   Default value is null string.

   Syntax of the parameter is:
     * tw_append = append_name':' element (';'element)*
     * element = ( [name '='] pseudo_variable)

   The full list of supported pseudo-variables in Kamailio is
   available at:
   http://kamailio.org/docs/pseudo-variables-1.1.x.html

   Each element will be appended per line in "name: value" format.
   Element "$rb (message body)" is the only one which does not
   accept name; the body it will be printed all the time at the
   end, disregarding its position in the definition string.

   Example 1.13. Set tw_append parameter
...
modparam("tm", "tw_append",
   "test: ua=$hdr(User-Agent) ;avp=$avp(i:10);$rb;time=$Ts")
...

1.3.14. enable_stats (integer)

   If the module should generate and export statistics to the core
   manager. A zero value means disabled.

   The TM module provides statistics about how many transaction
   were created (splitted per code classes), how many transaction
   are currently in use and some other values.

   Default value is 1 (enabled).

   Example 1.14. enable_stats example
modparam("tm", "enable_stats", 0)

1.3.15. pass_provisional_replies (integer)

   Enable/disable passing of provisional replies to FIFO
   applications.

   Default value is 0.

   Example 1.15. Set pass_provisional_replies parameter
...
modparam("tm", "pass_provisional_replies", 1)
...

1.3.16. syn_branch (integer)

   Enable/disable the usage of stateful synonym branch IDs in the
   generated Via headers. They are faster but not reboot-safe.

   Default value is 1 (use synonym branches).

   Example 1.16. Set syn_branch parameter
...
modparam("tm", "syn_branch", 0)
...

1.3.17. onreply_avp_mode (integer)

   Describes how the AVPs should be handled in reply route:
     * 0 - the AVPs will be per message only; they will not
       interfere with the AVPS stored in transaction; initially
       there will be an empty list and at the end of the route,
       all AVPs that were created will be discarded.
     * 1 - the AVPs will be the transaction AVPs; initially the
       transaction AVPs will be visible; at the end of the route,
       the list will attached back to transaction (with all the
       changes)

   In mode 1, you can see the AVPs you set in request route,
   branch route or failure route. The side efect is performance as
   more locking is required in order to keep the AVP's list
   integrity.

   Default value is 0.

   Example 1.17. Set onreply_avp_mode parameter
...
modparam("tm", "onreply_avp_mode", 1)
...

1.3.18. disable_6xx_block (integer)

   Tells how the 6xx replies should be internally handled:
     * 0 - the 6xx replies will block any further serial forking
       (adding new branches). This is the RFC3261 behaviour.
     * 1 - the 6xx replies will be handled as any other negative
       reply - serial forking will be allowed. Logically, you need
       to break RFC3261 if you want to do redirects to
       announcement and voicemail services.

   Default value is 0.

   Example 1.18. Set disable_6xx_block parameter
...
modparam("tm", "disable_6xx_block", 1)
...

1.3.19. fr_inv_timer_next (integer)

   Value of the Final Response timeout for INVITE transactions to
   be used during serial forwarding:

   Function t_next_contacts() sets fr_inv_timer to
   fr_inv_timer_next value if, after t_next_contacts() is called,
   there are still lower qvalue contacts available, and to
   fr_inv_timer value if there are not.

   Default value is 30.

   Example 1.19. Set fr_inv_timer_next parameter
...
modparam("tm", "fr_inv_timer_next", 10)
...

1.3.20. contacts_avp (string)

   Internal AVP that t_load_contacts() function uses to store
   contacts of the destination set and that t_next_contacts()
   function uses to restore those contacts.

   Default value is "NULL" (t_load_contacts()/t_next_contacts()
   functions are disabled).

   Example 1.20. Set contacts_avp parameter
...
modparam("tm", "contacts_avp", "$avp(i:25)")
...

1.4. Exported Functions

1.4.1.  t_newtran()

   Creates a new transaction, returns a negative value on error.
   This is the only way a script can add a new transaction in an
   atomic way. Typically, it is used to deploy a UAS.

Warning

   NOTE that the changes on the request that are made after this
   function call will not be saved into transaction!!!

   This function can be used from REQUEST_ROUTE.

   Example 1.21. t_newtran usage
...
if (t_newtran()) {
        log("UAS logic");
        t_reply("999","hello");
} else sl_reply_error();
...

1.4.2.  t_relay([flags])

   Relay a message statefully to destination indicated in current
   URI. (If the original URI was rewritten by UsrLoc, RR,
   strip/prefix, etc., the new URI will be taken). Returns a
   negative value on failure--you may still want to send a
   negative reply upstream statelessly not to leave upstream UAC
   in lurch.

   The coresponding transaction may or may not be already created.
   If not yet created, the function will automatically create it.

   The function may take as parameter an optional set of flags for
   controlling the internal behaviour. The flags may be given in
   decimal or hexa format; supported flags are:
     * 0x01 - do not generate an 100 trying provisional reply when
       building the transaction. By default one is generated.
       Useful if you already pushed an stateless 100 reply from
       script.
     * 0x02 - do not internally send a negative reply in case of
       forward failure (due internal error, bad RURI, bad message,
       etc). When a forward failure occurs, no SIP request is
       relayed and therefore no negative reply or timeout will
       show up on the failure_route (if one is set). It applies
       only when the transaction is created. By default one
       negative reply is sent. Useful if you want to implement a
       serial forking in case of failure.
     * 0x04 - disable the DNS failover for the transaction. Only
       first IP will be used. It disable the failover both at
       transaport and transaction level.

   In case of error, the function returns the following codes:
     * -1 - generic internal error
     * -2 - bad message (parsing errors)
     * -3 - no destination available (no branches were added or
       request already cancelled)
     * -4 - bad destination (unresolvable address)
     * -5 - destination filtered (black listed)
     * -6 - generic send failed

   This function can be used from REQUEST_ROUTE, FAILURE_ROUTE.

   Example 1.22. t_relay usage
...
if (!t_relay()) {
    sl_reply_error();
    exit;
}
...

1.4.3.  t_relay(proto:host:port,[flags])

   Relay a message statefully to a fixed destination. The
   destination is specified as "[proto:]host[:port]". If a
   destination URI "$du" for this message was set before the
   function is called then this value will be used as destination
   instead of the function parameter.

   The function may take as parameter an optional set of flags for
   controlling the internal behaviour - for details see the above
   "t_relay([flags])" function.

   This functions can be used from REQUEST_ROUTE, FAILURE_ROUTE.

   NOTE: the first parameter can take only static values. If you
   need to set next hop (proxy) destination via some script
   variable, set the value of destination URI variable: $du. $du
   takes as value a SIP URI, so "proto:host:port" translates in:
   "sip:host:port;transport=proto". Once you set the $du use
   t_relay() without proxy address parameter.

   Example 1.23. t_relay usage
...
t_relay("tcp:192.168.1.10:5060");
t_relay("mydomain.com:5070","0x1");
t_relay("udp:mydomain.com");
...

1.4.4.  t_reply(code, reason_phrase)

   Sends a stateful reply after a transaction has been
   established. See t_newtran for usage.

   Meaning of the parameters is as follows:
     * code - Reply code number.
     * reason_phrase - Reason string.

   Both parameters accept any kind of pseudo-variables.

   This function can be used from REQUEST_ROUTE, FAILURE_ROUTE.

   Example 1.24. t_reply usage
...
t_reply("404", "Use $rU not found");
...

1.4.5.  t_replicate(URI,[flags])

   Replicates a request to another destination. No information due
   the replicated request (like reply code) will be forwarded to
   the original SIP UAC.

   The destination is specified by a SIP URI. If multiple
   destinations are to be used, the additional SIP URIs have to be
   set as branches.

   The function may take as parameter an optional set of flags for
   controlling the internal behaviour - for description see the
   above "t_relay([flags])" function. Note that only 0x4 is
   applicable here.

   This functions can be used from REQUEST_ROUTE.

   Example 1.25. t_replicate usage
...
t_replicate("sip:1.2.3.4:5060");
t_replicate("sip:1.2.3.4:5060;transport=tcp");
t_replicate("sip:1.2.3.4","0x4");
...

1.4.6.  t_release()

   Remove transaction from memory (it will be first put on a wait
   timer to absorb delayed messages).

   This function can be used from REQUEST_ROUTE.

   Example 1.26. t_release usage
...
t_release();
...

1.4.7.  t_check_status(re)

   Returns true if the regualr expresion "re" match the reply code
   of the response message as follows:
     * in routing block - the code of the last sent reply.
     * in on_reply block - the code of the current received reply.
     * in on_failure block - the code of the selected negative
       final reply.

   This function can be used from REQUEST_ROUTE, ONREPLY_ROUTE,
   FAILURE_ROUTE and BRANCH_ROUTE .

   Example 1.27. t_check_status usage
...
if (t_check_status("(487)|(408)")) {
    log("487 or 408 negative reply\n");
}
...

1.4.8.  t_flush_flags()

   Flush the flags from current request into the already created
   transaction. It make sense only in routing block if the
   transaction was created via t_newtran() and the flags have been
   altered since.

   This function can be used from REQUEST_ROUTE and BRANCH_ROUTE .

   Example 1.28. t_flush_flags usage
...
t_flush_flags();
...

1.4.9.  t_local_replied(reply)

   Returns true if all or last (depending of the parameter)
   reply(es) were local generated (and not received).

   Parameter may be "all" or "last".

   This function can be used from REQUEST_ROUTE, BRANCH_ROUTE,
   FAILURE_ROUTE and ONREPLY_ROUTE.

   Example 1.29. t_local_replied usage
...
if (t_local_replied("all")) {
        log ("no reply received\n");
}
...

1.4.10.  t_write_req(info,fifo) t_write_unix(info,sock)

   Write via FIFO interface or UNIX socket a lot of information
   regarding the request. Which information should be written may
   be control via the "tw_append" parameter.

   This functions can be used from REQUEST_ROUTE, FAILURE_ROUTE
   and BRANCH_ROUTE.

   Example 1.30. t_write_req/unix usage
...
modparam("tm","tw_append","append1:Email=avp[i:12];UA=hdr[User-Agent]")
modparam("tm","tw_append","append2:body=msg[body]")
...
t_write_req("voicemail/append1","/tmp/appx_fifo");
...
t_write_unix("logger/append2","/var/run/logger.sock");
...

1.4.11.  t_check_trans()

   Returns true if the current SIP message is associated to a
   transaction. The relationship between the SIP request and
   transaction is defined as follow:
     * non-CANCEL/non-ACK requests - if the request belongs to a
       transaction (it's a retransmision), the function will do a
       standard processing of the retransmission and will
       break/stop the script. The function return false if the
       request is not a retransmission.
     * CANCEL request - true if the cancelled INVITE transaction
       exists.
     * ACK request - true if the ACK is a local end-to-end ACK
       corresponding to an previous INVITE transaction.

   For SIP reply processing, the function returns:
     * true (return code 1) - when the SIP reply matches an
       existing transaction in memory
     * false (return code -1) - when the SIP reply does not match
       any existing transaction in memory

   Note: To detect retransmissions using this function you have to
   make sure that the initial request has already created a
   transaction, e.g. by using t_relay(). If the processing of
   requests may take long time (e.g. DB lookups) and the
   retransmission arrives before t_relay() is called, you can use
   the t_newtran() function to manually create a transaction.

   This function can be used from REQUEST_ROUTE, BRANCH_ROUTE and
   ONREPLY_ROUTE.

   Example 1.31. t_check_trans usage
...
if ( is_method("CANCEL") ) {
        if ( t_check_trans() )
                t_relay();
        exit;
}
...

1.4.12.  t_was_cancelled()

   Retuns true if called for an INVITE transaction that was
   explicitly cancelled by UAC side via a CANCEL request.

   This function can be used from ONREPLY_ROUTE, FAILURE_ROUTE.

   Example 1.32. t_was_cancelled usage
...
if (t_was_cancelled()) {
    log("transaction was cancelled by UAC\n");
}
...

1.4.13.  t_on_failure(failure_route)

   Sets reply routing block, to which control is passed after a
   transaction completed with a negative result but before sending
   a final reply. In the referred block, you can either start a
   new branch (good for services such as forward_on_no_reply) or
   send a final reply on your own (good for example for message
   silo, which received a negative reply from upstream and wants
   to tell upstream "202 I will take care of it").

   As not all functions are available from failure route, please
   check the documentation for each function to see the
   permissions. Any other commands may result in unpredictable
   behavior and possible server failure.

   Only one failure_route can be armed for a request. If you use
   many times t_on_failure(), only the last one has effect.

   Note that whenever failure_route is entered, RURI is set to
   value of the winning branch.

   Meaning of the parameters is as follows:
     * failure_route - Reply route block to be called.

   This function can be used from REQUEST_ROUTE, BRANCH_ROUTE,
   ONREPLY_ROUTE and FAILURE_ROUTE.

   Example 1.33. t_on_failure usage
...
route {
        t_on_failure("1");
        t_relay();
}

failure_route[1] {
        seturi("sip:user@voicemail");
        append_branch();
        t_relay();
}
...

1.4.14.  t_on_reply(reply_route)

   Sets reply routing block, to which control is passed each time
   a reply (provisional or final) for the transaction is received.
   The route is not called for local generated replies! In the
   referred block, you can inspect the reply and perform text
   operations on it.

   As not all functions are available from this type of route,
   please check the documentation for each function to see the
   permissions. Any other commands may result in unpredictable
   behavior and possible server failure.

   Only one onreply_route can be armed for a request. If you use
   many times t_on_reply(), only the last one has effect.

   If the processed reply is a provisional reply (1xx code), by
   calling the drop() function (exported by core), the execution
   of the route will end and the reply will not be forwarded
   further.

   Meaning of the parameters is as follows:
     * reply_route - Reply route block to be called.

   This function can be used from REQUEST_ROUTE, BRANCH_ROUTE,
   ONREPLY_ROUTE and FAILURE_ROUTE.

   Example 1.34. t_on_reply usage
...
route {
        t_on_reply("1");
        t_relay();
}

onreply_route[1] {
        if (t_check_status("1[0-9][0-9]")) {
                setflag(1);
                log("provisional reply received\n");
                if (t_check_status("183"))
                        drop;
        }
}
...

1.4.15.  t_on_branch(branch_route)

   Sets a branch route to be execute separately for each branch of
   the transaction before being sent out - changes in that route
   should reflect only on that branch.

   As not all functions are available from this type of route,
   please check the documentation for each function to see the
   permissions. Any other commands may result in unpredictable
   behavior and possible server failure.

   Only one branch_route can be armed for a request. If you use
   many time t_on_branch(), only the last one has effect.

   By calling the drop() function (exported by core), the
   execution of the branch route will end and the branch will not
   be forwarded further.

   Meaning of the parameters is as follows:
     * branch_route - Branch route block to be called.

   This function can be used from REQUEST_ROUTE, BRANCH_ROUTE,
   ONREPLY_ROUTE and FAILURE_ROUTE.

   Example 1.35. t_on_branch usage
...
route {
        t_on_branch("1");
        t_relay();
}

branch_route[1] {
        if (uri=~"bad_uri") {
                xlog("dropping branch $ru \n");
                drop;
        }
        if (uri=~"GW_uri") {
                append_rpid();
        }
}
...

1.4.16.  t_load_contacts()

   Loads contacts in destination set in increasing qvalue order as
   values of contacts_avp. If all contacts in the destination set
   have the same qvalue, t_load_contacts() does not do anything
   thus minimizing performance impact of serial forking capability
   when it is not needed. Returns 1 if loading of contacts
   succeeded or there was nothing to do. Returns -1 on error (see
   syslog).

   This function can be used from REQUEST_ROUTE and FAILURE_ROUTE.

   Example 1.36. t_load_contacts usage
...
if (!t_load_contacts()) {
        sl_send_reply("500", "Server Internal Error - Cannot load contac
ts");
        exit;
};
...

1.4.17.  t_next_contacts()

   If transaction does not exist when t_next_contacts() is called,
   replaces Request-URI with the first contacts_avp value, adds
   the remaining contacts_avp values with the same qvalue as
   branches, and destroys those AVPs. It does nothing if there are
   no contacts_avp values. Returns 1 if there were no errors and
   -1 if an error occurred (see syslog).

   If transaction does exist when t_next_contacts() is called,
   adds the first contacts_avp value and all following
   contacts_avp values with the same qvalue as new branches to
   request and destroys those AVPs. Returns 1 if new branches were
   successfully added and -1 on error (see syslog) or if there
   were no more contacts_avp values.

   This function can be used from REQUEST_ROUTE and FAILURE_ROUTE.

   Example 1.37. t_next_contacts usage
...
# First call after t_load_contacts() when transaction does not exist yet
# and contacts should be available
if (!t_next_contacts()) {
        sl_send_reply("500", "Server Internal Error - Cannot get contact
s");
} else {
        t_relay();
};
...
# Following call, when transaction exists and there may or may not be
# contacts left
if (!t_next_contacts()) {
        t_reply("408", "Request Timeout");
} else {
        t_relay();
};
...

1.4.18.  t_cancel_branches(which)

   Cancel branches of an active SIP transaction. The function can
   be called for a SIP reply that will identify the current
   branch.

   Parameter can be:.
     * all - cancel all branches.
     * others - cancel all branches but the current one.
     * this - cancel current branch.

   This function can be used in ONREPLY_ROUTE.

   Example 1.38. t_cancel_branches usage
...
if (t_cancel_branches("all")) {
        xlog("cancelled all branches\n");
}
...

1.5. Exported pseudo-variables

     * $T_branch_idx
     * $T_reply_code
     * $T_req(pv)
     * $T_rpl(pv)

   Exported pseudo-variables are documented at
   http://www.kamailio.org/dokuwiki/.

1.6. Exported MI Functions

1.6.1.  t_uac_dlg

   Generates and sends a local SIP request.

   Parameters:
     * method - request method
     * RURI - request SIP URI
     * NEXT HOP - next hop SIP URI (OBP); use "." if no value.
     * socket - local socket to be used for sending the request;
       use "." if no value.
     * headers - set of additional headers to be added to the
       request; at least "From" and "To" headers must be specify)
     * body - (optional, may not be present) request body (if
       present, requires the "Content-Type" and "Content-length"
       headers)

1.6.2.  t_uac_cancel

   Generates and sends a CANCEL for an existing local SIP request.

   Parameters:
     * callid - callid of the INVITE request to be cancelled.
     * cseq - cseq of the INVITE request to be cancelled.

1.6.3.  t_hash

   Gets information about the load of TM internal hash table.

   Parameters:
     * none

1.6.4.  t_reply

   Generates and sends a reply for an existing inbound SIP
   transaction.

   Parameters:
     * code - reply code
     * reason - reason phrase.
     * trans_id - transaction identifier (has the hash_entry:label
       format)
     * to_tag - To tag to be added to TO header
     * new_headers - extra headers to be appended to the reply;
       use a dot (".") char only if there are no headers;
     * body - (optional, may not be present) reply body (if
       present, requires the "Content-Type" and "Content-length"
       headers)

1.7. Exported statistics

   Exported statistics are listed in the next sections. All
   statistics except "inuse_transactions" can be reset.

1.7.1. received_replies

   Total number of total replies received by TM module.

1.7.2. relayed_replies

   Total number of replies received and relayed by TM module.

1.7.3. local_replies

   Total number of replies local generated by TM module.

1.7.4. UAS_transactions

   Total number of transactions created by received requests.

1.7.5. UAC_transactions

   Total number of transactions created by local generated
   requests.

1.7.6. 2xx_transactions

   Total number of transactions completed with 2xx replies.

1.7.7. 3xx_transactions

   Total number of transactions completed with 3xx replies.

1.7.8. 4xx_transactions

   Total number of transactions completed with 4xx replies.

1.7.9. 5xx_transactions

   Total number of transactions completed with 5xx replies.

1.7.10. 6xx_transactions

   Total number of transactions completed with 6xx replies.

1.7.11. inuse_transactions

   Number of transactions existing in memory at current time.

Chapter 2. Developer Guide

2.1. Functions

2.1.1.  load_tm(*import_structure)

   For programmatic use only--import the TM API. See the cpl-c,
   acc or jabber modules to see how it works.

   Meaning of the parameters is as follows:
     * import_structure - Pointer to the import structure - see
       "struct tm_binds" in modules/tm/tm_load.h
