#!/usr/bin/env python




##################################################
## DEPENDENCIES
import sys
import os
import os.path
try:
    import builtins as builtin
except ImportError:
    import __builtin__ as builtin
from os.path import getmtime, exists
import time
import types
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import *
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers
from prewikka import User
from prewikka.templates.ClassicLayout import ClassicLayout

##################################################
## MODULE CONSTANTS
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '2.4.4'
__CHEETAH_versionTuple__ = (2, 4, 4, 'development', 0)
__CHEETAH_genTime__ = 1332794823.11821
__CHEETAH_genTimestamp__ = 'Mon Mar 26 21:47:03 2012'
__CHEETAH_src__ = 'prewikka/templates/MessageListing.tmpl'
__CHEETAH_srcLastModified__ = 'Tue Jun 30 07:26:37 2009'
__CHEETAH_docstring__ = 'Autogenerated by Cheetah: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class MessageListing(ClassicLayout):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        super(MessageListing, self).__init__(*args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    def layout_start_hook(self, **KWS):



        ## CHEETAH: generated from #def layout_start_hook at line 4, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write(u'''
<script type="text/javascript">
<!--
var second_reload  = 0;
var second_count   = 0;
var autorefresh_enabled = true;

$(document).ready(function() {
  $("#allbox").click(function(){
    $(\'input[name=delete]\').check($(this).attr(\'checked\'));
  });


  if ( navigator.userAgent.indexOf("Konqueror") != -1 ) {
        $("th.filter_popup > div").css("display", "block");
        $("th.filter_popup > div").hide();
   }

  $(".filter_popup_link").click(function(){
        $(this).nextAll("div").popupUnique(function(data){data.show()}, function(data){data.hide()})
        return false;
  });

  $("input[name=\'auto_apply_value\'], input[type=\'submit\']").focus(function(){
        autorefresh_possible = false;
  });

  $("input[name=\'auto_apply_value\']").blur(function(){
        if ( second_reload <= second_count )
                second_count = 0;

        autorefresh_possible = true;
  });

  $(".auto_apply_button").click(function(){
        if ( document.messagelisting.auto_apply_enable.value == "true" ) {
                autorefresh_enabled = false;

                document.messagelisting.auto_apply_enable.value = "false";
                document.messagelisting.auto_apply_image.src = "prewikka/images/play.png";
        } else {
                autorefresh_enabled = true;

                document.messagelisting.auto_apply_enable.value = "true";
                document.messagelisting.auto_apply_image.src = "prewikka/images/pause.png";
        }
  });

  $("a[href]").click(function(){
        autorefresh_possible = false;
  });
});


function pad(number)
{
        if ( number < 10 )
            return "0" + number;
        else
            return number;
}

function autoApplyTime() {
        if ( document.messagelisting.auto_apply_value.value )
                var rawtime = document.messagelisting.auto_apply_value.value;
        else
                var rawtime = "0:00";

        var old = second_reload;
        var parselimit = rawtime.split(":");

        if ( parselimit[0] && parselimit[1] && parselimit[2] )
                second_reload = parselimit[0] * 3600 + parselimit[1] * 60 + parselimit[2] * 1;

        else if ( parselimit[0] && parselimit[1] )
                second_reload = parselimit[0] * 60 + parselimit[1] * 1;

        else
                second_reload = rawtime;

        if ( second_reload != old )
                secound_count = 0;
}


function autoApplyCounter() {
        autoApplyTime();

        if ( autorefresh_enabled == false || autorefresh_possible == false || second_reload == 0 ) {
                setTimeout("autoApplyCounter()", 1000);
                return;
        }

        second_count += 1;
        document.getElementById("auto_apply_current").innerHTML = Math.floor(second_count / 60) + ":" + pad((second_count % 60));

        if ( second_count != second_reload )
                setTimeout("autoApplyCounter()", 1000);

        else if ( second_count == second_reload ) {
                second_count = 0;

                var yaxis = 0;

                if ( window.pageYOffset )
                        yaxis = window.pageYOffset;

                else if ( window.documentElement && window.documentElement.scrollTop )
                        yaxis = window.documentElement.scrollTop;

                else if ( document.body.scrollTop )
                        yaxis = window.body.scrollTop;

                document.messagelisting.y.value = yaxis;
                document.messagelisting.submit("Apply");
        }
}


function setScrollBar() {
        if ( document.messagelisting.y.value ) {
                window.scrollTo(\'0\', document.messagelisting.y.value) ;
                document.messagelisting.y.value = 0;
        }
}


function beginAutoApply() {
''')
        if VFFSL(SL,"auto_apply_enable",True) == "true": # generated from line 133, col 1
            write(u'''        autorefresh_enabled = true;
''')
        else: # generated from line 135, col 1
            write(u'''        autorefresh_enabled = false;
''')
        write(u'''
        setScrollBar();
        setTimeout("autoApplyCounter()", 1000);
}

//--></script>

<form id="messagelisting" name="messagelisting" method="post" action="?">
''')
        for name, value in VFFSL(SL,"hidden_parameters",True): # generated from line 146, col 1
            write(u'''  <input type="hidden" name="''')
            _v = VFFSL(SL,"name",True) # u'$name' on line 147, col 30
            if _v is not None: write(_filter(_v, rawExpr=u'$name')) # from line 147, col 30.
            write(u'''" value="''')
            _v = VFFSL(SL,"value",True) # u'$value' on line 147, col 44
            if _v is not None: write(_filter(_v, rawExpr=u'$value')) # from line 147, col 44.
            write(u'''"/>
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def layout_end_hook(self, **KWS):



        ## CHEETAH: generated from #def layout_end_hook at line 151, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write(u'''</form>
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def message_listing_header(self, **KWS):



        ## CHEETAH: generated from #def message_listing_header at line 158, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def main_content(self, **KWS):



        ## CHEETAH: generated from #block main_content at line 156, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write(u'''
''')
        _v = VFFSL(SL,"message_listing_header",True) # u'$message_listing_header' on line 160, col 1
        if _v is not None: write(_filter(_v, rawExpr=u'$message_listing_header')) # from line 160, col 1.
        write(u'''

<table id="message_list_result">
  ''')
        _v = VFFSL(SL,"message_fields_header",True) # u'$message_fields_header' on line 163, col 3
        if _v is not None: write(_filter(_v, rawExpr=u'$message_fields_header')) # from line 163, col 3.
        write(u'''
  <tbody>
''')
        row_classes = ("table_row_even", "table_row_odd")
        cnt = 0
        write(u'''
''')
        for message in VFFSL(SL,"messages",True): # generated from line 168, col 5
            self._CHEETAH__globalSetVars["message"] = VFFSL(SL,"message",True)
            write(u'''        <tr class="''')
            _v = VFFSL(SL,"row_classes",True)[VFFSL(SL,"cnt",True) % 2] # u'$row_classes[$cnt % 2]' on line 170, col 20
            if _v is not None: write(_filter(_v, rawExpr=u'$row_classes[$cnt % 2]')) # from line 170, col 20.
            write(u'''">
          ''')
            _v = VFFSL(SL,"message_fields",True) # u'$message_fields' on line 171, col 11
            if _v is not None: write(_filter(_v, rawExpr=u'$message_fields')) # from line 171, col 11.
            write(u'''
          <td>
''')
            if VFN(VFFSL(SL,"prewikka.user",True),"has",False)(User.PERM_IDMEF_ALTER): # generated from line 173, col 13
                write(u'''              <input class="checkbox" type="checkbox" name="delete" value="''')
                _v = VFFSL(SL,"message.delete",True) # u'$message.delete' on line 174, col 76
                if _v is not None: write(_filter(_v, rawExpr=u'$message.delete')) # from line 174, col 76.
                write(u'''"/>
''')
            else: # generated from line 175, col 13
                write(u'''              &nbsp;
''')
            write(u'''          </td>
        </tr>
''')
            cnt += 1
        write(u'''    </tbody>

''')
        if VFN(VFFSL(SL,"prewikka.user",True),"has",False)(User.PERM_IDMEF_ALTER) and VFFSL(SL,"cnt",True): # generated from line 184, col 1
            write(u'''   <tfoot>
     <tr>
      <td colspan="4">&nbsp;</td>
      <td style="text-align: right;"><input type="submit" value="''')
            if False:
                _("Delete")
            _v = VFFSL(SL,"_",False)("Delete") # u'$_("Delete")' on line 188, col 66
            if _v is not None: write(_filter(_v, rawExpr=u'$_("Delete")')) # from line 188, col 66.
            write(u'''"/></td>
      <td>
       <input class="checkbox" type="checkbox" id="allbox" />
      </td>
     </tr>
    </tfoot>
''')
        write(u'''</table>
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def orderby_option(self, **KWS):



        ## CHEETAH: generated from #block orderby_option at line 199, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write(u'''     <option value="time_desc" ''')
        _v = VFFSL(SL,"timeline.time_desc_selected",True) # u'$timeline.time_desc_selected' on line 200, col 32
        if _v is not None: write(_filter(_v, rawExpr=u'$timeline.time_desc_selected')) # from line 200, col 32.
        write(u'''>By time (descending)</option>
     <option value="time_asc" ''')
        _v = VFFSL(SL,"timeline.time_asc_selected",True) # u'$timeline.time_asc_selected' on line 201, col 31
        if _v is not None: write(_filter(_v, rawExpr=u'$timeline.time_asc_selected')) # from line 201, col 31.
        write(u'''>By time (ascending)</option>
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def timeline_extra_content(self, **KWS):



        ## CHEETAH: generated from #def timeline_extra_content at line 207, col 3.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def menu_extra_content(self, **KWS):



        ## CHEETAH: generated from #block menu_extra_content at line 204, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write(u'''
<table id="timeline">
  ''')
        _v = VFFSL(SL,"timeline_extra_content",True) # u'$timeline_extra_content' on line 209, col 3
        if _v is not None: write(_filter(_v, rawExpr=u'$timeline_extra_content')) # from line 209, col 3.
        write(u'''

  <tr>
   <th id="timeline_step_label">''')
        if False:
            _("Period")
        _v = VFFSL(SL,"_",False)("Period") # u'$_("Period")' on line 212, col 33
        if _v is not None: write(_filter(_v, rawExpr=u'$_("Period")')) # from line 212, col 33.
        write(u'''</th>
   <td colspan="2">
    <input name="timeline_value" type="text" size="2" value="''')
        _v = VFFSL(SL,"timeline.value",True) # u'$timeline.value' on line 214, col 62
        if _v is not None: write(_filter(_v, rawExpr=u'$timeline.value')) # from line 214, col 62.
        write(u'''"/>
    <select name="timeline_unit">
     <option value="min" ''')
        _v = VFFSL(SL,"timeline.min_selected",True) # u'$timeline.min_selected' on line 216, col 26
        if _v is not None: write(_filter(_v, rawExpr=u'$timeline.min_selected')) # from line 216, col 26.
        write(u'''>''')
        if False:
            _("Minutes")
        _v = VFFSL(SL,"_",False)("Minutes") # u'$_("Minutes")' on line 216, col 49
        if _v is not None: write(_filter(_v, rawExpr=u'$_("Minutes")')) # from line 216, col 49.
        write(u'''</option>
     <option value="hour" ''')
        _v = VFFSL(SL,"timeline.hour_selected",True) # u'$timeline.hour_selected' on line 217, col 27
        if _v is not None: write(_filter(_v, rawExpr=u'$timeline.hour_selected')) # from line 217, col 27.
        write(u'''>''')
        if False:
            _("Hours")
        _v = VFFSL(SL,"_",False)("Hours") # u'$_("Hours")' on line 217, col 51
        if _v is not None: write(_filter(_v, rawExpr=u'$_("Hours")')) # from line 217, col 51.
        write(u'''</option>
     <option value="day" ''')
        _v = VFFSL(SL,"timeline.day_selected",True) # u'$timeline.day_selected' on line 218, col 26
        if _v is not None: write(_filter(_v, rawExpr=u'$timeline.day_selected')) # from line 218, col 26.
        write(u'''>''')
        if False:
            _("Days")
        _v = VFFSL(SL,"_",False)("Days") # u'$_("Days")' on line 218, col 49
        if _v is not None: write(_filter(_v, rawExpr=u'$_("Days")')) # from line 218, col 49.
        write(u'''</option>
     <option value="month" ''')
        _v = VFFSL(SL,"timeline.month_selected",True) # u'$timeline.month_selected' on line 219, col 28
        if _v is not None: write(_filter(_v, rawExpr=u'$timeline.month_selected')) # from line 219, col 28.
        write(u'''>''')
        if False:
            _("Months")
        _v = VFFSL(SL,"_",False)("Months") # u'$_("Months")' on line 219, col 53
        if _v is not None: write(_filter(_v, rawExpr=u'$_("Months")')) # from line 219, col 53.
        write(u'''</option>
     <option value="year" ''')
        _v = VFFSL(SL,"timeline.year_selected",True) # u'$timeline.year_selected' on line 220, col 27
        if _v is not None: write(_filter(_v, rawExpr=u'$timeline.year_selected')) # from line 220, col 27.
        write(u'''>''')
        if False:
            _("Years")
        _v = VFFSL(SL,"_",False)("Years") # u'$_("Years")' on line 220, col 51
        if _v is not None: write(_filter(_v, rawExpr=u'$_("Years")')) # from line 220, col 51.
        write(u'''</option>
     <option value="unlimited" ''')
        _v = VFFSL(SL,"timeline.unlimited_selected",True) # u'$timeline.unlimited_selected' on line 221, col 32
        if _v is not None: write(_filter(_v, rawExpr=u'$timeline.unlimited_selected')) # from line 221, col 32.
        write(u'''>''')
        if False:
            _("Unlimited")
        _v = VFFSL(SL,"_",False)("Unlimited") # u'$_("Unlimited")' on line 221, col 61
        if _v is not None: write(_filter(_v, rawExpr=u'$_("Unlimited")')) # from line 221, col 61.
        write(u'''</option>
    </select>
   </td>
  </tr>

  <tr>
    <th id="timezone_control_label">''')
        if False:
            _("Timezone")
        _v = VFFSL(SL,"_",False)("Timezone") # u'$_("Timezone")' on line 227, col 37
        if _v is not None: write(_filter(_v, rawExpr=u'$_("Timezone")')) # from line 227, col 37.
        write(u'''</th>
    <td colspan="2">
      <select name="timezone">
        <option value="frontend_localtime" ''')
        _v = VFFSL(SL,"timeline.frontend_localtime_selected",True) # u'$timeline.frontend_localtime_selected' on line 230, col 44
        if _v is not None: write(_filter(_v, rawExpr=u'$timeline.frontend_localtime_selected')) # from line 230, col 44.
        write(u'''>''')
        if False:
            _("Frontend localtime")
        _v = VFFSL(SL,"_",False)("Frontend localtime") # u'$_("Frontend localtime")' on line 230, col 82
        if _v is not None: write(_filter(_v, rawExpr=u'$_("Frontend localtime")')) # from line 230, col 82.
        write(u'''</option>
        <option value="sensor_localtime" ''')
        _v = VFFSL(SL,"timeline.sensor_localtime_selected",True) # u'$timeline.sensor_localtime_selected' on line 231, col 42
        if _v is not None: write(_filter(_v, rawExpr=u'$timeline.sensor_localtime_selected')) # from line 231, col 42.
        write(u'''>''')
        if False:
            _("Sensor localtime")
        _v = VFFSL(SL,"_",False)("Sensor localtime") # u'$_("Sensor localtime")' on line 231, col 78
        if _v is not None: write(_filter(_v, rawExpr=u'$_("Sensor localtime")')) # from line 231, col 78.
        write(u'''</option>
        <option value="utc" ''')
        _v = VFFSL(SL,"timeline.utc_selected",True) # u'$timeline.utc_selected' on line 232, col 29
        if _v is not None: write(_filter(_v, rawExpr=u'$timeline.utc_selected')) # from line 232, col 29.
        write(u'''>''')
        if False:
            _("UTC")
        _v = VFFSL(SL,"_",False)("UTC") # u'$_("UTC")' on line 232, col 52
        if _v is not None: write(_filter(_v, rawExpr=u'$_("UTC")')) # from line 232, col 52.
        write(u'''</option>
       </select>
     </td>
  </tr>

  <tr>
   <th id="timeline_limit_label">''')
        if False:
            _("Limit")
        _v = VFFSL(SL,"_",False)("Limit") # u'$_("Limit")' on line 238, col 34
        if _v is not None: write(_filter(_v, rawExpr=u'$_("Limit")')) # from line 238, col 34.
        write(u'''</th>

   <td colspan="1">
    <input id="timeline_limit_value" type="text" size="2" name="limit" value="''')
        _v = VFFSL(SL,"limit",True) # u'$limit' on line 241, col 79
        if _v is not None: write(_filter(_v, rawExpr=u'$limit')) # from line 241, col 79.
        write(u'''"/>
   </td>
   <td>
    <select name="orderby">
    ''')
        _v = VFFSL(SL,"orderby_option",True) # u'$orderby_option' on line 245, col 5
        if _v is not None: write(_filter(_v, rawExpr=u'$orderby_option')) # from line 245, col 5.
        write(u'''
    </select>
   </td>
  </tr>

  <tr>
    <th id="auto_apply_label">''')
        if False:
            _("Refresh")
        _v = VFFSL(SL,"_",False)("Refresh") # u'$_("Refresh")' on line 251, col 31
        if _v is not None: write(_filter(_v, rawExpr=u'$_("Refresh")')) # from line 251, col 31.
        write(u'''</th>

    <td colspan="2">
''')
        if VFFSL(SL,"auto_apply_enable",True) == "true": # generated from line 254, col 5
            img = "prewikka/images/pause.png"
        else: # generated from line 256, col 5
            img = "prewikka/images/play.png"
        write(u'''
<input type="hidden" name="auto_apply_enable" value="''')
        _v = VFFSL(SL,"auto_apply_enable",True) # u'$auto_apply_enable' on line 260, col 54
        if _v is not None: write(_filter(_v, rawExpr=u'$auto_apply_enable')) # from line 260, col 54.
        write(u'''" />

<div class="auto_apply_current" id="auto_apply_current">0:00</div>
<input type="text" size="3" name="auto_apply_value" value="''')
        _v = VFFSL(SL,"auto_apply_value",True) # u'$auto_apply_value' on line 263, col 60
        if _v is not None: write(_filter(_v, rawExpr=u'$auto_apply_value')) # from line 263, col 60.
        write(u'''" />
<a class="auto_apply_button"><img id="auto_apply_image" src="''')
        _v = VFFSL(SL,"img",True) # u'$img' on line 264, col 62
        if _v is not None: write(_filter(_v, rawExpr=u'$img')) # from line 264, col 62.
        write(u'''" alt="Play/Pause" /></a>

    </td>
  </tr>

''')
        _orig_filter_40243158 = _filter
        filterName = u'CleanOutput'
        if self._CHEETAH__filters.has_key("CleanOutput"):
            _filter = self._CHEETAH__currentFilter = self._CHEETAH__filters[filterName]
        else:
            _filter = self._CHEETAH__currentFilter = \
			self._CHEETAH__filters[filterName] = getattr(self._CHEETAH__filtersLib, filterName)(self).filter
        write(u'''
<tr>
 <td colspan="3" style="text-align: center">

<br style="line-height: 5px;" />

<div>
 <input id="form_apply" type="submit" name="apply" value="''')
        if False:
            _("Apply")
        _v = VFFSL(SL,"_",False)("Apply") # u'$_("Apply")' on line 277, col 59
        if _v is not None: write(_filter(_v, rawExpr=u'$_("Apply")')) # from line 277, col 59.
        write(u'''" />&nbsp;<input type="submit" name="_save" value="''')
        if False:
            _("Save")
        _v = VFFSL(SL,"_",False)("Save") # u'$_("Save")' on line 277, col 121
        if _v is not None: write(_filter(_v, rawExpr=u'$_("Save")')) # from line 277, col 121.
        write(u'''" />
</div>

<br style="line-height: 5px;" />

<div class="timeline_range">
''')
        if not VFFSL(SL,"timeline.start",True): # generated from line 283, col 1
            write(u''' Unlimited<br/>
 -<br/>
''')
        else: # generated from line 286, col 1
            write(u''' ''')
            _v = VFFSL(SL,"timeline.start",True) # u'$timeline.start' on line 287, col 2
            if _v is not None: write(_filter(_v, rawExpr=u'$timeline.start')) # from line 287, col 2.
            write(u'''<br/>
 ''')
            _v = VFFSL(SL,"timeline.end",True) # u'$timeline.end' on line 288, col 2
            if _v is not None: write(_filter(_v, rawExpr=u'$timeline.end')) # from line 288, col 2.
            write(u'''<br/>
''')
        write(u''' ''')
        _v = VFFSL(SL,"timeline.range_timezone",True) # u'$timeline.range_timezone' on line 290, col 2
        if _v is not None: write(_filter(_v, rawExpr=u'$timeline.range_timezone')) # from line 290, col 2.
        write(u'''
</div>

</td>
</tr>

 <tr>
  <td colspan="3">
   <table><tr>
''')
        if VFFSL(SL,"timeline.prev",True): # generated from line 299, col 5
            write(u'''     <td class="timeline_control_prev"><a href="''')
            _v = VFFSL(SL,"timeline.prev",True) # u'$timeline.prev' on line 300, col 49
            if _v is not None: write(_filter(_v, rawExpr=u'$timeline.prev')) # from line 300, col 49.
            write(u'''"><b>''')
            if False:
                _("prev")
            _v = VFFSL(SL,"_",False)("prev") # u'$_("prev")' on line 300, col 68
            if _v is not None: write(_filter(_v, rawExpr=u'$_("prev")')) # from line 300, col 68.
            write(u'''</b></a></td>
''')
        else: # generated from line 301, col 5
            write(u'''     <td class="timeline_control_inactive"><b>''')
            if False:
                _("prev")
            _v = VFFSL(SL,"_",False)("prev") # u'$_("prev")' on line 302, col 47
            if _v is not None: write(_filter(_v, rawExpr=u'$_("prev")')) # from line 302, col 47.
            write(u'''</b></td>
''')
        write(u'''
''')
        if VFFSL(SL,"timeline.current",True): # generated from line 305, col 5
            write(u'''     <td class="timeline_control_cur"><a href="''')
            _v = VFFSL(SL,"timeline.current",True) # u'$timeline.current' on line 306, col 48
            if _v is not None: write(_filter(_v, rawExpr=u'$timeline.current')) # from line 306, col 48.
            write(u'''"><b>''')
            if False:
                _("current")
            _v = VFFSL(SL,"_",False)("current") # u'$_("current")' on line 306, col 70
            if _v is not None: write(_filter(_v, rawExpr=u'$_("current")')) # from line 306, col 70.
            write(u'''</b></a></td>
''')
        else: # generated from line 307, col 5
            write(u'''     <td class="timeline_control_cur_inactive"><b>''')
            if False:
                _("current")
            _v = VFFSL(SL,"_",False)("current") # u'$_("current")' on line 308, col 51
            if _v is not None: write(_filter(_v, rawExpr=u'$_("current")')) # from line 308, col 51.
            write(u'''</b></td>
''')
        write(u'''
''')
        if VFFSL(SL,"timeline.next",True): # generated from line 311, col 5
            write(u'''     <td class="timeline_control_next"><a href="''')
            _v = VFFSL(SL,"timeline.next",True) # u'$timeline.next' on line 312, col 49
            if _v is not None: write(_filter(_v, rawExpr=u'$timeline.next')) # from line 312, col 49.
            write(u'''"><b>''')
            if False:
                _("next")
            _v = VFFSL(SL,"_",False)("next") # u'$_("next")' on line 312, col 68
            if _v is not None: write(_filter(_v, rawExpr=u'$_("next")')) # from line 312, col 68.
            write(u'''</b></a></td>
''')
        else: # generated from line 313, col 5
            write(u'''     <td class="timeline_control_inactive"><b>''')
            if False:
                _("next")
            _v = VFFSL(SL,"_",False)("next") # u'$_("next")' on line 314, col 47
            if _v is not None: write(_filter(_v, rawExpr=u'$_("next")')) # from line 314, col 47.
            write(u'''</b></td>
''')
        write(u'''
   </tr></table>
  </td>
 </tr>

 </table>

<table id="message_list_nav">
  <tr>
''')
        if VFFSL(SL,"nav.prev",True): # generated from line 325, col 5
            write(u'''      <td class="message_list_nav_button"><a href="''')
            _v = VFFSL(SL,"nav.first",True) # u'$nav.first' on line 326, col 52
            if _v is not None: write(_filter(_v, rawExpr=u'$nav.first')) # from line 326, col 52.
            write(u'''">&lt;&lt;</a></td>
      <td class="message_list_nav_button"><a href="''')
            _v = VFFSL(SL,"nav.prev",True) # u'$nav.prev' on line 327, col 52
            if _v is not None: write(_filter(_v, rawExpr=u'$nav.prev')) # from line 327, col 52.
            write(u'''">&lt;</a></td>
''')
        else: # generated from line 328, col 5
            write(u'''      <td class="message_list_nav_button_empty">&lt;&lt;</td>
      <td class="message_list_nav_button_empty">&lt;</td>
''')
        if VFFSL(SL,"nav.next",True): # generated from line 332, col 5
            write(u'''      <td class="message_list_nav_button"><a href="''')
            _v = VFFSL(SL,"nav.next",True) # u'$nav.next' on line 333, col 52
            if _v is not None: write(_filter(_v, rawExpr=u'$nav.next')) # from line 333, col 52.
            write(u'''">&gt;</a></td>
      <td class="message_list_nav_button"><a href="''')
            _v = VFFSL(SL,"nav.last",True) # u'$nav.last' on line 334, col 52
            if _v is not None: write(_filter(_v, rawExpr=u'$nav.last')) # from line 334, col 52.
            write(u'''">&gt;&gt;</a></td>
''')
        else: # generated from line 335, col 5
            write(u'''      <td class="message_list_nav_button_empty">&gt;</td>
      <td class="message_list_nav_button_empty">&gt;&gt;</td>
''')
        write(u'''  </tr>
  <tr>
    <td class="message_list_nav_infos" colspan="4">
      ''')
        _v = VFFSL(SL,"nav.from",True) # u'$nav.from' on line 342, col 7
        if _v is not None: write(_filter(_v, rawExpr=u'$nav.from')) # from line 342, col 7.
        write(u''' ... ''')
        _v = VFFSL(SL,"nav.to",True) # u'$nav.to' on line 342, col 21
        if _v is not None: write(_filter(_v, rawExpr=u'$nav.to')) # from line 342, col 21.
        write(u''' (''')
        if False:
            _("total")
        _v = VFFSL(SL,"_",False)("total") # u'$_("total")' on line 342, col 30
        if _v is not None: write(_filter(_v, rawExpr=u'$_("total")')) # from line 342, col 30.
        write(u''':''')
        _v = VFFSL(SL,"total",True) # u'$total' on line 342, col 42
        if _v is not None: write(_filter(_v, rawExpr=u'$total')) # from line 342, col 42.
        write(u''')
    </td>
  </tr>
</table>

''')
        _filter = self._CHEETAH__currentFilter = _orig_filter_40243158
        _orig_filter_35779484 = _filter
        filterName = u'Filter'
        if self._CHEETAH__filters.has_key("Filter"):
            _filter = self._CHEETAH__currentFilter = self._CHEETAH__filters[filterName]
        else:
            _filter = self._CHEETAH__currentFilter = \
			self._CHEETAH__filters[filterName] = getattr(self._CHEETAH__filtersLib, filterName)(self).filter
        _filter = self._CHEETAH__currentFilter = _orig_filter_35779484
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def body(self, **KWS):



        ## CHEETAH: generated from #block body at line 352, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write(u'''<body class="''')
        _v = VFFSL(SL,"body_class",True) # u'$body_class' on line 353, col 14
        if _v is not None: write(_filter(_v, rawExpr=u'$body_class')) # from line 353, col 14.
        write(u'''" onload="beginAutoApply()">
        <div id="top_view">
                <div id="top_view_header">
                        <div id="top_view_header_software">''')
        _v = VFFSL(SL,"prewikka.software",True) # u'$prewikka.software' on line 356, col 60
        if _v is not None: write(_filter(_v, rawExpr=u'$prewikka.software')) # from line 356, col 60.
        write(u'''</div>
                        <div id="top_view_header_place">''')
        _v = VFFSL(SL,"prewikka.place",True) # u'$prewikka.place' on line 357, col 57
        if _v is not None: write(_filter(_v, rawExpr=u'$prewikka.place')) # from line 357, col 57.
        write(u'''</div>
                        <div id="top_view_header_title">''')
        _v = VFFSL(SL,"prewikka.title",True) # u'$prewikka.title' on line 358, col 57
        if _v is not None: write(_filter(_v, rawExpr=u'$prewikka.title')) # from line 358, col 57.
        write(u'''</div>
                </div>
                ''')
        _v = VFFSL(SL,"toplayout_content",True) # u'$toplayout_content' on line 360, col 17
        if _v is not None: write(_filter(_v, rawExpr=u'$toplayout_content')) # from line 360, col 17.
        write(u'''
        </div>
</body>
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def writeBody(self, **KWS):



        ## CHEETAH: main method generated for this template
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write(u'''



''')
        self.main_content(trans=trans)
        write(u'''

''')
        self.orderby_option(trans=trans)
        write(u'''
''')
        self.menu_extra_content(trans=trans)
        write(u'''
''')
        self.body(trans=trans)
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    _mainCheetahMethod_for_MessageListing= 'writeBody'

## END CLASS DEFINITION

if not hasattr(MessageListing, '_initCheetahAttributes'):
    templateAPIClass = getattr(MessageListing, '_CHEETAH_templateClass', Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(MessageListing)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit http://www.CheetahTemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=MessageListing()).run()


