'''OpenGL extension EXT.packed_pixels

Overview (from the spec)
	
	This extension provides support for packed pixels in host memory.  A
	packed pixel is represented entirely by one unsigned byte, one
	unsigned short, or one unsigned integer.  The fields with the packed
	pixel are not proper machine types, but the pixel as a whole is.  Thus
	the pixel storage modes, including PACK_SKIP_PIXELS, PACK_ROW_LENGTH,
	PACK_SKIP_ROWS, PACK_IMAGE_HEIGHT_EXT, PACK_SKIP_IMAGES_EXT,
	PACK_SWAP_BYTES, PACK_ALIGNMENT, and their unpacking counterparts all
	work correctly with packed pixels.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/EXT/packed_pixels.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_EXT_packed_pixels'
GL_UNSIGNED_BYTE_3_3_2_EXT = constant.Constant( 'GL_UNSIGNED_BYTE_3_3_2_EXT', 0x8032 )
GL_UNSIGNED_SHORT_4_4_4_4_EXT = constant.Constant( 'GL_UNSIGNED_SHORT_4_4_4_4_EXT', 0x8033 )
GL_UNSIGNED_SHORT_5_5_5_1_EXT = constant.Constant( 'GL_UNSIGNED_SHORT_5_5_5_1_EXT', 0x8034 )
GL_UNSIGNED_INT_8_8_8_8_EXT = constant.Constant( 'GL_UNSIGNED_INT_8_8_8_8_EXT', 0x8035 )
GL_UNSIGNED_INT_10_10_10_2_EXT = constant.Constant( 'GL_UNSIGNED_INT_10_10_10_2_EXT', 0x8036 )


def glInitPackedPixelsEXT():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( EXTENSION_NAME )
