/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.gems;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.UIResource;
import org.netbeans.modules.ruby.platform.gems.Gem;
import org.openide.util.NbBundle;

final class GemUISupport {
    private GemUISupport() {
    }

    static String getGemHTMLDescriptionForTextPane(Gem gem) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<h2>");
        sb.append(gem.getName());
        sb.append("</h2>\n");
        String installedAsString = gem.getInstalledVersionsAsString();
        String availableAsString = gem.getAvailableVersionsAsString();
        if (installedAsString != null && availableAsString != null) {
            sb.append(GemUISupport.h3(GemUISupport.getMessage("GemUISupport.InstalledVersion")));
            sb.append(installedAsString);
            sb.append(GemUISupport.h3(GemUISupport.getMessage("GemUISupport.AvailableVersion")));
            sb.append(availableAsString);
            sb.append("<br>");
        } else {
            sb.append("<h3>");
            String version = installedAsString;
            if (version == null) {
                version = availableAsString;
            }
            if (version.indexOf(44) == -1) {
                sb.append(GemUISupport.getMessage("GemUISupport.Version"));
            } else {
                sb.append(GemUISupport.getMessage("GemUISupport.Versions"));
            }
            sb.append("</h3>");
            sb.append(version);
        }
        if (gem.getDescription() != null) {
            sb.append(GemUISupport.h3(GemUISupport.getMessage("GemUISupport.Description")));
            sb.append(gem.getHTMLDescription());
        }
        sb.append("</html>");
        return sb.toString();
    }

    private static String h3(String text) {
        return "<h3>" + text + "</h3>";
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(GemUISupport.class, (String)key);
    }

    static class GemListRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public GemListRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            StringBuilder label = new StringBuilder(100);
            Gem gem = (Gem)value;
            label.append("<html><b>");
            label.append(gem.getName());
            label.append("</b>");
            if (gem.getInstalledVersionsAsString() != null) {
                label.append(" (");
                label.append(gem.getInstalledVersionsAsString());
                if (gem.getAvailableVersionsAsString() != null) {
                    label.append(" => ").append(gem.getAvailableVersionsAsString());
                }
                label.append(") ");
            }
            if (gem.getDescription() != null) {
                label.append(": ");
                label.append(gem.getDescription());
            }
            label.append("</html>");
            this.setText(label.toString());
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }
}

