/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.execution;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.execution.ExecutionUtils;
import org.netbeans.modules.ruby.platform.execution.RubyLineConvertorFactory;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Utilities;

public class RubyExecutionDescriptor {
    File pwd;
    File cmd;
    boolean addBinPath;
    boolean inputVisible;
    private String displayName;
    Runnable postBuildAction;
    private final RubyPlatform platform;
    private LineConvertors.FileLocator fileLocator;
    String script;
    private String scriptPrefix;
    private Map<String, String> additionalEnv;
    private String[] additionalArgs;
    private String initialArgs;
    private String jvmArgs;
    private FileObject fileObject;
    private String classPath;
    boolean showProgress = true;
    boolean showSuspended;
    boolean frontWindow = true;
    boolean debug;
    private boolean fastDebugRequired;
    private boolean appendJdkToPath;
    private String encoding;
    private boolean useInterpreter;
    private boolean runThroughRuby = true;
    private final List<LineConvertor> outConvertors = new ArrayList<LineConvertor>();
    private final List<LineConvertor> errConvertors = new ArrayList<LineConvertor>();
    private ExecutionDescriptor.InputProcessorFactory outProcessorFactory;
    private ExecutionDescriptor.InputProcessorFactory errProcessorFactory;
    private boolean addStandardConvertors;
    private boolean lineBased;
    private boolean ansiStrippging;
    private boolean rerun = true;

    public RubyExecutionDescriptor(RubyPlatform platform) {
        this(platform, null, null);
    }

    public RubyExecutionDescriptor(RubyPlatform platform, String displayName, File pwd) {
        this(platform, displayName, pwd, null);
    }

    public RubyExecutionDescriptor(RubyPlatform platform, String displayName, File pwd, String script) {
        HashMap<String, String> env;
        this.platform = platform;
        this.displayName = displayName;
        this.pwd = pwd;
        this.script = script;
        this.useInterpreter = true;
        assert (pwd == null || pwd.isDirectory()) : pwd + " is a directory";
        if (platform.hasRubyGemsInstalled()) {
            env = new HashMap<String, String>();
            GemManager.adjustEnvironment(platform, env);
            this.addAdditionalEnv(env);
        }
        if (platform.isJRuby()) {
            env = new HashMap();
            String home = platform.getHome().getAbsolutePath();
            env.put("JRUBY_HOME", home);
            env.put("JRUBY_BASE", home);
            env.put("JAVA_HOME", ExecutionUtils.getJavaHome());
            this.addAdditionalEnv(env);
        }
    }

    public RubyExecutionDescriptor(RubyExecutionDescriptor template) {
        this.pwd = template.pwd;
        this.cmd = template.cmd;
        this.addBinPath = template.addBinPath;
        this.inputVisible = template.inputVisible;
        this.displayName = template.displayName;
        this.postBuildAction = template.postBuildAction;
        this.platform = template.platform;
        this.fileLocator = template.fileLocator;
        this.script = template.script;
        this.scriptPrefix = template.scriptPrefix;
        this.additionalEnv = template.additionalEnv;
        this.additionalArgs = template.additionalArgs;
        this.initialArgs = template.initialArgs;
        this.jvmArgs = template.jvmArgs;
        this.fileObject = template.fileObject;
        this.classPath = template.classPath;
        this.showSuspended = template.showSuspended;
        this.debug = template.debug;
        this.fastDebugRequired = template.fastDebugRequired;
        this.appendJdkToPath = template.appendJdkToPath;
        this.encoding = template.encoding;
        this.useInterpreter = template.useInterpreter;
        this.outProcessorFactory = template.outProcessorFactory;
        this.errProcessorFactory = template.errProcessorFactory;
        this.outConvertors.addAll(template.outConvertors);
        this.errConvertors.addAll(template.errConvertors);
        this.addStandardConvertors = template.addStandardConvertors;
        this.lineBased = template.lineBased;
    }

    public RubyExecutionDescriptor cmd(File cmd) {
        this.cmd = cmd;
        assert (cmd != null && cmd.isFile()) : cmd + " must be a file";
        return this;
    }

    public RubyExecutionDescriptor postBuild(Runnable postBuildAction) {
        this.postBuildAction = postBuildAction;
        return this;
    }

    public RubyExecutionDescriptor fileLocator(LineConvertors.FileLocator fileLocator) {
        this.fileLocator = fileLocator;
        return this;
    }

    public RubyExecutionDescriptor fileObject(FileObject fileObject) {
        this.fileObject = fileObject;
        return this;
    }

    public RubyExecutionDescriptor addStandardRecognizers() {
        this.addStandardConvertors = true;
        return this;
    }

    public RubyExecutionDescriptor allowInput() {
        this.inputVisible = true;
        return this;
    }

    public RubyExecutionDescriptor script(String script) {
        this.script = script;
        return this;
    }

    public RubyExecutionDescriptor showProgress(boolean showProgress) {
        this.showProgress = showProgress;
        return this;
    }

    public RubyExecutionDescriptor showSuspended(boolean showSuspended) {
        this.showSuspended = showSuspended;
        return this;
    }

    public RubyExecutionDescriptor additionalArgs(String ... additionalArgs) {
        this.additionalArgs = additionalArgs;
        return this;
    }

    public RubyExecutionDescriptor initialArgs(String initialArgs) {
        this.initialArgs = initialArgs;
        return this;
    }

    public RubyExecutionDescriptor addInitialArgs(String initialArgs) {
        if (initialArgs == null || "".equals(initialArgs)) {
            return this;
        }
        this.initialArgs = this.initialArgs == null || "".equals(this.initialArgs) ? initialArgs : this.initialArgs + " " + initialArgs;
        return this;
    }

    public RubyExecutionDescriptor jvmArguments(String jvmArgs) {
        this.jvmArgs = jvmArgs;
        return this;
    }

    public RubyExecutionDescriptor addBinPath(boolean addBinPath) {
        this.addBinPath = addBinPath;
        return this;
    }

    public RubyExecutionDescriptor frontWindow(boolean frontWindow) {
        this.frontWindow = frontWindow;
        return this;
    }

    public RubyExecutionDescriptor debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public RubyExecutionDescriptor fastDebugRequired(boolean fastDebugRequired) {
        this.fastDebugRequired = fastDebugRequired;
        return this;
    }

    public RubyExecutionDescriptor runThroughRuby(boolean runThroughRuby) {
        this.runThroughRuby = runThroughRuby;
        return this;
    }

    public RubyExecutionDescriptor appendJdkToPath(boolean appendJdkToPath) {
        this.appendJdkToPath = appendJdkToPath;
        return this;
    }

    public RubyExecutionDescriptor classPath(String classPath) {
        this.classPath = classPath;
        return this;
    }

    public String getDisplayName() {
        return this.debug ? this.displayName + " (debug)" : this.displayName;
    }

    public RubyPlatform getPlatform() {
        return this.platform;
    }

    public boolean isRunThroughRuby() {
        return this.runThroughRuby;
    }

    public File getCmd() {
        return this.cmd;
    }

    public String getScript() {
        return this.script;
    }

    public void scriptPrefix(String sp) {
        this.scriptPrefix = sp;
    }

    public String getScriptPrefix() {
        return this.scriptPrefix;
    }

    public Runnable getPostBuild() {
        return this.postBuildAction;
    }

    public String[] getAdditionalArgs() {
        return this.additionalArgs;
    }

    public String[] getInitialArgs() {
        return this.initialArgs == null ? null : Utilities.parseParameters((String)this.initialArgs);
    }

    public String getInitialArgsPlain() {
        return this.initialArgs;
    }

    public String[] getJVMArguments() {
        return this.jvmArgs == null ? null : Utilities.parseParameters((String)this.jvmArgs);
    }

    public File getPwd() {
        return this.pwd;
    }

    public void setPwd(File pwd) {
        this.pwd = pwd;
    }

    public boolean isFastDebugRequired() {
        return this.fastDebugRequired;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public LineConvertors.FileLocator getFileLocator() {
        return this.fileLocator;
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    String getEncoding() {
        return this.encoding;
    }

    public boolean getAppendJdkToPath() {
        return this.appendJdkToPath;
    }

    public void addAdditionalEnv(Map<String, String> additionalEnv) {
        if (this.additionalEnv == null) {
            this.additionalEnv = new HashMap<String, String>();
        }
        this.additionalEnv.putAll(additionalEnv);
    }

    public Map<String, String> getAdditionalEnvironment() {
        return this.additionalEnv != null ? this.additionalEnv : Collections.emptyMap();
    }

    public boolean useInterpreter() {
        return this.useInterpreter;
    }

    public void useInterpreter(boolean useInterpreter) {
        this.useInterpreter = useInterpreter;
    }

    public boolean isRerun() {
        return this.rerun;
    }

    public void setRerun(boolean rerun) {
        this.rerun = rerun;
    }

    public RubyExecutionDescriptor addOutConvertor(LineConvertor convertor) {
        this.outConvertors.add(convertor);
        return this;
    }

    public RubyExecutionDescriptor addErrConvertor(LineConvertor convertor) {
        this.errConvertors.add(convertor);
        return this;
    }

    public void setErrProcessorFactory(ExecutionDescriptor.InputProcessorFactory errProcessorFactory) {
        this.errProcessorFactory = errProcessorFactory;
    }

    public void setOutProcessorFactory(ExecutionDescriptor.InputProcessorFactory outProcessorFactory) {
        this.outProcessorFactory = outProcessorFactory;
    }

    public RubyExecutionDescriptor lineBased(boolean lineBased) {
        this.lineBased = lineBased;
        return this;
    }

    public ExecutionDescriptor toExecutionDescriptor() {
        return new ExecutionDescriptor().showProgress(this.showProgress).controllable(this.isRerun()).inputVisible(this.inputVisible).frontWindow(this.frontWindow).showSuspended(this.showSuspended).postExecution(this.postBuildAction).errLineBased(this.lineBased).outLineBased(this.lineBased).outConvertorFactory(this.lineConvertorFactory(this.outConvertors)).errConvertorFactory(this.lineConvertorFactory(this.errConvertors)).outProcessorFactory(this.outProcessorFactory).errProcessorFactory(this.errProcessorFactory);
    }

    private ExecutionDescriptor.LineConvertorFactory lineConvertorFactory(List<LineConvertor> convertors) {
        LineConvertor[] convertorArray = convertors.toArray(new LineConvertor[convertors.size()]);
        if (this.addStandardConvertors) {
            return RubyLineConvertorFactory.withStandardConvertors(this.fileLocator, convertorArray);
        }
        return RubyLineConvertorFactory.create(this.fileLocator, convertorArray);
    }
}

