/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.spi.AppDesc;
import org.netbeans.modules.glassfish.spi.ResourceDesc;
import org.netbeans.modules.glassfish.spi.ServerCommand;
import org.netbeans.modules.glassfish.spi.Utils;
import org.openide.util.NbBundle;

public class Commands {
    public static final ServerCommand START = new ServerCommand("start-domain"){};
    public static final ServerCommand STOP = new ServerCommand("stop-domain"){};

    private static void addKeepSessions(StringBuilder cmd, Boolean preserveSessions) {
        if (Boolean.TRUE.equals(preserveSessions)) {
            cmd.append("&properties=");
            cmd.append("keepSessions=true");
        }
    }

    public static final class LocationCommand
    extends ServerCommand {
        private Manifest info;
        private String installRoot;
        private String domainRoot;

        public LocationCommand() {
            super("__locations");
        }

        public String getInstallRoot() {
            return this.installRoot;
        }

        public String getDomainRoot() {
            return this.domainRoot;
        }

        @Override
        public void readManifest(Manifest manifest) throws IOException {
            this.info = manifest;
        }

        @Override
        public boolean processResponse() {
            if (this.info == null) {
                return false;
            }
            Attributes mainAttrs = this.info.getMainAttributes();
            if (mainAttrs != null) {
                this.installRoot = mainAttrs.getValue("Base-Root_value");
                this.domainRoot = mainAttrs.getValue("Domain-Root_value");
            }
            return true;
        }
    }

    public static final class VersionCommand
    extends ServerCommand {
        private Manifest info;

        public VersionCommand() {
            super("version");
        }

        @Override
        public void readManifest(Manifest manifest) throws IOException {
            this.info = manifest;
        }

        @Override
        public boolean processResponse() {
            return true;
        }
    }

    public static final class UnregisterCommand
    extends ServerCommand {
        public UnregisterCommand(String name, String resourceCmdSuffix, String cmdPropertyName, boolean cascade) {
            super("delete-" + resourceCmdSuffix);
            StringBuilder cmd = new StringBuilder(128);
            if (cascade) {
                cmd.append("cascade=true");
                cmd.append('&');
            }
            cmd.append(cmdPropertyName);
            cmd.append('=');
            cmd.append(name);
            this.query = cmd.toString();
        }
    }

    public static final class UndeployCommand
    extends ServerCommand {
        public UndeployCommand(String name) {
            super("undeploy");
            this.query = "name=" + Utils.sanitizeName(name);
        }
    }

    public static final class RedeployCommand
    extends ServerCommand {
        public RedeployCommand(String name, String contextRoot, Boolean preserveSessions) {
            super("redeploy");
            StringBuilder cmd = new StringBuilder(128);
            cmd.append("name=");
            cmd.append(Utils.sanitizeName(name));
            if (contextRoot != null && contextRoot.length() > 0) {
                cmd.append("&contextroot=");
                cmd.append(contextRoot);
            }
            Commands.addKeepSessions(cmd, preserveSessions);
            this.query = cmd.toString();
        }
    }

    public static final class DeployCommand
    extends ServerCommand {
        private final boolean isDirDeploy;
        private final File path;

        public DeployCommand(File path, String name, String contextRoot, Boolean preserveSessions, Map<String, String> properties) {
            super("deploy");
            this.isDirDeploy = path.isDirectory();
            this.path = path;
            StringBuilder cmd = new StringBuilder(128);
            cmd.append("path=");
            cmd.append(path.getAbsolutePath());
            if (name != null && name.length() > 0) {
                cmd.append("&name=");
                cmd.append(Utils.sanitizeName(name));
            }
            if (contextRoot != null && contextRoot.length() > 0) {
                cmd.append("&contextroot=");
                cmd.append(contextRoot);
            }
            cmd.append("&force=true");
            this.addProperties(cmd, properties);
            this.query = cmd.toString();
        }

        @Override
        public String getContentType() {
            return this.isDirDeploy ? null : "application/zip";
        }

        @Override
        public boolean getDoOutput() {
            return !this.isDirDeploy;
        }

        @Override
        public InputStream getInputStream() {
            try {
                return this.isDirDeploy ? null : new FileInputStream(this.path);
            }
            catch (FileNotFoundException ex) {
                return null;
            }
        }

        @Override
        public String getRequestMethod() {
            return this.isDirDeploy ? super.getRequestMethod() : "POST";
        }

        @Override
        public String getInputName() {
            return this.path.getName();
        }

        @Override
        public String getLastModified() {
            return Long.toString(this.path.lastModified());
        }

        private void addProperties(StringBuilder cmd, Map<String, String> properties) {
            if (null != properties && properties.size() > 0) {
                cmd.append("&properties=");
                int i = 0;
                for (Map.Entry<String, String> e : properties.entrySet()) {
                    String k = e.getKey();
                    String v = e.getValue();
                    if (i > 0) {
                        cmd.append(":");
                    }
                    cmd.append(k + "=" + v);
                }
            }
        }
    }

    public static final class ListResourcesCommand
    extends ServerCommand {
        private final String cmdSuffix;
        private Manifest list;
        private List<ResourceDesc> resList;

        public ListResourcesCommand(String resourceCmdSuffix) {
            super("list-" + resourceCmdSuffix + "s");
            this.cmdSuffix = resourceCmdSuffix;
        }

        public List<ResourceDesc> getResourceList() {
            if (this.resList != null) {
                return Collections.unmodifiableList(this.resList);
            }
            return Collections.emptyList();
        }

        @Override
        public void readManifest(Manifest manifest) throws IOException {
            this.list = manifest;
        }

        @Override
        public boolean processResponse() {
            String[] resources;
            if (this.list == null) {
                return false;
            }
            String resourceList = this.list.getMainAttributes().getValue("children");
            if (resourceList == null || resourceList.length() == 0) {
                return true;
            }
            for (String r : resources = resourceList.split("[,;]")) {
                if (this.skipResource(r)) continue;
                Attributes resourceAttr = this.list.getAttributes(r);
                if (resourceAttr != null) {
                    String name = resourceAttr.getValue("message");
                    if (null == name || name.length() < 1) {
                        name = r.trim();
                    }
                    if (name == null || name.length() <= 0) continue;
                    if (this.resList == null) {
                        this.resList = new ArrayList<ResourceDesc>();
                    }
                    this.resList.add(new ResourceDesc(name, this.cmdSuffix));
                    continue;
                }
                Logger.getLogger("glassfish").log(Level.FINE, "No resource attributes returned for " + r);
            }
            return true;
        }

        private boolean skipResource(String r) {
            return r.equals(NbBundle.getMessage(Commands.class, (String)"nothingToList"));
        }
    }

    public static final class ListComponentsCommand
    extends ServerCommand {
        private final String container;
        private Manifest list;
        private Map<String, List<String>> appMap;
        private static final List<String> engineBias = Arrays.asList("ear", "jruby", "web", "ejb", "appclient", "connector");

        public ListComponentsCommand() {
            this(null);
        }

        public ListComponentsCommand(String container) {
            super("list-components");
            this.container = container;
        }

        public String[] getContainers() {
            String[] result = null;
            if (this.appMap != null && this.appMap.size() > 0) {
                Set<String> containers = this.appMap.keySet();
                result = containers.toArray(new String[containers.size()]);
            }
            return result != null ? result : new String[]{};
        }

        public Map<String, List<String>> getApplicationMap() {
            if (this.appMap != null) {
                return Collections.unmodifiableMap(this.appMap);
            }
            return Collections.emptyMap();
        }

        @Override
        public void readManifest(Manifest manifest) throws IOException {
            this.list = manifest;
        }

        @Override
        public boolean processResponse() {
            String[] apps;
            if (this.list == null) {
                return false;
            }
            String appsList = this.list.getMainAttributes().getValue("children");
            if (appsList == null || appsList.length() == 0) {
                return true;
            }
            for (String appKey : apps = appsList.split(";")) {
                List<String> appList;
                if ("null".equals(appKey)) {
                    Logger.getLogger("glassfish").log(Level.WARNING, "list-components contains an invalid result.  Check server log for possible exceptions.");
                    continue;
                }
                String[] keys = appKey.split("[<>]");
                String name = keys[0];
                if (name == null || name.length() == 0) {
                    Logger.getLogger("glassfish").log(Level.FINE, "Skipping application with no name...");
                    continue;
                }
                String engine = this.getPreferredEngine(keys[1]);
                if (this.appMap == null) {
                    this.appMap = new HashMap<String, List<String>>();
                }
                if ((appList = this.appMap.get(engine)) == null) {
                    appList = new ArrayList<String>();
                    this.appMap.put(engine, appList);
                }
                appList.add(name);
            }
            return true;
        }

        private String getPreferredEngine(String engineList) {
            String[] engines = engineList.split(",");
            String engine = null;
            int bias = -1;
            for (int i = 0; i < engines.length; ++i) {
                if (this.skipContainer(engines[i])) continue;
                engines[i] = engines[i].trim();
                int newBias = engineBias.indexOf(engines[i]);
                if (newBias >= 0 && (bias == -1 || newBias < bias)) {
                    bias = newBias;
                }
                if (engine != null) continue;
                engine = engines[i];
            }
            if (bias != -1) {
                engine = engineBias.get(bias);
            } else if (engine == null) {
                engine = "unknown";
            }
            return engine;
        }

        private boolean skipContainer(String currentContainer) {
            return this.container != null ? !this.container.equals(currentContainer) : "security_ContractProvider".equals(currentContainer);
        }
    }

    public static final class ListAppsCommand
    extends ServerCommand {
        private final String container;
        private Manifest list;
        private Map<String, List<AppDesc>> appMap;
        private static final List<String> engineBias = Arrays.asList("jruby", "web", "ejb");

        public ListAppsCommand() {
            this(null);
        }

        public ListAppsCommand(String container) {
            super("list-applications");
            this.container = container;
        }

        public String[] getContainers() {
            String[] result = null;
            if (this.appMap != null && this.appMap.size() > 0) {
                Set<String> containers = this.appMap.keySet();
                result = containers.toArray(new String[containers.size()]);
            }
            return result != null ? result : new String[]{};
        }

        public Map<String, List<AppDesc>> getApplicationMap() {
            if (this.appMap != null) {
                return Collections.unmodifiableMap(this.appMap);
            }
            return Collections.emptyMap();
        }

        @Override
        public void readManifest(Manifest manifest) throws IOException {
            this.list = manifest;
        }

        @Override
        public boolean processResponse() {
            String[] apps;
            if (this.list == null) {
                return false;
            }
            String appsList = this.list.getMainAttributes().getValue("children");
            if (appsList == null || appsList.length() == 0) {
                return true;
            }
            for (String appKey : apps = appsList.split(";")) {
                List<AppDesc> appList;
                String contextRoot;
                if ("null".equals(appKey)) {
                    Logger.getLogger("glassfish").log(Level.WARNING, "list-applications contains an invalid result.  Check server log for possible exceptions.");
                    continue;
                }
                Attributes appAttrs = this.list.getAttributes(appKey);
                if (appAttrs == null) continue;
                String engine = this.getPreferredEngine(appAttrs.getValue("nb-engine_value"));
                String name = appAttrs.getValue("nb-name_value");
                if (name == null || name.length() == 0) {
                    Logger.getLogger("glassfish").log(Level.FINE, "Skipping application with no name...");
                    continue;
                }
                String path = appAttrs.getValue("nb-location_value");
                if (path.startsWith("file:")) {
                    path = path.substring(5);
                }
                if ((contextRoot = appAttrs.getValue("nb-context-root_value")) == null) {
                    contextRoot = name;
                }
                if (contextRoot.startsWith("/")) {
                    contextRoot = contextRoot.substring(1);
                }
                if (this.appMap == null) {
                    this.appMap = new HashMap<String, List<AppDesc>>();
                }
                if ((appList = this.appMap.get(engine)) == null) {
                    appList = new ArrayList<AppDesc>();
                    this.appMap.put(engine, appList);
                }
                appList.add(new AppDesc(name, path, contextRoot));
            }
            return true;
        }

        private String getPreferredEngine(String engineList) {
            String[] engines = engineList.split(",");
            String engine = null;
            int bias = -1;
            for (int i = 0; i < engines.length; ++i) {
                if (this.skipContainer(engines[i])) continue;
                engines[i] = engines[i].trim();
                int newBias = engineBias.indexOf(engines[i]);
                if (newBias >= 0 && (bias == -1 || newBias < bias)) {
                    bias = newBias;
                }
                if (engine != null) continue;
                engine = engines[i];
            }
            if (bias != -1) {
                engine = engineBias.get(bias);
            } else if (engine == null) {
                engine = "unknown";
            }
            return engine;
        }

        private boolean skipContainer(String currentContainer) {
            return this.container != null ? !this.container.equals(currentContainer) : "security_ContractProvider".equals(currentContainer);
        }
    }
}

