/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.log.HgLogMessageChangedPath;
import org.netbeans.modules.mercurial.util.HgCommand;

public class HgLogMessage {
    public static char HgModStatus = (char)77;
    public static char HgAddStatus = (char)65;
    public static char HgDelStatus = (char)82;
    public static char HgCopyStatus = (char)67;
    private List<HgLogMessageChangedPath> paths;
    private String rev;
    private String author;
    private String username;
    private String desc;
    private Date date;
    private String id;
    private String timeZoneOffset;
    private String parentOneRev;
    private String parentTwoRev;
    private boolean bMerged;
    private String rootURL;
    private OutputLogger logger;
    private HashMap<File, String> ancestors = new HashMap();

    public HgLogMessage(String changeset) {
    }

    private void updatePaths(List<String> pathsStrings, String path, List<String> filesShortPaths, char status) {
        if (filesShortPaths.isEmpty()) {
            this.paths.add(new HgLogMessageChangedPath(path, status));
            if (pathsStrings != null) {
                pathsStrings.add(path);
            }
        } else {
            this.paths.add(new HgLogMessageChangedPath(path, status));
            if (pathsStrings != null) {
                pathsStrings.add(path);
            }
        }
    }

    public HgLogMessage(String rootURL, List<String> filesShortPaths, String rev, String auth, String username, String desc, String date, String id, String parents, String fm, String fa, String fd, String fc) {
        String[] parentSplits;
        this.rootURL = rootURL;
        this.rev = rev;
        this.author = auth;
        this.username = username;
        this.desc = desc;
        this.id = id;
        this.date = new Date(Long.parseLong(date.split(" ")[0]) * 1000L);
        String[] stringArray = parentSplits = parents != null ? parents.split(" ") : null;
        if (parentSplits != null && parentSplits.length == 2) {
            String[] ps1 = parentSplits[0].split(":");
            this.parentOneRev = ps1 != null && ps1.length >= 1 ? ps1[0] : null;
            String[] ps2 = parentSplits[1].split(":");
            this.parentTwoRev = ps2 != null && ps2.length >= 1 ? ps2[0] : null;
        }
        this.bMerged = this.parentOneRev != null && this.parentTwoRev != null && !this.parentOneRev.equals("-1") && !this.parentTwoRev.equals("-1");
        this.paths = new ArrayList<HgLogMessageChangedPath>();
        ArrayList<String> apathsStrings = new ArrayList<String>();
        ArrayList<String> dpathsStrings = new ArrayList<String>();
        ArrayList<String> cpathsStrings = new ArrayList<String>();
        if (fc != null && !fc.equals("")) {
            for (String s : fc.split("\t")) {
                this.updatePaths(cpathsStrings, s, filesShortPaths, HgCopyStatus);
            }
        }
        if (fa != null && !fa.equals("")) {
            for (String s : fa.split("\t")) {
                if (cpathsStrings.contains(s)) continue;
                this.updatePaths(apathsStrings, s, filesShortPaths, HgAddStatus);
            }
        }
        if (fd != null && !fd.equals("")) {
            for (String s : fd.split("\t")) {
                this.updatePaths(dpathsStrings, s, filesShortPaths, HgDelStatus);
            }
        }
        if (fm != null && !fm.equals("")) {
            for (String s : fm.split("\t")) {
                if (apathsStrings.contains(s) || dpathsStrings.contains(s) || cpathsStrings.contains(s)) continue;
                this.updatePaths(null, s, filesShortPaths, HgModStatus);
            }
        }
        if (fa == null && fc == null && fd == null && fm == null) {
            for (String fileSP : filesShortPaths) {
                this.paths.add(new HgLogMessageChangedPath(fileSP, ' '));
            }
        }
    }

    HgLogMessageChangedPath[] getChangedPaths() {
        return this.paths.toArray(new HgLogMessageChangedPath[this.paths.size()]);
    }

    public String getRevision() {
        return this.rev;
    }

    public long getRevisionAsLong() {
        long revLong;
        try {
            revLong = Long.parseLong(this.rev);
        }
        catch (NumberFormatException ex) {
            return 0L;
        }
        return revLong;
    }

    public Date getDate() {
        return this.date;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getUsername() {
        return this.username;
    }

    public String getCSetShortID() {
        return this.id;
    }

    public String getAncestor(File file) {
        String ancestor = this.getAncestorFromMap(file);
        if (ancestor != null) {
            return ancestor;
        }
        if (this.bMerged) {
            try {
                ancestor = HgCommand.getCommonAncestor(this.rootURL, this.parentOneRev, this.parentTwoRev, this.getLogger());
            }
            catch (HgException ex) {
                Mercurial.LOG.log(Level.INFO, null, ex);
            }
        } else if (this.parentOneRev != null) {
            ancestor = this.parentOneRev;
        } else {
            try {
                ancestor = HgCommand.getParent(this.rootURL, file, this.rev);
            }
            catch (HgException ex) {
                Mercurial.LOG.log(Level.INFO, null, ex);
            }
            if (ancestor == null) {
                try {
                    Integer.toString(Integer.parseInt(this.rev) - 1);
                }
                catch (NumberFormatException ex) {
                    ancestor = "-1";
                }
            }
        }
        this.addAncestorToMap(file, ancestor);
        return ancestor;
    }

    private OutputLogger getLogger() {
        if (this.logger == null) {
            this.logger = Mercurial.getInstance().getLogger(this.rootURL);
        }
        return this.logger;
    }

    public String getMessage() {
        return this.desc;
    }

    public String getTimeZoneOffset() {
        return this.timeZoneOffset;
    }

    public void setTimeZoneOffset(String timeZoneOffset) {
        this.timeZoneOffset = timeZoneOffset;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("rev: ");
        sb.append(this.rev);
        sb.append("\nauthor: ");
        sb.append(this.author);
        sb.append("\ndesc: ");
        sb.append(this.desc);
        sb.append("\ndate: ");
        sb.append(this.date);
        sb.append("\nid: ");
        sb.append(this.id);
        sb.append("\npaths: ");
        sb.append(this.paths);
        return sb.toString();
    }

    private void addAncestorToMap(File file, String ancestor) {
        this.ancestors.put(file, ancestor);
    }

    private String getAncestorFromMap(File file) {
        return this.ancestors.get(file);
    }
}

