/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.indicators.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.DataUtil;
import org.netbeans.modules.dlight.indicators.DataRowToTimeSeries;

public final class DefaultDataRowToTimeSeries
implements DataRowToTimeSeries {
    private final int dataLength;
    private final Map<String, Integer> columnToIndex;

    public DefaultDataRowToTimeSeries(DataTableMetadata.Column[][] columns) {
        this.dataLength = columns.length;
        this.columnToIndex = Collections.unmodifiableMap(DefaultDataRowToTimeSeries.buildColumnToIndexMap(columns));
    }

    @Override
    public float[] getData(DataRow row) {
        float[] result = null;
        for (String columnName : row.getColumnNames()) {
            Integer index = this.columnToIndex.get(columnName);
            if (index == null) continue;
            if (result == null) {
                result = new float[this.dataLength];
            }
            result[index.intValue()] = DataUtil.toFloat((Object)row.getData(columnName));
        }
        return result;
    }

    @Override
    public Map<String, String> getDetails() {
        return Collections.emptyMap();
    }

    private static Map<String, Integer> buildColumnToIndexMap(DataTableMetadata.Column[][] columns) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (int i = 0; i < columns.length; ++i) {
            for (DataTableMetadata.Column column : columns[i]) {
                result.put(column.getColumnName(), i);
            }
        }
        return result;
    }
}

