/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.screen.display;

import org.w3c.dom.svg.SVGLocatableElement;
import org.w3c.dom.svg.SVGRect;

class TextRenderer {
    private float myLetterWidth;
    private SVGLocatableElement myElement;

    TextRenderer(SVGLocatableElement hiddenTextElement) {
        this.myElement = hiddenTextElement;
    }

    void initEmpiricalLetterWidth(SVGLocatableElement element) {
        if (this.myLetterWidth != 0.0f) {
            return;
        }
        String text = element.getTrait("#text");
        if (text != null && text.length() != 0 && element.getBBox() != null) {
            text = text.trim();
            this.myLetterWidth = element.getBBox().getWidth() / (float)text.length();
        }
    }

    String truncateToShownText(String text, float boundWidth) {
        if (boundWidth == 0.0f) {
            return "";
        }
        if (this.myLetterWidth == 0.0f) {
            return text;
        }
        int count = Math.max(0, (int)(boundWidth / this.myLetterWidth));
        String result = text;
        result = text.substring(0, Math.min(text.length(), count + 1));
        float width = this.getTextWidth(result);
        boolean isShort = true;
        while (width > boundWidth && result.length() > 0) {
            result = result.substring(0, result.length() - 1);
            width = this.getTextWidth(result);
            isShort = false;
        }
        String tmpText = result;
        while (isShort && width <= boundWidth && count <= text.length()) {
            result = tmpText;
            tmpText = text.substring(0, count);
            ++count;
            width = this.getTextWidth(tmpText);
        }
        if (count == text.length()) {
            result = tmpText;
        }
        return result;
    }

    float getTextWidth(String text) {
        if (text.endsWith(" ")) {
            return this.doGetTextWidth(text + "i") - this.doGetTextWidth("i");
        }
        return this.doGetTextWidth(text);
    }

    boolean isEmpiricInitialized() {
        return this.myLetterWidth == 0.0f;
    }

    float doGetTextWidth(String text) {
        float width = 0.0f;
        if (text.length() > 0) {
            String setText = text.trim();
            this.getHiddenTextElement().setTrait("#text", setText);
            SVGRect bBox = this.getHiddenTextElement().getBBox();
            if (bBox != null) {
                width = bBox.getWidth();
            }
        }
        return width;
    }

    SVGLocatableElement getHiddenTextElement() {
        return this.myElement;
    }
}

