/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.cplusplus;

import java.awt.event.ActionEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.indent.api.Indent;
import org.openide.util.NbBundle;

public final class InsertSemicolonAction
extends BaseAction {
    private final boolean withNewline;
    private final char what;

    protected InsertSemicolonAction(String name, char what, boolean withNewline) {
        super(name);
        this.withNewline = withNewline;
        this.what = what;
        this.putValue("ShortDescription", NbBundle.getMessage(InsertSemicolonAction.class, (String)name));
    }

    public InsertSemicolonAction(String name, boolean withNewline) {
        this(name, ';', withNewline);
    }

    public InsertSemicolonAction(boolean withNewLine) {
        this(withNewLine ? "complete-line-newline" : "complete-line", withNewLine);
    }

    public void actionPerformed(ActionEvent evt, final JTextComponent target) {
        if (!target.isEditable() || !target.isEnabled()) {
            target.getToolkit().beep();
            return;
        }
        final BaseDocument doc = (BaseDocument)target.getDocument();
        final class R
        implements Runnable {
            R() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block5: {
                    Caret caret = target.getCaret();
                    int dotpos = caret.getDot();
                    try {
                        int eoloffset = Utilities.getRowEnd((JTextComponent)target, (int)dotpos);
                        String insertString = "" + InsertSemicolonAction.this.what;
                        doc.insertString(eoloffset, insertString, null);
                        if (!InsertSemicolonAction.this.withNewline) break block5;
                        Indent indent = Indent.get((Document)doc);
                        indent.lock();
                        try {
                            int eolDot = Utilities.getRowEnd((JTextComponent)target, (int)caret.getDot());
                            doc.insertString(eolDot, "\n", null);
                            caret.setDot(eolDot + 1);
                            indent.reindent(eolDot + 1);
                        }
                        finally {
                            indent.unlock();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        }
        doc.runAtomicAsUser((Runnable)new R());
    }
}

