/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.model.xml;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.asm.model.lang.BitWidth;
import org.netbeans.modules.cnd.asm.model.lang.Register;
import org.netbeans.modules.cnd.asm.model.lang.instruction.Instruction;
import org.netbeans.modules.cnd.asm.model.lang.instruction.InstructionArgs;
import org.netbeans.modules.cnd.asm.model.util.Pair;
import org.netbeans.modules.cnd.asm.model.xml.DefaultXMLBaseRegister;
import org.netbeans.modules.cnd.asm.model.xml.ModelXMLReaderException;
import org.netbeans.modules.cnd.asm.model.xml.XMLBaseInstruction;
import org.netbeans.modules.cnd.asm.model.xml.XMLBaseRegister;
import org.netbeans.modules.cnd.asm.model.xml.XMLInstructionArgs;
import org.netbeans.modules.cnd.asm.model.xml.XMLReaderContext;
import org.xml.sax.Attributes;

public class ModelXMLRootContext
implements XMLReaderContext {
    private String asmName;
    private List<Instruction> instrs = new LinkedList<Instruction>();
    private List<Register> regs = new LinkedList<Register>();

    public List<Instruction> getInstructions() {
        return this.instrs;
    }

    public List<Register> getRegisters() {
        return this.regs;
    }

    private String checkForName(Attributes attributes, String attribute) {
        String res = attributes.getValue(attribute);
        if (res == null) {
            throw new ModelXMLReaderException("Can't find attribute: " + attribute);
        }
        return res;
    }

    private Map<String, String> copyAttribute(Attributes attributes, String ... excl) {
        int count = attributes.getLength();
        HashMap<String, String> res = new HashMap<String, String>(count);
        block0: for (int i = 0; i < count; ++i) {
            String name = attributes.getQName(i);
            for (String el : excl) {
                if (name.equals(el)) continue block0;
            }
            res.put(name, attributes.getValue(i));
        }
        return res;
    }

    public XMLReaderContext assemblerStart(Attributes attributes) {
        this.asmName = attributes.getValue("name");
        return this;
    }

    public XMLReaderContext register_groupStart(Attributes attributes) {
        return new RegisterGroupContext(attributes);
    }

    public void register_groupEnd(RegisterGroupContext ctx) {
        this.regs.addAll(ctx.makeRegisters());
    }

    public XMLReaderContext instruction_groupStart(Attributes attributes) {
        return new InstructionGroupContext(attributes);
    }

    private class InstructionGroupContext
    implements XMLReaderContext {
        public String groupName;

        public InstructionGroupContext(Attributes attributes) {
            this.groupName = ModelXMLRootContext.this.checkForName(attributes, "name");
        }

        public XMLReaderContext instructionStart(Attributes attributes) {
            return new InstructionContext(attributes);
        }

        public void instructionEnd(InstructionContext ctx) {
            ModelXMLRootContext.this.instrs.add(ctx.makeInstruction());
        }

        class InstructionContext
        implements XMLReaderContext {
            private final String name;
            private String clazz;
            private final String descr;
            private Map<String, String> attr;
            private final List<InstructionArgs> arguments;

            public InstructionContext(Attributes attributes) {
                this.name = ModelXMLRootContext.this.checkForName(attributes, "name");
                this.clazz = ModelXMLRootContext.this.checkForName(attributes, "clazz");
                this.descr = ModelXMLRootContext.this.checkForName(attributes, "description");
                this.attr = new HashMap<String, String>();
                this.arguments = new LinkedList<InstructionArgs>();
                this.attr = ModelXMLRootContext.this.copyAttribute(attributes, new String[]{"name", "clazz", "description"});
            }

            public XMLReaderContext argStart(Attributes attributes) {
                return new ArgContext(attributes);
            }

            public void argEnd(ArgContext context) {
                this.arguments.add(context.getArgument());
            }

            public Instruction makeInstruction() {
                String defClazz = "org.netbeans.modules.cnd.asm.model.xml.DefaultXMLBaseInstruction";
                XMLBaseInstruction instr = null;
                this.clazz = "org.netbeans.modules.cnd.asm.model.xml.DefaultXMLBaseInstruction";
                try {
                    Class<?> cl = Class.forName(this.clazz);
                    if (!XMLBaseInstruction.class.isAssignableFrom(cl)) {
                        throw new Exception(this.clazz + " is't super class of " + "org.netbeans.modules.cnd.asm.model.xml.DefaultXMLBaseInstruction");
                    }
                    Constructor<?> constr = cl.getConstructor(String.class, String.class, String.class, Collection.class);
                    instr = (XMLBaseInstruction)constr.newInstance(this.name, this.descr, InstructionGroupContext.this.groupName, this.arguments);
                }
                catch (Exception ex) {
                    throw new ModelXMLReaderException(ex.getMessage());
                }
                for (Map.Entry<String, String> el : this.attr.entrySet()) {
                    instr.setProperty(el.getKey(), el.getValue());
                }
                return instr;
            }

            private class ArgContext
            implements XMLReaderContext {
                private String descr;
                private List<String> params;

                public ArgContext(Attributes attributes) {
                    this.descr = ModelXMLRootContext.this.checkForName(attributes, "description");
                    this.params = new LinkedList<String>();
                }

                public XMLInstructionArgs getArgument() {
                    return new XMLInstructionArgs(this.params, this.descr);
                }

                public XMLReaderContext paramStart(Attributes attributes) {
                    String val = ModelXMLRootContext.this.checkForName(attributes, "val");
                    this.params.add(val);
                    return null;
                }
            }
        }
    }

    private class RegisterGroupContext
    implements XMLReaderContext {
        private String groupName;
        private List<RegisterContext> regCtxs;

        public RegisterGroupContext(Attributes attributes) {
            this.groupName = ModelXMLRootContext.this.checkForName(attributes, "name");
            this.regCtxs = new LinkedList<RegisterContext>();
        }

        public List<Register> makeRegisters() {
            ArrayList<Register> res = new ArrayList<Register>(this.regCtxs.size());
            RegisterMakeHelper helper = new RegisterMakeHelper();
            for (RegisterContext ctx : this.regCtxs) {
                XMLBaseRegister reg = helper.process(ctx);
                for (Map.Entry<String, String> attr : ctx.getAttributes().entrySet()) {
                    reg.setProperty(attr.getKey(), attr.getValue());
                }
                res.add(reg);
            }
            return res;
        }

        public XMLReaderContext registerStart(Attributes attributes) {
            return new RegisterContext(attributes);
        }

        public void registerEnd(RegisterContext ctx) {
            this.regCtxs.add(ctx);
        }

        private class RegisterContext
        implements XMLReaderContext {
            private String name;
            private BitWidth width;
            private List<Pair<String, Integer>> children;
            private Map<String, String> attr;

            public RegisterContext(Attributes attributes) {
                this.name = ModelXMLRootContext.this.checkForName(attributes, "name");
                String widthStr = ModelXMLRootContext.this.checkForName(attributes, "bitwidth");
                this.width = BitWidth.getBitWidth(Integer.parseInt(widthStr));
                this.children = new LinkedList<Pair<String, Integer>>();
                this.attr = new HashMap<String, String>();
                this.attr = ModelXMLRootContext.this.copyAttribute(attributes, new String[]{"name", "bitwidth"});
            }

            public XMLReaderContext childStart(Attributes attributes) {
                String name = ModelXMLRootContext.this.checkForName(attributes, "name");
                String offset = ModelXMLRootContext.this.checkForName(attributes, "offset");
                this.children.add(new Pair<String, Integer>(name, Integer.parseInt(offset)));
                return null;
            }

            public String getName() {
                return this.name;
            }

            public BitWidth getWidth() {
                return this.width;
            }

            public Map<String, String> getAttributes() {
                return this.attr;
            }

            public List<Pair<String, Integer>> getChildren() {
                return this.children;
            }
        }

        private class RegisterMakeHelper {
            private Set<RegisterContext> inProcesses = new HashSet<RegisterContext>();
            private XMLBaseRegister[] results;

            public RegisterMakeHelper() {
                this.results = new XMLBaseRegister[RegisterGroupContext.this.regCtxs.size()];
            }

            public XMLBaseRegister process(RegisterContext ctx) {
                int idx = RegisterGroupContext.this.regCtxs.indexOf(ctx);
                if (this.results[idx] == null) {
                    if (this.inProcesses.add(ctx)) {
                        // empty if block
                    }
                    DefaultXMLBaseRegister result = new DefaultXMLBaseRegister(ctx.getName(), ctx.getWidth());
                    HashSet<Register> children = new HashSet<Register>();
                    for (Pair<String, Integer> pair : ctx.getChildren()) {
                        XMLBaseRegister res = this.process(this.getForName(pair.getFirst()));
                        children.addAll(res.getChildren());
                        children.add(res);
                        res.setDirectParent(result);
                    }
                    result.setChildren(children);
                    this.results[idx] = result;
                }
                return this.results[idx];
            }

            private RegisterContext getForName(String name) {
                for (RegisterContext ctx : RegisterGroupContext.this.regCtxs) {
                    if (!ctx.getName().equals(name)) continue;
                    return ctx;
                }
                throw new ModelXMLReaderException("Undefined register:  " + name);
            }
        }
    }
}

