/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.spi.project.support.rake;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ruby.api.project.rake.RakeArtifact;
import org.netbeans.modules.ruby.modules.project.rake.RakeBasedProjectFactorySingleton;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectHelper;
import org.openide.ErrorManager;

final class SimpleRakeArtifact
extends RakeArtifact {
    private final RakeProjectHelper h;
    private final String type;
    private final String locationProperty;
    private final PropertyEvaluator eval;
    private final String targetName;
    private final String cleanTargetName;

    public SimpleRakeArtifact(RakeProjectHelper helper, String type, String locationProperty, PropertyEvaluator eval, String targetName, String cleanTargetName) {
        this.h = helper;
        this.type = type;
        this.locationProperty = locationProperty;
        this.eval = eval;
        this.targetName = targetName;
        this.cleanTargetName = cleanTargetName;
    }

    private URI getArtifactLocation0() {
        String locationResolved = this.eval.getProperty(this.locationProperty);
        if (locationResolved == null) {
            return URI.create("file:/UNDEFINED");
        }
        File locF = new File(locationResolved);
        if (locF.isAbsolute()) {
            return locF.toURI();
        }
        try {
            return new URI(null, null, locationResolved.replace(File.separatorChar, '/'), null);
        }
        catch (URISyntaxException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return URI.create("file:/BROKEN");
        }
    }

    @Override
    public URI[] getArtifactLocations() {
        return new URI[]{this.getArtifactLocation0()};
    }

    @Override
    public String getCleanTargetName() {
        return this.cleanTargetName;
    }

    @Override
    public File getScriptLocation() {
        return this.h.resolveFile("build.xml");
    }

    @Override
    public String getTargetName() {
        return this.targetName;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Project getProject() {
        return RakeBasedProjectFactorySingleton.getProjectFor(this.h);
    }

    public String toString() {
        return "SimpleRakeArtifact[helper=" + this.h + ",type=" + this.type + ",locationProperty=" + this.locationProperty + ",targetName=" + this.targetName + ",cleanTargetName=" + this.cleanTargetName + "]";
    }
}

