/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.util;

import java.io.IOException;
import java.io.InputStream;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyIO;
import org.jruby.nb.RubyString;
import org.jruby.nb.runtime.CallSite;
import org.jruby.nb.runtime.MethodIndex;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class IOInputStream
extends InputStream {
    private final IRubyObject io;
    private final InputStream in;
    private final IRubyObject numOne;
    private final CallSite readAdapter = MethodIndex.getFunctionalCallSite("read");

    public IOInputStream(IRubyObject io) {
        if (!io.respondsTo("read")) {
            throw new IllegalArgumentException("Object: " + io + " is not a legal argument to this wrapper, cause it doesn't respond to \"read\".");
        }
        this.io = io;
        this.in = io instanceof RubyIO ? ((RubyIO)io).getInStream() : null;
        this.numOne = RubyFixnum.one(this.io.getRuntime());
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }

    @Override
    public int available() throws IOException {
        if (this.in != null) {
            return this.in.available();
        }
        return 0;
    }

    @Override
    public int read() throws IOException {
        IRubyObject readValue = this.readAdapter.call(this.io.getRuntime().getCurrentContext(), this.io, this.numOne);
        int returnValue = -1;
        if (!readValue.isNil()) {
            returnValue = readValue.toString().charAt(0);
        }
        return returnValue;
    }

    @Override
    public int read(byte[] b) throws IOException {
        IRubyObject readValue = this.readAdapter.call(this.io.getRuntime().getCurrentContext(), this.io, this.io.getRuntime().newFixnum(b.length));
        int returnValue = -1;
        if (!readValue.isNil()) {
            ByteList str = ((RubyString)readValue).getByteList();
            System.arraycopy(str.bytes, str.begin, b, 0, str.realSize);
            returnValue = str.realSize;
        }
        return returnValue;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        IRubyObject readValue = this.readAdapter.call(this.io.getRuntime().getCurrentContext(), this.io, this.io.getRuntime().newFixnum(len));
        int returnValue = -1;
        if (!readValue.isNil()) {
            ByteList str = ((RubyString)readValue).getByteList();
            System.arraycopy(str.bytes, str.begin, b, off, str.realSize);
            returnValue = str.realSize;
        }
        return returnValue;
    }
}

