/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ext.ffi;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyFloat;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyObject;
import org.jruby.nb.RubySymbol;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.ext.ffi.AbstractMemory;
import org.jruby.nb.ext.ffi.AbstractMemoryPointer;
import org.jruby.nb.ext.ffi.FFIProvider;
import org.jruby.nb.ext.ffi.MemoryIO;
import org.jruby.nb.ext.ffi.NativeType;
import org.jruby.nb.ext.ffi.Platform;
import org.jruby.nb.ext.ffi.StructLayout;
import org.jruby.nb.ext.ffi.Util;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"StructLayoutBuilder"}, parent="Object")
public final class StructLayoutBuilder
extends RubyObject {
    public static final String CLASS_NAME = "StructLayoutBuilder";
    static final int LONG_SIZE = Platform.getPlatform().longSize();
    static final int ADDRESS_SIZE = Platform.getPlatform().addressSize();
    static final long LONG_MASK = LONG_SIZE == 32 ? Integer.MAX_VALUE : Long.MAX_VALUE;
    static final int LONG_ALIGN = StructLayoutBuilder.isSparc() ? 64 : LONG_SIZE;
    static final int ADDRESS_ALIGN = StructLayoutBuilder.isSparc() ? 64 : ADDRESS_SIZE;
    static final int DOUBLE_ALIGN = StructLayoutBuilder.isSparc() ? 64 : ADDRESS_SIZE;
    static final int FLOAT_ALIGN = StructLayoutBuilder.isSparc() ? 64 : ADDRESS_SIZE;
    private final Map<IRubyObject, StructLayout.Member> fields = new LinkedHashMap<IRubyObject, StructLayout.Member>();
    private int size = 0;

    private static final boolean isSparc() {
        return false;
    }

    public static RubyClass createStructLayoutBuilderClass(Ruby runtime) {
        RubyModule parent = FFIProvider.getModule(runtime);
        RubyClass result = runtime.defineClassUnder(CLASS_NAME, runtime.getObject(), Allocator.INSTANCE, parent);
        result.defineAnnotatedMethods(StructLayoutBuilder.class);
        result.defineAnnotatedConstants(StructLayoutBuilder.class);
        return result;
    }

    StructLayoutBuilder(Ruby runtime) {
        this(runtime, FFIProvider.getModule(runtime).fastGetClass(CLASS_NAME));
    }

    StructLayoutBuilder(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static StructLayoutBuilder newInstance(ThreadContext context, IRubyObject recv) {
        return new StructLayoutBuilder(context.getRuntime());
    }

    @JRubyMethod(name={"build"})
    public StructLayout build(ThreadContext context) {
        return new StructLayout(context.getRuntime(), this.fields, this.size);
    }

    private static int alignMember(int offset, int alignBits) {
        int off = offset;
        int alignBytes = alignBits >> 3;
        int mask = alignBytes - 1;
        if ((off & mask) != 0) {
            off = (off & ~mask) + alignBytes;
        }
        return off;
    }

    @JRubyMethod(name={"add_field"}, required=2, optional=1)
    public IRubyObject add(ThreadContext context, IRubyObject[] args) {
        StructLayout.Member field;
        Ruby runtime = context.getRuntime();
        IRubyObject name = args[0];
        NativeType type = NativeType.valueOf(Util.int32Value(args[1]));
        int offset = args.length > 2 ? Util.int32Value(args[2]) : -1;
        int align = 8;
        int sizeBits = 8;
        switch (type) {
            case INT8: 
            case UINT8: {
                align = 8;
                sizeBits = 8;
                break;
            }
            case INT16: 
            case UINT16: {
                align = 16;
                sizeBits = 16;
                break;
            }
            case INT32: 
            case UINT32: {
                align = 32;
                sizeBits = 32;
                break;
            }
            case INT64: 
            case UINT64: {
                align = LONG_ALIGN;
                sizeBits = 64;
                break;
            }
            case LONG: 
            case ULONG: {
                align = LONG_ALIGN;
                sizeBits = LONG_SIZE;
                break;
            }
            case FLOAT32: {
                align = FLOAT_ALIGN;
                sizeBits = 32;
                break;
            }
            case FLOAT64: {
                align = DOUBLE_ALIGN;
                sizeBits = 64;
                break;
            }
            case POINTER: {
                align = Platform.getPlatform().addressSize();
                sizeBits = LONG_ALIGN;
                break;
            }
            case STRING: 
            case RBXSTRING: {
                align = ADDRESS_ALIGN;
                sizeBits = ADDRESS_SIZE;
            }
        }
        if (offset < 0) {
            offset = StructLayoutBuilder.alignMember(this.size, align);
        }
        if ((field = this.createMember(type, offset)) == null) {
            throw runtime.newArgumentError("Unknown field type: " + (Object)((Object)type));
        }
        this.fields.put(StructLayoutBuilder.createKey(runtime, name), field);
        this.size = offset + sizeBits / 8;
        return runtime.getNil();
    }

    @JRubyMethod(name={"add_char_array"}, required=2, optional=1)
    public IRubyObject add_char_array(ThreadContext context, IRubyObject[] args) {
        long offset;
        Ruby runtime = context.getRuntime();
        IRubyObject name = args[0];
        int strlen = Util.int32Value(args[1]);
        long l = offset = args.length > 2 ? Util.int64Value(args[2]) : -1L;
        if (offset < 0L) {
            offset = StructLayoutBuilder.alignMember(this.size, 8);
        }
        StructLayout.Member field = CharArrayMember.create(offset, strlen);
        this.fields.put(StructLayoutBuilder.createKey(runtime, name), field);
        this.size += strlen;
        return runtime.getNil();
    }

    private static IRubyObject createKey(Ruby runtime, IRubyObject key) {
        if (key instanceof RubySymbol) {
            return key;
        }
        return runtime.getSymbolTable().getSymbol(key.asJavaString());
    }

    StructLayout.Member createMember(NativeType type, long offset) {
        switch (type) {
            case INT8: {
                return Signed8Member.create(offset);
            }
            case UINT8: {
                return Unsigned8Member.create(offset);
            }
            case INT16: {
                return Signed16Member.create(offset);
            }
            case UINT16: {
                return Unsigned16Member.create(offset);
            }
            case INT32: {
                return Signed32Member.create(offset);
            }
            case UINT32: {
                return Unsigned32Member.create(offset);
            }
            case INT64: 
            case UINT64: {
                return Signed64Member.create(offset);
            }
            case LONG: {
                return LONG_SIZE == 32 ? Signed32Member.create(offset) : Signed64Member.create(offset);
            }
            case ULONG: {
                return LONG_SIZE == 32 ? Unsigned32Member.create(offset) : Signed64Member.create(offset);
            }
            case FLOAT32: {
                return Float32Member.create(offset);
            }
            case FLOAT64: {
                return Float64Member.create(offset);
            }
            case POINTER: {
                return PointerMember.create(offset);
            }
            case STRING: 
            case RBXSTRING: {
                return StringMember.create(offset);
            }
        }
        return null;
    }

    static final class CharArrayMember
    extends StructLayout.Member {
        private final int size;

        CharArrayMember(long offset, int size) {
            super(offset);
            this.size = size;
        }

        @Override
        public void put(Ruby runtime, IRubyObject ptr, IRubyObject value) {
            MemoryIO io = CharArrayMember.getMemoryIO(ptr);
            ByteList bl = value.convertToString().getByteList();
            int len = Math.min(bl.length(), this.size - 1);
            io.put(this.offset, bl.unsafeBytes(), bl.begin(), len);
            io.putByte(this.offset + (long)len, (byte)0);
        }

        @Override
        public IRubyObject get(Ruby runtime, IRubyObject ptr) {
            MemoryIO io = CharArrayMember.getMemoryIO(ptr);
            int len = io.indexOf(this.offset, (byte)0, this.size);
            if (len < 0) {
                len = this.size;
            }
            ByteList bl = new ByteList(len);
            bl.length(len);
            io.get(0L, bl.unsafeBytes(), bl.begin(), len);
            return runtime.newString(bl);
        }

        static StructLayout.Member create(long offset, int size) {
            return new CharArrayMember(offset, size);
        }
    }

    static final class StringMember
    extends StructLayout.Member {
        StringMember(long offset) {
            super(offset);
        }

        @Override
        public void put(Ruby runtime, IRubyObject ptr, IRubyObject value) {
            MemoryIO io = StringMember.getMemoryIO(ptr).getMemoryIO(this.offset);
            if (!io.isNull()) {
                ByteList bl = value.convertToString().getByteList();
                io.put(0L, bl.unsafeBytes(), bl.begin(), bl.length());
                io.putByte(bl.length(), (byte)0);
            }
        }

        @Override
        public IRubyObject get(Ruby runtime, IRubyObject ptr) {
            MemoryIO io = StringMember.getMemoryIO(ptr).getMemoryIO(this.offset);
            if (io.isNull()) {
                return runtime.getNil();
            }
            int len = io.indexOf(0L, (byte)0, Integer.MAX_VALUE);
            ByteList bl = new ByteList(len);
            bl.length(len);
            io.get(0L, bl.unsafeBytes(), bl.begin(), len);
            return runtime.newString(bl);
        }

        static StructLayout.Member create(long offset) {
            return new StringMember(offset);
        }
    }

    static final class Float64Member
    extends StructLayout.Member {
        Float64Member(long offset) {
            super(offset);
        }

        @Override
        public void put(Ruby runtime, IRubyObject ptr, IRubyObject value) {
            Float64Member.getMemoryIO(ptr).putDouble(this.offset, Util.doubleValue(value));
        }

        @Override
        public IRubyObject get(Ruby runtime, IRubyObject ptr) {
            return RubyFloat.newFloat(runtime, Float64Member.getMemoryIO(ptr).getDouble(this.offset));
        }

        static StructLayout.Member create(long offset) {
            return new Float64Member(offset);
        }
    }

    static final class Float32Member
    extends StructLayout.Member {
        Float32Member(long offset) {
            super(offset);
        }

        @Override
        public void put(Ruby runtime, IRubyObject ptr, IRubyObject value) {
            Float32Member.getMemoryIO(ptr).putFloat(this.offset, Util.floatValue(value));
        }

        @Override
        public IRubyObject get(Ruby runtime, IRubyObject ptr) {
            return RubyFloat.newFloat(runtime, Float32Member.getMemoryIO(ptr).getFloat(this.offset));
        }

        static StructLayout.Member create(long offset) {
            return new Float32Member(offset);
        }
    }

    static final class PointerMember
    extends StructLayout.Member {
        PointerMember(long offset) {
            super(offset);
        }

        @Override
        public void put(Ruby runtime, IRubyObject ptr, IRubyObject value) {
            if (value instanceof AbstractMemoryPointer) {
                PointerMember.getMemoryIO(ptr).putMemoryIO(this.offset, ((AbstractMemoryPointer)value).getMemoryIO());
            } else if (Platform.getPlatform().addressSize() == 32) {
                PointerMember.getMemoryIO(ptr).putInt(this.offset, Util.int32Value(value));
            } else if (Platform.getPlatform().addressSize() == 64) {
                PointerMember.getMemoryIO(ptr).putLong(this.offset, Util.int64Value(value));
            }
        }

        @Override
        public IRubyObject get(Ruby runtime, IRubyObject ptr) {
            return ((AbstractMemory)ptr).getMemoryPointer(runtime, this.offset);
        }

        static StructLayout.Member create(long offset) {
            return new PointerMember(offset);
        }
    }

    static final class Signed64Member
    extends StructLayout.Member {
        Signed64Member(long offset) {
            super(offset);
        }

        @Override
        public void put(Ruby runtime, IRubyObject ptr, IRubyObject value) {
            Signed64Member.getMemoryIO(ptr).putLong(this.offset, Util.int64Value(value));
        }

        @Override
        public IRubyObject get(Ruby runtime, IRubyObject ptr) {
            return RubyFixnum.newFixnum(runtime, Signed64Member.getMemoryIO(ptr).getLong(this.offset));
        }

        static StructLayout.Member create(long offset) {
            return new Signed64Member(offset);
        }
    }

    static final class Unsigned32Member
    extends StructLayout.Member {
        Unsigned32Member(long offset) {
            super(offset);
        }

        @Override
        public void put(Ruby runtime, IRubyObject ptr, IRubyObject value) {
            Unsigned32Member.getMemoryIO(ptr).putInt(this.offset, (int)Util.uint32Value(value));
        }

        @Override
        public IRubyObject get(Ruby runtime, IRubyObject ptr) {
            long value = Unsigned32Member.getMemoryIO(ptr).getInt(this.offset);
            return RubyFixnum.newFixnum(runtime, value < 0L ? (value & Integer.MAX_VALUE) + 0x80000000L : value);
        }

        static StructLayout.Member create(long offset) {
            return new Unsigned32Member(offset);
        }
    }

    static final class Signed32Member
    extends StructLayout.Member {
        Signed32Member(long offset) {
            super(offset);
        }

        @Override
        public void put(Ruby runtime, IRubyObject ptr, IRubyObject value) {
            Signed32Member.getMemoryIO(ptr).putInt(this.offset, Util.int32Value(value));
        }

        @Override
        public IRubyObject get(Ruby runtime, IRubyObject ptr) {
            return RubyFixnum.newFixnum(runtime, Signed32Member.getMemoryIO(ptr).getInt(this.offset));
        }

        static StructLayout.Member create(long offset) {
            return new Signed32Member(offset);
        }
    }

    static final class Unsigned16Member
    extends StructLayout.Member {
        Unsigned16Member(long offset) {
            super(offset);
        }

        @Override
        public void put(Ruby runtime, IRubyObject ptr, IRubyObject value) {
            Unsigned16Member.getMemoryIO(ptr).putShort(this.offset, (short)Util.uint16Value(value));
        }

        @Override
        public IRubyObject get(Ruby runtime, IRubyObject ptr) {
            short value = Unsigned16Member.getMemoryIO(ptr).getShort(this.offset);
            return RubyFixnum.newFixnum(runtime, value < 0 ? (long)((value & Short.MAX_VALUE) + 32768) : (long)value);
        }

        static StructLayout.Member create(long offset) {
            return new Unsigned16Member(offset);
        }
    }

    static final class Signed16Member
    extends StructLayout.Member {
        Signed16Member(long offset) {
            super(offset);
        }

        @Override
        public void put(Ruby runtime, IRubyObject ptr, IRubyObject value) {
            Signed16Member.getMemoryIO(ptr).putShort(this.offset, Util.int16Value(value));
        }

        @Override
        public IRubyObject get(Ruby runtime, IRubyObject ptr) {
            return RubyFixnum.newFixnum(runtime, Signed16Member.getMemoryIO(ptr).getShort(this.offset));
        }

        static StructLayout.Member create(long offset) {
            return new Signed16Member(offset);
        }
    }

    static final class Unsigned8Member
    extends StructLayout.Member {
        Unsigned8Member(long offset) {
            super(offset);
        }

        @Override
        public void put(Ruby runtime, IRubyObject ptr, IRubyObject value) {
            Unsigned8Member.getMemoryIO(ptr).putByte(this.offset, (byte)Util.uint8Value(value));
        }

        @Override
        public IRubyObject get(Ruby runtime, IRubyObject ptr) {
            byte value = Unsigned8Member.getMemoryIO(ptr).getByte(this.offset);
            return RubyFixnum.newFixnum(runtime, value < 0 ? (long)((short)((value & 0x7F) + 128)) : (long)value);
        }

        static StructLayout.Member create(long offset) {
            return new Unsigned8Member(offset);
        }
    }

    static final class Signed8Member
    extends StructLayout.Member {
        Signed8Member(long offset) {
            super(offset);
        }

        @Override
        public void put(Ruby runtime, IRubyObject ptr, IRubyObject value) {
            Signed8Member.getMemoryIO(ptr).putByte(this.offset, Util.int8Value(value));
        }

        @Override
        public IRubyObject get(Ruby runtime, IRubyObject ptr) {
            return RubyFixnum.newFixnum(runtime, Signed8Member.getMemoryIO(ptr).getByte(this.offset));
        }

        static StructLayout.Member create(long offset) {
            return new Signed8Member(offset);
        }
    }

    private static final class Allocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new Allocator();

        private Allocator() {
        }

        @Override
        public final IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new StructLayoutBuilder(runtime, klass);
        }
    }
}

