/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ext;

import java.io.IOException;
import java.lang.ref.WeakReference;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyException;
import org.jruby.nb.RubyKernel;
import org.jruby.nb.RubyObject;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.exceptions.RaiseException;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.runtime.load.Library;

@JRubyClass(name={"WeakRef"}, parent="Delegator")
public class WeakRef
extends RubyObject {
    private WeakReference<IRubyObject> ref;
    private static final ObjectAllocator WEAKREF_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
            return new WeakRef(runtime, klazz);
        }
    };

    public WeakRef(Ruby runtime, RubyClass klazz) {
        super(runtime, klazz);
    }

    @JRubyMethod(name={"__getobj__"})
    public IRubyObject getobj() {
        IRubyObject obj = (IRubyObject)this.ref.get();
        if (obj == null) {
            throw this.newRefError("Illegal Reference - probably recycled");
        }
        return obj;
    }

    @JRubyMethod(name={"new"}, required=1, meta=true)
    public static IRubyObject newInstance(IRubyObject clazz, IRubyObject arg) {
        WeakRef weakRef = (WeakRef)((RubyClass)clazz).allocate();
        weakRef.callInit(new IRubyObject[]{arg}, Block.NULL_BLOCK);
        return weakRef;
    }

    @JRubyMethod(name={"initialize"}, required=1, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject obj) {
        this.ref = new WeakReference<IRubyObject>(obj);
        return this.callSuper(this.getRuntime().getCurrentContext(), new IRubyObject[]{obj}, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"weakref_alive?"})
    public IRubyObject weakref_alive_p() {
        return this.ref.get() != null ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    private RaiseException newRefError(String message) {
        RubyException exception = (RubyException)this.getRuntime().getClass("RefError").newInstance(this.getRuntime().getCurrentContext(), new IRubyObject[]{this.getRuntime().newString(message)}, Block.NULL_BLOCK);
        return new RaiseException(exception);
    }

    @JRubyClass(name={"RefError"}, parent="StandardError")
    public static class RefError {
    }

    public static class WeakRefLibrary
    implements Library {
        @Override
        public void load(Ruby runtime, boolean wrap) throws IOException {
            RubyKernel.require(runtime.getKernel(), runtime.newString("delegate"), Block.NULL_BLOCK);
            RubyClass delegatorClass = (RubyClass)runtime.getClassFromPath("Delegator");
            RubyClass weakrefClass = runtime.defineClass("WeakRef", delegatorClass, WEAKREF_ALLOCATOR);
            weakrefClass.defineAnnotatedMethods(WeakRef.class);
            runtime.defineClass("RefError", runtime.getStandardError(), runtime.getStandardError().getAllocator());
        }
    }
}

