/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug.watchesfiltering;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.Variable;
import org.openide.util.WeakListeners;

public class JspElWatch
implements PropertyChangeListener {
    private final Watch watch;
    private boolean evaluated = false;
    private JPDADebugger debugger;
    private Variable variable;
    private Exception exception;

    public JspElWatch(Watch watch, JPDADebugger jPDADebugger) {
        this.watch = watch;
        this.debugger = jPDADebugger;
        watch.addPropertyChangeListener((PropertyChangeListener)WeakListeners.create(PropertyChangeListener.class, (EventListener)this, (Object)watch));
    }

    public String getExpression() {
        return this.watch.getExpression();
    }

    public String getType() {
        if (!this.evaluated) {
            this.evaluate();
        }
        return this.variable == null ? "" : this.variable.getType();
    }

    public String getValue() {
        if (!this.evaluated) {
            this.evaluate();
        }
        return this.variable == null ? "" : this.variable.getValue();
    }

    public String getExceptionDescription() {
        if (!this.evaluated) {
            this.evaluate();
        }
        return this.exception == null ? null : this.exception.getMessage();
    }

    public String getToStringValue() throws InvalidExpressionException {
        return this.getValue().toString();
    }

    public Watch getWatch() {
        return this.watch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void evaluate() {
        String string = this.watch.getExpression();
        string = string.replace("\"", "\\\"");
        string = "pageContext.getExpressionEvaluator().evaluate(\"" + string + "\", " + "java.lang.String.class, " + "((javax.servlet.jsp.PageContext) pageContext).getVariableResolver(), " + "null)";
        try {
            this.variable = this.debugger.evaluate(string);
            this.exception = null;
        }
        catch (Exception exception) {
            this.exception = exception;
        }
        finally {
            this.evaluated = true;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setUnevaluated();
    }

    public void setUnevaluated() {
        this.evaluated = false;
    }
}

