/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;

public class RandomUtils {
    static SecureRandom secureRandom;
    static volatile boolean seeded;
    private static Random random;

    private RandomUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized SecureRandom getSecureRandom() {
        block8: {
            if (secureRandom != null) {
                return secureRandom;
            }
            try {
                secureRandom = SecureRandom.getInstance("SHA1PRNG");
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
                            byte[] byArray = secureRandom.generateSeed(20);
                            SecureRandom secureRandom2 = RandomUtils.secureRandom;
                            synchronized (secureRandom2) {
                                RandomUtils.secureRandom.setSeed(byArray);
                                seeded = true;
                            }
                        }
                        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                            RandomUtils.warn("SecureRandom", noSuchAlgorithmException);
                        }
                    }
                };
                Thread thread = new Thread(runnable);
                thread.setDaemon(true);
                thread.start();
                Thread.yield();
                try {
                    thread.join(400L);
                }
                catch (InterruptedException interruptedException) {
                    RandomUtils.warn("InterruptedException", interruptedException);
                }
                if (seeded) break block8;
                byte[] byArray = RandomUtils.generateAlternativeSeed();
                SecureRandom secureRandom = RandomUtils.secureRandom;
                synchronized (secureRandom) {
                    RandomUtils.secureRandom.setSeed(byArray);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                RandomUtils.warn("SecureRandom", noSuchAlgorithmException);
                secureRandom = new SecureRandom();
            }
        }
        return secureRandom;
    }

    private static byte[] generateAlternativeSeed() {
        try {
            Object object;
            Object object2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeLong(System.currentTimeMillis());
            try {
                object2 = System.class.getMethod("nanoTime", new Class[0]);
                if (object2 != null) {
                    object = ((Method)object2).invoke(null, (Object[])null);
                    dataOutputStream.writeUTF(object.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            dataOutputStream.writeInt(new Object().hashCode());
            object2 = Runtime.getRuntime();
            dataOutputStream.writeLong(((Runtime)object2).freeMemory());
            dataOutputStream.writeLong(((Runtime)object2).maxMemory());
            dataOutputStream.writeLong(((Runtime)object2).totalMemory());
            try {
                dataOutputStream.writeUTF(System.getProperties().toString());
            }
            catch (Exception exception) {
                RandomUtils.warn("generateAlternativeSeed", exception);
            }
            try {
                object = InetAddress.getLocalHost().getHostName();
                dataOutputStream.writeUTF((String)object);
                InetAddress[] inetAddressArray = InetAddress.getAllByName((String)object);
                for (int i = 0; i < inetAddressArray.length; ++i) {
                    dataOutputStream.write(inetAddressArray[i].getAddress());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (int i = 0; i < 16; ++i) {
                int n = 0;
                long l = System.currentTimeMillis();
                while (l == System.currentTimeMillis()) {
                    ++n;
                }
                dataOutputStream.writeInt(n);
            }
            dataOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            RandomUtils.warn("generateAlternativeSeed", iOException);
            return new byte[1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getSecureLong() {
        SecureRandom secureRandom;
        SecureRandom secureRandom2 = secureRandom = RandomUtils.getSecureRandom();
        synchronized (secureRandom2) {
            return secureRandom.nextLong();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getSecureBytes(int n) {
        SecureRandom secureRandom;
        if (n <= 0) {
            n = 1;
        }
        byte[] byArray = new byte[n];
        SecureRandom secureRandom2 = secureRandom = RandomUtils.getSecureRandom();
        synchronized (secureRandom2) {
            secureRandom.nextBytes(byArray);
        }
        return byArray;
    }

    public static int nextInt(int n) {
        return random.nextInt(n);
    }

    static void warn(String string, Throwable throwable) {
        System.out.println("RandomUtils warning: " + string);
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }

    static {
        random = new Random();
    }
}

