/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.options;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.project.classpath.GlobalIncludePathSupport;
import org.netbeans.modules.php.project.environment.PhpEnvironment;
import org.netbeans.modules.php.project.ui.LastUsedFolders;
import org.netbeans.modules.php.project.ui.PathUiSupport;
import org.netbeans.modules.php.project.ui.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class PhpOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 10985641247986428L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final WatchesAndEvalListener watchesAndEvalListener = new WatchesAndEvalListener();
    private JButton addFolderButton;
    private JLabel commandLineLabel;
    private JSeparator commandLineSeparator;
    private JLabel debuggerPortLabel;
    private JTextField debuggerPortTextField;
    private JLabel debuggerSessionIdLabel;
    private JTextField debuggerSessionIdTextField;
    private JLabel debuggingLabel;
    private JSeparator debuggingSeparator;
    private JCheckBox editorCheckBox;
    private JLabel errorLabel;
    private JLabel globalIncludePathLabel;
    private JSeparator globalIncludePathSeparator;
    private JList includePathList;
    private JScrollPane includePathScrollPane;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JLabel openResultInLabel;
    private JCheckBox outputWindowCheckBox;
    private JButton phpInterpreterBrowseButton;
    private JLabel phpInterpreterLabel;
    private JButton phpInterpreterSearchButton;
    private JTextField phpInterpreterTextField;
    private JButton removeButton;
    private JCheckBox stopAtTheFirstLineCheckBox;
    private JLabel useTheFollowingPathByDefaultLabel;
    private JCheckBox watchesAndEvalCheckBox;
    private JCheckBox webBrowserCheckBox;

    public PhpOptionsPanel() {
        this.initComponents();
        this.errorLabel.setText(" ");
        this.initPhpGlobalIncludePath();
        DefaultDocumentListener documentListener = new DefaultDocumentListener();
        this.phpInterpreterTextField.getDocument().addDocumentListener(documentListener);
        this.debuggerPortTextField.getDocument().addDocumentListener(documentListener);
        this.debuggerSessionIdTextField.getDocument().addDocumentListener(documentListener);
        this.watchesAndEvalCheckBox.addItemListener(this.watchesAndEvalListener);
    }

    private void initPhpGlobalIncludePath() {
        DefaultListModel listModel = PathUiSupport.createListModel(GlobalIncludePathSupport.getInstance().itemsIterator());
        PathUiSupport.EditMediator.FileChooserDirectoryHandler directoryHandler = new PathUiSupport.EditMediator.FileChooserDirectoryHandler(){

            @Override
            public File getCurrentDirectory() {
                return LastUsedFolders.getIncludePath();
            }

            @Override
            public void setCurrentDirectory(File currentDirectory) {
                LastUsedFolders.setIncludePath(currentDirectory);
            }
        };
        this.includePathList.setModel(listModel);
        this.includePathList.setCellRenderer(new PathUiSupport.ClassPathListCellRenderer());
        PathUiSupport.EditMediator.register(this.includePathList, this.addFolderButton.getModel(), this.removeButton.getModel(), this.moveUpButton.getModel(), this.moveDownButton.getModel(), directoryHandler);
    }

    public String getPhpInterpreter() {
        return this.phpInterpreterTextField.getText();
    }

    public void setPhpInterpreter(String phpInterpreter) {
        this.phpInterpreterTextField.setText(phpInterpreter);
    }

    public boolean isOpenResultInOutputWindow() {
        return this.outputWindowCheckBox.isSelected();
    }

    public void setOpenResultInOutputWindow(boolean openResultInOutputWindow) {
        this.outputWindowCheckBox.setSelected(openResultInOutputWindow);
    }

    public boolean isOpenResultInBrowser() {
        return this.webBrowserCheckBox.isSelected();
    }

    public void setOpenResultInBrowser(boolean openResultInBrowser) {
        this.webBrowserCheckBox.setSelected(openResultInBrowser);
    }

    public boolean isOpenResultInEditor() {
        return this.editorCheckBox.isSelected();
    }

    public void setOpenResultInEditor(boolean openResultInEditor) {
        this.editorCheckBox.setSelected(openResultInEditor);
    }

    public Integer getDebuggerPort() {
        Integer port = null;
        try {
            port = Integer.parseInt(this.debuggerPortTextField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return port;
    }

    public String getDebuggerSessionId() {
        return this.debuggerSessionIdTextField.getText();
    }

    public void setDebuggerSessionId(String sessionId) {
        this.debuggerSessionIdTextField.setText(sessionId);
    }

    public void setDebuggerPort(int debuggerPort) {
        this.debuggerPortTextField.setText(String.valueOf(debuggerPort));
    }

    public boolean isDebuggerStoppedAtTheFirstLine() {
        return this.stopAtTheFirstLineCheckBox.isSelected();
    }

    public void setDebuggerStoppedAtTheFirstLine(boolean debuggerStoppedAtTheFirstLine) {
        this.stopAtTheFirstLineCheckBox.setSelected(debuggerStoppedAtTheFirstLine);
    }

    public boolean isDebuggerWatchesAndEval() {
        return this.watchesAndEvalCheckBox.isSelected();
    }

    public void setDebuggerWatchesAndEval(boolean debuggerWatchesAndEval) {
        this.watchesAndEvalCheckBox.removeItemListener(this.watchesAndEvalListener);
        this.watchesAndEvalCheckBox.setSelected(debuggerWatchesAndEval);
        this.watchesAndEvalCheckBox.addItemListener(this.watchesAndEvalListener);
    }

    public String getPhpGlobalIncludePath() {
        String[] paths = GlobalIncludePathSupport.getInstance().encodeToStrings(PathUiSupport.getIterator((DefaultListModel)this.includePathList.getModel()));
        StringBuilder path = new StringBuilder(200);
        for (String s : paths) {
            path.append(s);
        }
        return path.toString();
    }

    public void setError(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(message);
    }

    public void setWarning(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.warningForeground"));
        this.errorLabel.setText(message);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.commandLineSeparator = new JSeparator();
        this.commandLineLabel = new JLabel();
        this.phpInterpreterLabel = new JLabel();
        this.phpInterpreterTextField = new JTextField();
        this.phpInterpreterBrowseButton = new JButton();
        this.phpInterpreterSearchButton = new JButton();
        this.openResultInLabel = new JLabel();
        this.outputWindowCheckBox = new JCheckBox();
        this.webBrowserCheckBox = new JCheckBox();
        this.editorCheckBox = new JCheckBox();
        this.debuggingSeparator = new JSeparator();
        this.debuggingLabel = new JLabel();
        this.debuggerPortLabel = new JLabel();
        this.debuggerPortTextField = new JTextField();
        this.debuggerSessionIdLabel = new JLabel();
        this.debuggerSessionIdTextField = new JTextField();
        this.stopAtTheFirstLineCheckBox = new JCheckBox();
        this.watchesAndEvalCheckBox = new JCheckBox();
        this.globalIncludePathSeparator = new JSeparator();
        this.globalIncludePathLabel = new JLabel();
        this.useTheFollowingPathByDefaultLabel = new JLabel();
        this.includePathScrollPane = new JScrollPane();
        this.includePathList = new JList();
        this.addFolderButton = new JButton();
        this.removeButton = new JButton();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.errorLabel = new JLabel();
        this.setFocusTraversalPolicy(null);
        this.commandLineLabel.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.commandLineLabel, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_CommandLine"));
        this.phpInterpreterLabel.setLabelFor(this.phpInterpreterTextField);
        Mnemonics.setLocalizedText((JLabel)this.phpInterpreterLabel, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_PhpInterpreter"));
        Mnemonics.setLocalizedText((AbstractButton)this.phpInterpreterBrowseButton, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_Browse"));
        this.phpInterpreterBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhpOptionsPanel.this.phpInterpreterBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.phpInterpreterSearchButton, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_Search"));
        this.phpInterpreterSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhpOptionsPanel.this.phpInterpreterSearchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.openResultInLabel, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_OpenResultIn"));
        Mnemonics.setLocalizedText((AbstractButton)this.outputWindowCheckBox, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_OutputWindow"));
        Mnemonics.setLocalizedText((AbstractButton)this.webBrowserCheckBox, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_WebBrowser"));
        Mnemonics.setLocalizedText((AbstractButton)this.editorCheckBox, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_Editor"));
        this.debuggingLabel.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.debuggingLabel, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_Debugging"));
        this.debuggerPortLabel.setLabelFor(this.debuggerPortTextField);
        Mnemonics.setLocalizedText((JLabel)this.debuggerPortLabel, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_DebuggerPort"));
        this.debuggerSessionIdLabel.setLabelFor(this.debuggerSessionIdTextField);
        Mnemonics.setLocalizedText((JLabel)this.debuggerSessionIdLabel, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.debuggerSessionIdLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.stopAtTheFirstLineCheckBox, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_StopAtTheFirstLine"));
        Mnemonics.setLocalizedText((AbstractButton)this.watchesAndEvalCheckBox, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.watchesAndEvalCheckBox.text"));
        this.globalIncludePathLabel.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.globalIncludePathLabel, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_GlobalIncludePath"));
        this.useTheFollowingPathByDefaultLabel.setLabelFor(this.includePathList);
        Mnemonics.setLocalizedText((JLabel)this.useTheFollowingPathByDefaultLabel, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_UseTheFollowingPathByDefault"));
        this.includePathScrollPane.setViewportView(this.includePathList);
        this.includePathList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.includePathList.AccessibleContext.accessibleName"));
        this.includePathList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.includePathList.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.addFolderButton, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_AddFolder"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_Remove"));
        Mnemonics.setLocalizedText((AbstractButton)this.moveUpButton, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_MoveUp"));
        Mnemonics.setLocalizedText((AbstractButton)this.moveDownButton, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_MoveDown"));
        this.errorLabel.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)"ERROR");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.phpInterpreterLabel).addComponent(this.openResultInLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.phpInterpreterTextField, -1, 243, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phpInterpreterBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phpInterpreterSearchButton)).addGroup(layout.createSequentialGroup().addComponent(this.outputWindowCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.webBrowserCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editorCheckBox)))).addGroup(layout.createSequentialGroup().addComponent(this.commandLineLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.commandLineSeparator, -1, 424, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.debuggingLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.debuggingSeparator, -1, 452, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.stopAtTheFirstLineCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.watchesAndEvalCheckBox)).addGroup(layout.createSequentialGroup().addComponent(this.debuggerPortLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.debuggerPortTextField, -2, 101, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.debuggerSessionIdLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.debuggerSessionIdTextField, -2, 124, -2)))).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.includePathScrollPane, -1, 423, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.addFolderButton).addComponent(this.removeButton).addComponent(this.moveUpButton).addComponent(this.moveDownButton))).addComponent(this.useTheFollowingPathByDefaultLabel))).addComponent(this.errorLabel).addGroup(layout.createSequentialGroup().addComponent(this.globalIncludePathLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.globalIncludePathSeparator, -1, 399, Short.MAX_VALUE)));
        layout.linkSize(0, this.addFolderButton, this.moveDownButton, this.moveUpButton, this.removeButton);
        layout.linkSize(0, this.phpInterpreterBrowseButton, this.phpInterpreterSearchButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.commandLineLabel).addComponent(this.commandLineSeparator, -2, 10, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.phpInterpreterBrowseButton).addComponent(this.phpInterpreterTextField, -2, -1, -2).addComponent(this.phpInterpreterSearchButton).addComponent(this.phpInterpreterLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputWindowCheckBox).addComponent(this.webBrowserCheckBox).addComponent(this.editorCheckBox).addComponent(this.openResultInLabel)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.debuggingLabel).addComponent(this.debuggingSeparator, -2, 10, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.debuggerPortLabel).addComponent(this.debuggerPortTextField, -2, -1, -2).addComponent(this.debuggerSessionIdLabel).addComponent(this.debuggerSessionIdTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stopAtTheFirstLineCheckBox).addComponent(this.watchesAndEvalCheckBox)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.globalIncludePathLabel).addComponent(this.globalIncludePathSeparator, -2, 10, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useTheFollowingPathByDefaultLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.includePathScrollPane, -1, 164, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.addFolderButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moveUpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moveDownButton))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorLabel)));
        this.commandLineSeparator.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.commandLineSeparator.AccessibleContext.accessibleName_1"));
        this.commandLineSeparator.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.commandLineSeparator.AccessibleContext.accessibleDescription_1"));
        this.commandLineLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.commandLineLabel.AccessibleContext.accessibleName"));
        this.commandLineLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.commandLineLabel.AccessibleContext.accessibleDescription"));
        this.phpInterpreterLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.phpInterpreterLabel.AccessibleContext.accessibleName"));
        this.phpInterpreterLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.phpInterpreterLabel.AccessibleContext.accessibleDescription"));
        this.phpInterpreterTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.phpInterpreterTextField.AccessibleContext.accessibleName"));
        this.phpInterpreterTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.phpInterpreterTextField.AccessibleContext.accessibleDescription"));
        this.phpInterpreterBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.browseButton.AccessibleContext.accessibleName"));
        this.phpInterpreterBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.browseButton.AccessibleContext.accessibleDescription"));
        this.phpInterpreterSearchButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.searchButton.AccessibleContext.accessibleName"));
        this.phpInterpreterSearchButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.searchButton.AccessibleContext.accessibleDescription"));
        this.openResultInLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.openResultInLabel.AccessibleContext.accessibleName"));
        this.openResultInLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.openResultInLabel.AccessibleContext.accessibleDescription"));
        this.outputWindowCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.outputWindowCheckBox.AccessibleContext.accessibleName"));
        this.outputWindowCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.outputWindowCheckBox.AccessibleContext.accessibleDescription"));
        this.webBrowserCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.webBrowserCheckBox.AccessibleContext.accessibleName"));
        this.webBrowserCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.webBrowserCheckBox.AccessibleContext.accessibleDescription"));
        this.editorCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.editorCheckBox.AccessibleContext.accessibleName"));
        this.editorCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.editorCheckBox.AccessibleContext.accessibleDescription"));
        this.debuggingSeparator.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.debuggingSeparator.AccessibleContext.accessibleName_1"));
        this.debuggingSeparator.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.debuggingSeparator.AccessibleContext.accessibleDescription_1"));
        this.debuggingLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.debuggingLabel.AccessibleContext.accessibleName"));
        this.debuggingLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.debuggingLabel.AccessibleContext.accessibleDescription"));
        this.debuggerPortLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.debuggerPortLabel.AccessibleContext.accessibleName"));
        this.debuggerPortLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.debuggerPortLabel.AccessibleContext.accessibleDescription"));
        this.debuggerPortTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.debuggerPortTextField.AccessibleContext.accessibleName"));
        this.debuggerPortTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.debuggerPortTextField.AccessibleContext.accessibleDescription"));
        this.debuggerSessionIdLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.debuggerSessionIdLabel.AccessibleContext.accessibleName"));
        this.debuggerSessionIdLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.debuggerSessionIdLabel.AccessibleContext.accessibleDescription"));
        this.debuggerSessionIdTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.debuggerSessionIdTextField.AccessibleContext.accessibleName"));
        this.debuggerSessionIdTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.debuggerSessionIdTextField.AccessibleContext.accessibleDescription"));
        this.stopAtTheFirstLineCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.stopAtTheFirstLineCheckBox.AccessibleContext.accessibleName"));
        this.stopAtTheFirstLineCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.stopAtTheFirstLineCheckBox.AccessibleContext.accessibleDescription"));
        this.watchesAndEvalCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.watchesAndEvalCheckBox.AccessibleContext.accessibleName"));
        this.watchesAndEvalCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.watchesAndEvalCheckBox.AccessibleContext.accessibleDescription"));
        this.globalIncludePathSeparator.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.globalIncludePathSeparator.AccessibleContext.accessibleName_1"));
        this.globalIncludePathSeparator.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.globalIncludePathSeparator.AccessibleContext.accessibleDescription_1"));
        this.globalIncludePathLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.globalIncludePathLabel.AccessibleContext.accessibleName"));
        this.globalIncludePathLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.globalIncludePathLabel.AccessibleContext.accessibleDescription"));
        this.useTheFollowingPathByDefaultLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.useTheFollowingPathByDefaultLabel.AccessibleContext.accessibleName"));
        this.useTheFollowingPathByDefaultLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.useTheFollowingPathByDefaultLabel.AccessibleContext.accessibleDescription"));
        this.includePathScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.includePathScrollPane.AccessibleContext.accessibleName"));
        this.includePathScrollPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.includePathScrollPane.AccessibleContext.accessibleDescription"));
        this.addFolderButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.addFolderButton.AccessibleContext.accessibleName"));
        this.addFolderButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.addFolderButton.AccessibleContext.accessibleDescription"));
        this.removeButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.removeButton.AccessibleContext.accessibleName"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.removeButton.AccessibleContext.accessibleDescription"));
        this.moveUpButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.moveUpButton.AccessibleContext.accessibleName"));
        this.moveUpButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.moveUpButton.AccessibleContext.accessibleDescription"));
        this.moveDownButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.moveDownButton.AccessibleContext.accessibleName"));
        this.moveDownButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.moveDownButton.AccessibleContext.accessibleDescription"));
        this.errorLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.errorLabel.AccessibleContext.accessibleName"));
        this.errorLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.errorLabel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.AccessibleContext.accessibleDescription"));
    }

    private void phpInterpreterBrowseButtonActionPerformed(ActionEvent evt) {
        Utils.browsePhpInterpreter(this, this.phpInterpreterTextField);
    }

    private void phpInterpreterSearchButtonActionPerformed(ActionEvent evt) {
        String phpInterpreter = UiUtils.SearchWindow.search((UiUtils.SearchWindow.SearchWindowSupport)new UiUtils.SearchWindow.SearchWindowSupport(){

            public List<String> detect() {
                return PhpEnvironment.get().getAllPhpInterpreters();
            }

            public String getWindowTitle() {
                return NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_PhpInterpretersTitle");
            }

            public String getListTitle() {
                return NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_PhpInterpreters");
            }

            public String getPleaseWaitPart() {
                return NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_PhpInterpretersPleaseWaitPart");
            }

            public String getNoItemsFound() {
                return NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_NoPhpInterpretersFound");
            }
        });
        if (phpInterpreter != null) {
            this.phpInterpreterTextField.setText(phpInterpreter);
        }
    }

    private static final class WatchesAndEvalListener
    implements ItemListener {
        private static boolean warningShown = false;

        private WatchesAndEvalListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (warningShown) {
                return;
            }
            if (e.getStateChange() == 1) {
                NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)NbBundle.getMessage(PhpOptionsPanel.class, (String)"MSG_WatchesAndEval"), 2);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)descriptor);
                warningShown = true;
            }
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            PhpOptionsPanel.this.fireChange();
        }
    }
}

