/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.flow.visual;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.netbeans.api.visual.action.AcceptProvider;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.ConnectDecorator;
import org.netbeans.api.visual.action.ConnectProvider;
import org.netbeans.api.visual.action.ConnectorState;
import org.netbeans.api.visual.action.EditProvider;
import org.netbeans.api.visual.action.MoveControlPointProvider;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.ReconnectDecorator;
import org.netbeans.api.visual.action.ReconnectProvider;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.graph.GraphPinScene;
import org.netbeans.api.visual.graph.layout.GridGraphLayout;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.layout.SceneLayout;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.model.ObjectSceneEvent;
import org.netbeans.api.visual.model.ObjectSceneEventType;
import org.netbeans.api.visual.model.ObjectSceneListener;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.router.ConnectionWidgetCollisionsCollector;
import org.netbeans.api.visual.router.Router;
import org.netbeans.api.visual.router.RouterFactory;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.EventProcessingType;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.vmd.api.flow.FlowPinOrderPresenter;
import org.netbeans.modules.vmd.api.flow.FlowPresenter;
import org.netbeans.modules.vmd.api.flow.FlowScenePresenter;
import org.netbeans.modules.vmd.api.flow.visual.FlowBadgeDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowEdgeDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowNodeDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowPinDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.OrthogonalCollisionsCollector;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.presenters.actions.ActionsSupport;
import org.netbeans.modules.vmd.api.palette.PaletteSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.Utilities;

public final class FlowScene
extends GraphPinScene<FlowNodeDescriptor, FlowEdgeDescriptor, FlowPinDescriptor> {
    private static Paint PAINT_BACKGROUND;
    private DesignDocument document;
    private LayerWidget backgroundLayer;
    private LayerWidget mainLayer;
    private LayerWidget connectionLayer;
    private LayerWidget interractionLayer;
    private WidgetAction moveAction;
    private WidgetAction acceptAction;
    private WidgetAction connectAction;
    private WidgetAction reconnectAction;
    private WidgetAction moveControlPointAction;
    private WidgetAction renameAction;
    private WidgetAction popupMenuAction;
    private WidgetAction editAction;
    private WidgetAction sceneSelectAction;
    private WidgetAction sceneKeyAction;
    private Router edgeRouter;
    private HashMap<CacheNodeDescriptor, Point> preferredNodeLocationCache = new HashMap();
    private HashMap<Long, Point> preferredNodeLocationMap = new HashMap();
    private Long eventID;
    private HashMap<FlowNodeDescriptor, FlowPresenter.FlowUIResolver> nodeUIregistry = new HashMap();
    private HashMap<FlowPinDescriptor, FlowPresenter.FlowUIResolver> pinUIregistry = new HashMap();
    private HashMap<FlowEdgeDescriptor, FlowPresenter.FlowUIResolver> edgeUIregistry = new HashMap();
    private HashMap<FlowBadgeDescriptor, FlowPresenter.FlowUIResolver> pinBadgeUIregistry = new HashMap();
    private HashMap<FlowDescriptor, ArrayList<FlowBadgeDescriptor>> badges = new HashMap();
    private HashSet<FlowNodeDescriptor> nodesForOrdering = new HashSet();
    private GridGraphLayout<FlowNodeDescriptor, FlowEdgeDescriptor> graphLayout;
    private SceneLayout sceneLayout;

    public FlowScene(DesignDocument designDocument) {
        this.document = designDocument;
        this.setOpaque(true);
        this.setBackground(PAINT_BACKGROUND);
        this.setKeyEventProcessingType(EventProcessingType.FOCUSED_WIDGET_AND_ITS_PARENTS);
        this.backgroundLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.backgroundLayer);
        this.mainLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.mainLayer);
        this.connectionLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.connectionLayer);
        this.interractionLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.interractionLayer);
        this.moveAction = ActionFactory.createMoveAction(null, (MoveProvider)new FlowMoveProvider());
        this.acceptAction = ActionFactory.createAcceptAction((AcceptProvider)new FlowAcceptProvider());
        FlowConnectDecoratorProvider flowConnectDecoratorProvider = new FlowConnectDecoratorProvider();
        this.connectAction = ActionFactory.createConnectAction((ConnectDecorator)flowConnectDecoratorProvider, (LayerWidget)this.interractionLayer, (ConnectProvider)flowConnectDecoratorProvider);
        FlowReconnectDecoratorProvider flowReconnectDecoratorProvider = new FlowReconnectDecoratorProvider();
        this.reconnectAction = ActionFactory.createReconnectAction((ReconnectDecorator)flowReconnectDecoratorProvider, (ReconnectProvider)flowReconnectDecoratorProvider);
        this.moveControlPointAction = ActionFactory.createMoveControlPointAction((MoveControlPointProvider)ActionFactory.createOrthogonalMoveControlPointProvider(), (ConnectionWidget.RoutingPolicy)ConnectionWidget.RoutingPolicy.DISABLE_ROUTING_UNTIL_END_POINT_IS_MOVED);
        this.renameAction = ActionFactory.createInplaceEditorAction((TextFieldInplaceEditor)new FlowRenameEditor());
        this.editAction = ActionFactory.createEditAction((EditProvider)new FlowEditProvider());
        this.popupMenuAction = ActionFactory.createPopupMenuAction((PopupMenuProvider)new FlowPopupMenuProvider());
        this.sceneSelectAction = new FlowSceneSelectAction();
        this.sceneKeyAction = new FlowSceneKeyAction();
        this.edgeRouter = RouterFactory.createOrthogonalSearchRouter((ConnectionWidgetCollisionsCollector)new OrthogonalCollisionsCollector(this.mainLayer, this.connectionLayer));
        this.getActions().addAction(ActionFactory.createMouseCenteredZoomAction((double)1.2));
        this.getActions().addAction(ActionFactory.createPanAction());
        this.getActions().addAction(this.sceneSelectAction);
        this.getActions().addAction(this.createSelectAction());
        this.getActions().addAction(this.createAcceptAction());
        this.getActions().addAction(this.popupMenuAction);
        this.getActions().addAction(ActionFactory.createRectangularSelectAction((ObjectScene)this, (LayerWidget)this.backgroundLayer));
        this.getActions().addAction(ActionFactory.createCycleObjectSceneFocusAction());
        this.getActions().addAction(this.sceneKeyAction);
        this.graphLayout = new GridGraphLayout().setChecker(true);
        this.sceneLayout = LayoutFactory.createSceneGraphLayout((GraphPinScene)this, this.graphLayout);
        this.addObjectSceneListener(new FlowObjectSceneListener(), new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_SELECTION_CHANGED});
    }

    public DesignDocument getDocument() {
        return this.document;
    }

    public void setCurrentEventIDForPreferredNodeLocationProcessing(Long l) {
        this.eventID = l;
        if (l != null) {
            Iterator<Map.Entry<Long, Point>> iterator = this.preferredNodeLocationMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, Point> entry = iterator.next();
                if (entry.getKey() >= l) continue;
                iterator.remove();
            }
        }
    }

    protected Widget attachNodeWidget(FlowNodeDescriptor flowNodeDescriptor) {
        Widget widget = this.getDecorator(flowNodeDescriptor).createWidget(flowNodeDescriptor, this);
        Point point = this.preferredNodeLocationCache.get(new CacheNodeDescriptor(flowNodeDescriptor));
        if (point == null) {
            Point point2 = point = this.eventID != null ? this.preferredNodeLocationMap.get(this.eventID) : null;
        }
        if (point == null) {
            point = new Point(50, 50);
        }
        widget.setPreferredLocation(point);
        this.mainLayer.addChild(widget);
        return widget;
    }

    protected void detachNodeWidget(FlowNodeDescriptor flowNodeDescriptor, Widget widget) {
        if (widget != null) {
            this.preferredNodeLocationCache.put(new CacheNodeDescriptor(flowNodeDescriptor), widget.getPreferredLocation());
        }
        super.detachNodeWidget((Object)flowNodeDescriptor, widget);
    }

    protected Widget attachPinWidget(FlowNodeDescriptor flowNodeDescriptor, FlowPinDescriptor flowPinDescriptor) {
        FlowPinDescriptor.PinDecorator pinDecorator = this.getDecorator(flowPinDescriptor);
        Widget widget = pinDecorator.createWidget(flowPinDescriptor, this);
        if (widget != null) {
            this.getDecorator((FlowNodeDescriptor)this.findStoredObject(flowNodeDescriptor)).attachPinWidget(flowNodeDescriptor, this, widget);
        }
        return widget;
    }

    protected Widget attachEdgeWidget(FlowEdgeDescriptor flowEdgeDescriptor) {
        Widget widget = this.getDecorator(flowEdgeDescriptor).create(flowEdgeDescriptor, this);
        assert (widget instanceof ConnectionWidget);
        this.connectionLayer.addChild(widget);
        return widget;
    }

    protected void attachEdgeSourceAnchor(FlowEdgeDescriptor flowEdgeDescriptor, FlowPinDescriptor flowPinDescriptor, FlowPinDescriptor flowPinDescriptor2) {
        Anchor anchor = null;
        if (flowPinDescriptor2 != null) {
            anchor = this.getDecorator(flowPinDescriptor2).createAnchor(flowPinDescriptor2, this);
        }
        this.getDecorator(flowEdgeDescriptor).setSourceAnchor(flowEdgeDescriptor, this, anchor);
    }

    protected void attachEdgeTargetAnchor(FlowEdgeDescriptor flowEdgeDescriptor, FlowPinDescriptor flowPinDescriptor, FlowPinDescriptor flowPinDescriptor2) {
        Anchor anchor = null;
        if (flowPinDescriptor2 != null) {
            anchor = this.getDecorator(flowPinDescriptor2).createAnchor(flowPinDescriptor2, this);
        }
        this.getDecorator(flowEdgeDescriptor).setTargetAnchor(flowEdgeDescriptor, this, anchor);
    }

    public Router createEdgeRouter() {
        return this.edgeRouter;
    }

    public WidgetAction createMoveAction() {
        return this.moveAction;
    }

    public WidgetAction createAcceptAction() {
        return this.acceptAction;
    }

    public WidgetAction createMoveControlPointAction() {
        return this.moveControlPointAction;
    }

    public WidgetAction createRenameAction() {
        return this.renameAction;
    }

    public WidgetAction createConnectAction() {
        return this.connectAction;
    }

    public WidgetAction createReconnectAction() {
        return this.reconnectAction;
    }

    public WidgetAction createPopupMenuAction() {
        return this.popupMenuAction;
    }

    public WidgetAction createEditAction() {
        return this.editAction;
    }

    public void userSelectionSuggested(Set<? extends Object> set, boolean bl) {
        super.userSelectionSuggested(set, bl);
        this.document.getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                ArrayList<DesignComponent> arrayList = new ArrayList<DesignComponent>();
                DesignComponent designComponent = FlowScene.this.getSelectedObjects().iterator();
                while (designComponent.hasNext()) {
                    Object e = designComponent.next();
                    DesignComponent designComponent2 = e instanceof FlowDescriptor ? ((FlowDescriptor)e).getRepresentedComponent() : null;
                    if (designComponent2 == null) continue;
                    arrayList.add(designComponent2);
                }
                if (arrayList.isEmpty() && (designComponent = FlowScene.this.document.getRootComponent()) != null) {
                    arrayList.add(designComponent);
                }
                FlowScene.this.document.setSelectedComponents("flow", arrayList);
            }
        });
    }

    public void addNodeCommonActions(Widget widget) {
        WidgetAction.Chain chain = widget.getActions();
        chain.addAction(this.createObjectHoverAction());
        chain.addAction(this.createSelectAction());
        chain.addAction(this.createMoveAction());
        chain.addAction(this.createAcceptAction());
        chain.addAction(this.createPopupMenuAction());
        chain.addAction(this.createEditAction());
    }

    public void addEdgeCommonActions(ConnectionWidget connectionWidget) {
        WidgetAction.Chain chain = connectionWidget.getActions();
        chain.addAction(this.createObjectHoverAction());
        chain.addAction(this.createSelectAction());
        chain.addAction(this.createReconnectAction());
        chain.addAction(this.createPopupMenuAction());
        chain.addAction(this.createEditAction());
    }

    public void addPinCommonActions(Widget widget) {
        WidgetAction.Chain chain = widget.getActions();
        chain.addAction(this.createObjectHoverAction());
        widget.getActions().addAction(this.createSelectAction());
        widget.getActions().addAction(this.createAcceptAction());
        widget.getActions().addAction(this.createConnectAction());
        chain.addAction(this.createPopupMenuAction());
        chain.addAction(this.createEditAction());
    }

    public void addBadge(FlowDescriptor flowDescriptor, FlowBadgeDescriptor flowBadgeDescriptor) {
        if (flowBadgeDescriptor == null) {
            return;
        }
        ArrayList<FlowBadgeDescriptor> arrayList = this.badges.get(flowDescriptor);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.badges.put(flowDescriptor, arrayList);
        }
        arrayList.add(flowBadgeDescriptor);
    }

    public void removeBadge(FlowDescriptor flowDescriptor, FlowBadgeDescriptor flowBadgeDescriptor) {
        ArrayList<FlowBadgeDescriptor> arrayList = this.badges.get(flowDescriptor);
        if (arrayList == null) {
            return;
        }
        arrayList.remove(flowBadgeDescriptor);
        if (arrayList.isEmpty()) {
            this.badges.remove(flowDescriptor);
        }
    }

    public void updateBadges(FlowDescriptor flowDescriptor) {
        FlowDescriptor.BadgeDecorator badgeDecorator = this.getAbstractDecorator(flowDescriptor, FlowDescriptor.BadgeDecorator.class);
        if (badgeDecorator == null) {
            return;
        }
        ArrayList<FlowBadgeDescriptor> arrayList = this.badges.get(flowDescriptor);
        if (arrayList != null) {
            Collections.sort(arrayList, new Comparator<FlowBadgeDescriptor>(){

                @Override
                public int compare(FlowBadgeDescriptor flowBadgeDescriptor, FlowBadgeDescriptor flowBadgeDescriptor2) {
                    return FlowScene.this.getDecorator(flowBadgeDescriptor).getOrder(flowBadgeDescriptor) - FlowScene.this.getDecorator(flowBadgeDescriptor2).getOrder(flowBadgeDescriptor2);
                }
            });
            badgeDecorator.updateBadges(flowDescriptor, this, arrayList);
        } else {
            badgeDecorator.updateBadges(flowDescriptor, this, Collections.<FlowBadgeDescriptor>emptyList());
        }
    }

    public void registerUI(FlowNodeDescriptor flowNodeDescriptor, FlowPresenter.FlowUIResolver flowUIResolver) {
        assert (flowUIResolver != null);
        this.nodeUIregistry.put(flowNodeDescriptor, flowUIResolver);
    }

    public void unregisterUI(FlowNodeDescriptor flowNodeDescriptor, FlowPresenter.FlowUIResolver flowUIResolver) {
        FlowPresenter.FlowUIResolver flowUIResolver2 = this.nodeUIregistry.remove(flowNodeDescriptor);
        assert (flowUIResolver == flowUIResolver2);
    }

    public FlowNodeDescriptor.NodeDecorator getDecorator(FlowNodeDescriptor flowNodeDescriptor) {
        return (FlowNodeDescriptor.NodeDecorator)this.nodeUIregistry.get(flowNodeDescriptor).getDecorator();
    }

    public FlowNodeDescriptor.NodeBehaviour getBehaviour(FlowNodeDescriptor flowNodeDescriptor) {
        return (FlowNodeDescriptor.NodeBehaviour)this.nodeUIregistry.get(flowNodeDescriptor).getBehaviour();
    }

    public void registerUI(FlowPinDescriptor flowPinDescriptor, FlowPresenter.FlowUIResolver flowUIResolver) {
        assert (flowUIResolver != null);
        this.pinUIregistry.put(flowPinDescriptor, flowUIResolver);
    }

    public void unregisterUI(FlowPinDescriptor flowPinDescriptor, FlowPresenter.FlowUIResolver flowUIResolver) {
        FlowPresenter.FlowUIResolver flowUIResolver2 = this.pinUIregistry.remove(flowPinDescriptor);
        assert (flowUIResolver == flowUIResolver2);
    }

    public FlowPinDescriptor.PinDecorator getDecorator(FlowPinDescriptor flowPinDescriptor) {
        return (FlowPinDescriptor.PinDecorator)this.pinUIregistry.get(flowPinDescriptor).getDecorator();
    }

    public FlowPinDescriptor.PinBehaviour getBehaviour(FlowPinDescriptor flowPinDescriptor) {
        return (FlowPinDescriptor.PinBehaviour)this.pinUIregistry.get(flowPinDescriptor).getBehaviour();
    }

    public void registerUI(FlowEdgeDescriptor flowEdgeDescriptor, FlowPresenter.FlowUIResolver flowUIResolver) {
        assert (flowUIResolver != null);
        this.edgeUIregistry.put(flowEdgeDescriptor, flowUIResolver);
    }

    public void unregisterUI(FlowEdgeDescriptor flowEdgeDescriptor, FlowPresenter.FlowUIResolver flowUIResolver) {
        FlowPresenter.FlowUIResolver flowUIResolver2 = this.edgeUIregistry.remove(flowEdgeDescriptor);
        assert (flowUIResolver == flowUIResolver2);
    }

    public FlowEdgeDescriptor.EdgeDecorator getDecorator(FlowEdgeDescriptor flowEdgeDescriptor) {
        return (FlowEdgeDescriptor.EdgeDecorator)this.edgeUIregistry.get(flowEdgeDescriptor).getDecorator();
    }

    public FlowEdgeDescriptor.EdgeBehaviour getBehaviour(FlowEdgeDescriptor flowEdgeDescriptor) {
        return (FlowEdgeDescriptor.EdgeBehaviour)this.edgeUIregistry.get(flowEdgeDescriptor).getBehaviour();
    }

    public void registerUI(FlowBadgeDescriptor flowBadgeDescriptor, FlowPresenter.FlowUIResolver flowUIResolver) {
        assert (flowUIResolver != null);
        this.pinBadgeUIregistry.put(flowBadgeDescriptor, flowUIResolver);
    }

    public void unregisterUI(FlowBadgeDescriptor flowBadgeDescriptor, FlowPresenter.FlowUIResolver flowUIResolver) {
        FlowPresenter.FlowUIResolver flowUIResolver2 = this.pinBadgeUIregistry.remove(flowBadgeDescriptor);
        assert (flowUIResolver == flowUIResolver2);
    }

    public FlowBadgeDescriptor.BadgeDecorator getDecorator(FlowBadgeDescriptor flowBadgeDescriptor) {
        return (FlowBadgeDescriptor.BadgeDecorator)this.pinBadgeUIregistry.get(flowBadgeDescriptor).getDecorator();
    }

    public FlowBadgeDescriptor.BadgeBehaviour getBehaviour(FlowBadgeDescriptor flowBadgeDescriptor) {
        return (FlowBadgeDescriptor.BadgeBehaviour)this.pinBadgeUIregistry.get(flowBadgeDescriptor).getBehaviour();
    }

    private <T extends FlowDescriptor.Decorator> T getAbstractDecorator(FlowDescriptor flowDescriptor, Class<T> clazz) {
        if (flowDescriptor == null) {
            return null;
        }
        FlowPresenter.FlowUIResolver flowUIResolver = this.nodeUIregistry.get(flowDescriptor);
        if (flowUIResolver == null && (flowUIResolver = this.pinUIregistry.get(flowDescriptor)) == null && (flowUIResolver = this.edgeUIregistry.get(flowDescriptor)) == null && (flowUIResolver = this.pinBadgeUIregistry.get(flowDescriptor)) == null) {
            return null;
        }
        FlowDescriptor.Decorator decorator = flowUIResolver.getDecorator();
        return (T)(clazz.isInstance(decorator) ? decorator : null);
    }

    private <T extends FlowDescriptor.Behaviour> T getAbstractBehaviour(FlowDescriptor flowDescriptor, Class<T> clazz) {
        if (flowDescriptor == null) {
            return null;
        }
        FlowPresenter.FlowUIResolver flowUIResolver = this.nodeUIregistry.get(flowDescriptor);
        if (flowUIResolver == null && (flowUIResolver = this.pinUIregistry.get(flowDescriptor)) == null && (flowUIResolver = this.edgeUIregistry.get(flowDescriptor)) == null && (flowUIResolver = this.pinBadgeUIregistry.get(flowDescriptor)) == null) {
            return null;
        }
        FlowDescriptor.Behaviour behaviour = flowUIResolver.getBehaviour();
        return (T)(clazz.isInstance(behaviour) ? behaviour : null);
    }

    public void scheduleNodeDescriptorForOrdering(FlowNodeDescriptor flowNodeDescriptor) {
        this.nodesForOrdering.add(flowNodeDescriptor);
    }

    public void resolveOrderInNodeDescriptors() {
        for (FlowNodeDescriptor flowNodeDescriptor : this.nodesForOrdering) {
            Object object;
            Object object2;
            Object object32;
            if (!this.isNode(flowNodeDescriptor)) continue;
            FlowNodeDescriptor.NodeDecorator nodeDecorator = this.getDecorator(flowNodeDescriptor);
            DesignComponent designComponent = nodeDecorator.getComponentWithPinOrderPresenters();
            if (designComponent == null) {
                nodeDecorator.orderPins(flowNodeDescriptor, this, Collections.<String, List<FlowPinDescriptor>>emptyMap());
                continue;
            }
            Collection collection = designComponent.getPresenters(FlowPinOrderPresenter.class);
            if (collection.isEmpty()) {
                nodeDecorator.orderPins(flowNodeDescriptor, this, Collections.<String, List<FlowPinDescriptor>>emptyMap());
                continue;
            }
            HashMap<Object, ArrayList<Object>> hashMap = new HashMap<Object, ArrayList<Object>>();
            for (Object object32 : this.getNodePins(flowNodeDescriptor)) {
                object2 = this.getDecorator((FlowPinDescriptor)object32).getOrderCategory((FlowPinDescriptor)object32);
                object = (ArrayList)hashMap.get(object2);
                if (object == null) {
                    object = new ArrayList();
                    hashMap.put(object2, (ArrayList<Object>)object);
                }
                ((ArrayList)object).add(object32);
            }
            HashMap hashMap2 = new HashMap();
            object32 = collection.iterator();
            while (object32.hasNext()) {
                object2 = (FlowPinOrderPresenter)((Object)object32.next());
                object = ((FlowPinOrderPresenter)((Object)object2)).getCategoryID();
                ArrayList arrayList = (ArrayList)hashMap.get(object);
                if (arrayList == null) continue;
                hashMap2.put(((FlowPinOrderPresenter)((Object)object2)).getCategoryDisplayName(), ((FlowPinOrderPresenter)((Object)object2)).sortCategory(arrayList));
            }
            nodeDecorator.orderPins(flowNodeDescriptor, this, hashMap2);
        }
        this.nodesForOrdering.clear();
    }

    public void layoutScene() {
        this.sceneLayout.invokeLayout();
    }

    private Anchor createAnchorForDescriptor(FlowDescriptor flowDescriptor) {
        Anchor anchor = null;
        if (flowDescriptor != null) {
            FlowPinDescriptor flowPinDescriptor;
            FlowPinDescriptor.PinDecorator pinDecorator;
            if (flowDescriptor instanceof FlowNodeDescriptor) {
                FlowNodeDescriptor flowNodeDescriptor = (FlowNodeDescriptor)flowDescriptor;
                FlowNodeDescriptor.NodeDecorator nodeDecorator = this.getDecorator(flowNodeDescriptor);
                if (nodeDecorator != null) {
                    anchor = nodeDecorator.createAnchor(flowNodeDescriptor, this);
                }
            } else if (flowDescriptor instanceof FlowPinDescriptor && (pinDecorator = this.getDecorator(flowPinDescriptor = (FlowPinDescriptor)flowDescriptor)) != null) {
                anchor = pinDecorator.createAnchor(flowPinDescriptor, this);
            }
        }
        return anchor;
    }

    static {
        Image image = ImageUtilities.loadImage((String)"org/netbeans/modules/vmd/flow/resources/paper_grid.png");
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        PAINT_BACKGROUND = new TexturePaint(bufferedImage, new Rectangle(0, 0, n, n2));
    }

    private static final class CacheNodeDescriptor {
        private long componentid;
        private String descriptorid;

        public CacheNodeDescriptor(FlowNodeDescriptor flowNodeDescriptor) {
            this.componentid = flowNodeDescriptor.getRepresentedComponent().getComponentID();
            this.descriptorid = flowNodeDescriptor.getDescriptorID();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            CacheNodeDescriptor cacheNodeDescriptor = (CacheNodeDescriptor)object;
            return this.componentid == cacheNodeDescriptor.componentid && this.descriptorid.equals(cacheNodeDescriptor.descriptorid);
        }

        public int hashCode() {
            int n = (int)(this.componentid ^ this.componentid >>> 32);
            n = 29 * n + (this.descriptorid != null ? this.descriptorid.hashCode() : 0);
            return n;
        }
    }

    private class FlowMoveProvider
    implements MoveProvider {
        private HashMap<Widget, Point> originals = new HashMap();
        private Point original;

        private FlowMoveProvider() {
        }

        public void movementStarted(Widget widget) {
            Object object = FlowScene.this.findObject(widget);
            if (FlowScene.this.isNode(object)) {
                for (Object e : FlowScene.this.getSelectedObjects()) {
                    Widget widget2;
                    if (!FlowScene.this.isNode(e) || (widget2 = FlowScene.this.findWidget(e)) == null) continue;
                    this.originals.put(widget2, widget2.getPreferredLocation());
                }
            } else {
                this.originals.put(widget, widget.getPreferredLocation());
            }
        }

        public void movementFinished(Widget widget) {
            this.originals.clear();
            this.original = null;
        }

        public Point getOriginalLocation(Widget widget) {
            this.original = widget.getPreferredLocation();
            return this.original;
        }

        public void setNewLocation(Widget widget, Point point) {
            int n = point.x - this.original.x;
            int n2 = point.y - this.original.y;
            for (Map.Entry<Widget, Point> entry : this.originals.entrySet()) {
                Point point2 = entry.getValue();
                entry.getKey().setPreferredLocation(new Point(point2.x + n, point2.y + n2));
            }
        }
    }

    private class FlowEditProvider
    implements EditProvider {
        private FlowEditProvider() {
        }

        public void edit(final Widget widget) {
            FlowDescriptor flowDescriptor = (FlowDescriptor)FlowScene.this.findObject(widget);
            if (flowDescriptor == null) {
                return;
            }
            FlowScene.this.document.getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    FlowDescriptor flowDescriptor = (FlowDescriptor)FlowScene.this.findObject(widget);
                    FlowDescriptor.EditActionBehaviour editActionBehaviour = (FlowDescriptor.EditActionBehaviour)FlowScene.this.getAbstractBehaviour(flowDescriptor, FlowDescriptor.EditActionBehaviour.class);
                    if (editActionBehaviour != null) {
                        editActionBehaviour.edit(flowDescriptor);
                    }
                }
            });
        }
    }

    private class FlowRenameEditor
    implements TextFieldInplaceEditor {
        private FlowRenameEditor() {
        }

        public boolean isEnabled(final Widget widget) {
            FlowDescriptor flowDescriptor = (FlowDescriptor)FlowScene.this.findObject(widget);
            if (flowDescriptor == null) {
                return false;
            }
            final boolean[] blArray = new boolean[]{false};
            FlowScene.this.document.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    FlowDescriptor flowDescriptor = (FlowDescriptor)FlowScene.this.findObject(widget);
                    FlowDescriptor.RenameActionBehaviour renameActionBehaviour = (FlowDescriptor.RenameActionBehaviour)FlowScene.this.getAbstractBehaviour(flowDescriptor, FlowDescriptor.RenameActionBehaviour.class);
                    if (renameActionBehaviour != null) {
                        blArray[0] = renameActionBehaviour.isEditable(flowDescriptor);
                    }
                }
            });
            return blArray[0];
        }

        public String getText(final Widget widget) {
            FlowDescriptor flowDescriptor = (FlowDescriptor)FlowScene.this.findObject(widget);
            if (flowDescriptor == null) {
                return null;
            }
            final String[] stringArray = new String[]{null};
            FlowScene.this.document.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    FlowDescriptor flowDescriptor = (FlowDescriptor)FlowScene.this.findObject(widget);
                    FlowDescriptor.RenameActionBehaviour renameActionBehaviour = (FlowDescriptor.RenameActionBehaviour)FlowScene.this.getAbstractBehaviour(flowDescriptor, FlowDescriptor.RenameActionBehaviour.class);
                    if (renameActionBehaviour != null) {
                        stringArray[0] = renameActionBehaviour.getText(flowDescriptor);
                    }
                }
            });
            return stringArray[0];
        }

        public void setText(final Widget widget, final String string) {
            FlowDescriptor flowDescriptor = (FlowDescriptor)FlowScene.this.findObject(widget);
            if (flowDescriptor == null) {
                return;
            }
            FlowScene.this.document.getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    FlowDescriptor flowDescriptor = (FlowDescriptor)FlowScene.this.findObject(widget);
                    FlowDescriptor.RenameActionBehaviour renameActionBehaviour = (FlowDescriptor.RenameActionBehaviour)FlowScene.this.getAbstractBehaviour(flowDescriptor, FlowDescriptor.RenameActionBehaviour.class);
                    if (renameActionBehaviour != null) {
                        renameActionBehaviour.setText(flowDescriptor, string);
                    }
                }
            });
        }
    }

    private class FlowSceneKeyAction
    extends WidgetAction.Adapter {
        private FlowSceneKeyAction() {
        }

        public WidgetAction.State keyPressed(Widget widget, WidgetAction.WidgetKeyEvent widgetKeyEvent) {
            final FlowDescriptor.KeyActionBehaviour[] keyActionBehaviourArray = new FlowDescriptor.KeyActionBehaviour[1];
            FlowScene.this.document.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    FlowDescriptor.Behaviour behaviour;
                    FlowScenePresenter flowScenePresenter;
                    DesignComponent designComponent = FlowScene.this.document.getRootComponent();
                    if (designComponent != null && (flowScenePresenter = (FlowScenePresenter)designComponent.getPresenter(FlowScenePresenter.class)) != null && (behaviour = flowScenePresenter.getBehavior()) instanceof FlowDescriptor.KeyActionBehaviour) {
                        keyActionBehaviourArray[0] = (FlowDescriptor.KeyActionBehaviour)behaviour;
                    }
                }
            });
            return keyActionBehaviourArray[0] != null && keyActionBehaviourArray[0].keyPressed(widgetKeyEvent) ? WidgetAction.State.CONSUMED : WidgetAction.State.REJECTED;
        }
    }

    private class FlowPopupMenuProvider
    implements PopupMenuProvider {
        private FlowPopupMenuProvider() {
        }

        public JPopupMenu getPopupMenu(Widget widget, Point point) {
            JComponent jComponent = FlowScene.this.getView();
            if (widget == FlowScene.this) {
                final DesignComponent[] designComponentArray = new DesignComponent[1];
                FlowScene.this.document.getTransactionManager().readAccess(new Runnable(){

                    @Override
                    public void run() {
                        designComponentArray[0] = FlowScene.this.document.getRootComponent();
                    }
                });
                if (!FlowScene.this.getSelectedObjects().isEmpty()) {
                    FlowScene.this.userSelectionSuggested(Collections.emptySet(), false);
                }
                return Utilities.actionsToPopup((Action[])ActionsSupport.createActionsArray((DesignComponent)designComponentArray[0]), (Component)jComponent);
            }
            FlowDescriptor flowDescriptor = (FlowDescriptor)FlowScene.this.findObject(widget);
            if (flowDescriptor == null) {
                return null;
            }
            FlowScene.this.setFocusedObject(flowDescriptor);
            if (!FlowScene.this.getSelectedObjects().contains(flowDescriptor)) {
                FlowScene.this.userSelectionSuggested(Collections.singleton(flowDescriptor), false);
            }
            return Utilities.actionsToPopup((Action[])ActionsSupport.createActionsArray((DesignComponent)flowDescriptor.getRepresentedComponent()), (Component)jComponent);
        }
    }

    private class FlowReconnectDecoratorProvider
    implements ReconnectDecorator,
    ReconnectProvider {
        private FlowDescriptor replacement = null;

        private FlowReconnectDecoratorProvider() {
        }

        public Anchor createReplacementWidgetAnchor(Widget widget) {
            return FlowScene.this.createAnchorForDescriptor(this.replacement);
        }

        public Anchor createFloatAnchor(Point point) {
            return ActionFactory.createDefaultReconnectDecorator().createFloatAnchor(point);
        }

        public boolean isSourceReconnectable(final ConnectionWidget connectionWidget) {
            final boolean[] blArray = new boolean[]{false};
            FlowScene.this.document.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    Object object = FlowScene.this.findObject((Widget)connectionWidget);
                    if (!FlowScene.this.isEdge(object)) {
                        return;
                    }
                    FlowEdgeDescriptor flowEdgeDescriptor = (FlowEdgeDescriptor)object;
                    blArray[0] = FlowScene.this.getBehaviour(flowEdgeDescriptor).isSourceReconnectable(flowEdgeDescriptor);
                }
            });
            return blArray[0];
        }

        public boolean isTargetReconnectable(final ConnectionWidget connectionWidget) {
            final boolean[] blArray = new boolean[]{false};
            FlowScene.this.document.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    Object object = FlowScene.this.findObject((Widget)connectionWidget);
                    if (!FlowScene.this.isEdge(object)) {
                        return;
                    }
                    FlowEdgeDescriptor flowEdgeDescriptor = (FlowEdgeDescriptor)object;
                    blArray[0] = FlowScene.this.getBehaviour(flowEdgeDescriptor).isTargetReconnectable(flowEdgeDescriptor);
                }
            });
            return blArray[0];
        }

        public void reconnectingStarted(ConnectionWidget connectionWidget, boolean bl) {
        }

        public void reconnectingFinished(ConnectionWidget connectionWidget, boolean bl) {
        }

        public ConnectorState isReplacementWidget(final ConnectionWidget connectionWidget, final Widget widget, final boolean bl) {
            final ConnectorState[] connectorStateArray = new ConnectorState[1];
            FlowScene.this.document.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    Object object = FlowScene.this.findObject((Widget)connectionWidget);
                    if (!FlowScene.this.isEdge(object)) {
                        return;
                    }
                    FlowEdgeDescriptor flowEdgeDescriptor = (FlowEdgeDescriptor)object;
                    FlowReconnectDecoratorProvider.this.replacement = (FlowDescriptor)FlowScene.this.findObject(widget);
                    connectorStateArray[0] = FlowScene.this.getBehaviour(flowEdgeDescriptor).isReplacement(flowEdgeDescriptor, FlowReconnectDecoratorProvider.this.replacement, bl) ? ConnectorState.ACCEPT : ConnectorState.REJECT;
                }
            });
            return connectorStateArray[0];
        }

        public boolean hasCustomReplacementWidgetResolver(Scene scene) {
            return false;
        }

        public Widget resolveReplacementWidget(Scene scene, Point point) {
            return null;
        }

        public void reconnect(final ConnectionWidget connectionWidget, final Widget widget, final boolean bl) {
            FlowScene.this.document.getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    Object object = FlowScene.this.findObject((Widget)connectionWidget);
                    if (!FlowScene.this.isEdge(object)) {
                        return;
                    }
                    FlowEdgeDescriptor flowEdgeDescriptor = (FlowEdgeDescriptor)object;
                    FlowReconnectDecoratorProvider.this.replacement = (FlowDescriptor)FlowScene.this.findObject(widget);
                    FlowEdgeDescriptor.EdgeBehaviour edgeBehaviour = FlowScene.this.getBehaviour(flowEdgeDescriptor);
                    if (edgeBehaviour.isReplacement(flowEdgeDescriptor, FlowReconnectDecoratorProvider.this.replacement, bl)) {
                        edgeBehaviour.setReplacement(flowEdgeDescriptor, FlowReconnectDecoratorProvider.this.replacement, bl);
                    }
                }
            });
        }
    }

    private class FlowConnectDecoratorProvider
    implements ConnectDecorator,
    ConnectProvider {
        private FlowPinDescriptor source = null;
        private FlowDescriptor target = null;

        private FlowConnectDecoratorProvider() {
        }

        public ConnectionWidget createConnectionWidget(Scene scene) {
            return ActionFactory.createDefaultConnectDecorator().createConnectionWidget(scene);
        }

        public Anchor createSourceAnchor(Widget widget) {
            return FlowScene.this.createAnchorForDescriptor(this.source);
        }

        public Anchor createTargetAnchor(Widget widget) {
            return FlowScene.this.createAnchorForDescriptor(this.target);
        }

        public Anchor createFloatAnchor(Point point) {
            return ActionFactory.createDefaultConnectDecorator().createFloatAnchor(point);
        }

        public boolean isSourceWidget(final Widget widget) {
            final boolean[] blArray = new boolean[]{false};
            FlowScene.this.document.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    Object object = FlowScene.this.findObject(widget);
                    if (FlowScene.this.isPin(object)) {
                        FlowConnectDecoratorProvider.this.source = (FlowPinDescriptor)object;
                        blArray[0] = FlowScene.this.getBehaviour(FlowConnectDecoratorProvider.this.source).isConnectionSource(FlowConnectDecoratorProvider.this.source);
                    } else {
                        blArray[0] = false;
                    }
                }
            });
            return blArray[0];
        }

        public ConnectorState isTargetWidget(Widget widget, final Widget widget2) {
            final ConnectorState[] connectorStateArray = new ConnectorState[]{ConnectorState.REJECT};
            FlowScene.this.document.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    FlowConnectDecoratorProvider.this.target = (FlowDescriptor)FlowScene.this.findObject(widget2);
                    connectorStateArray[0] = FlowScene.this.getBehaviour(FlowConnectDecoratorProvider.this.source).isConnectionTarget(FlowConnectDecoratorProvider.this.source, FlowConnectDecoratorProvider.this.target) ? ConnectorState.ACCEPT : ConnectorState.REJECT;
                }
            });
            return connectorStateArray[0];
        }

        public boolean hasCustomTargetWidgetResolver(Scene scene) {
            return false;
        }

        public Widget resolveTargetWidget(Scene scene, Point point) {
            return null;
        }

        public void createConnection(Widget widget, Widget widget2) {
            FlowScene.this.document.getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    FlowPinDescriptor.PinBehaviour pinBehaviour = FlowScene.this.getBehaviour(FlowConnectDecoratorProvider.this.source);
                    if (pinBehaviour.isConnectionTarget(FlowConnectDecoratorProvider.this.source, FlowConnectDecoratorProvider.this.target)) {
                        pinBehaviour.createConnection(FlowConnectDecoratorProvider.this.source, FlowConnectDecoratorProvider.this.target);
                    }
                }
            });
        }
    }

    private class FlowSceneSelectAction
    extends WidgetAction.Adapter {
        private FlowSceneSelectAction() {
        }

        public WidgetAction.State mousePressed(final Widget widget, final WidgetAction.WidgetMouseEvent widgetMouseEvent) {
            final boolean[] blArray = new boolean[]{false};
            long l = FlowScene.this.document.getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    if (widget == FlowScene.this) {
                        DesignComponent designComponent = FlowScene.this.document.getRootComponent();
                        if (designComponent == null) {
                            return;
                        }
                        FlowDescriptor flowDescriptor = new FlowDescriptor(designComponent, "select"){};
                        Collection collection = designComponent.getPresenters(FlowScenePresenter.class);
                        for (FlowScenePresenter flowScenePresenter : collection) {
                            FlowDescriptor.SelectActionBehaviour selectActionBehaviour;
                            FlowDescriptor.Behaviour behaviour = flowScenePresenter.getBehavior();
                            if (!(behaviour instanceof FlowDescriptor.SelectActionBehaviour) || !(selectActionBehaviour = (FlowDescriptor.SelectActionBehaviour)behaviour).select(flowDescriptor, widgetMouseEvent.getModifiers())) continue;
                            blArray[0] = true;
                            return;
                        }
                    }
                }
            });
            FlowScene.this.preferredNodeLocationMap.put(l, widget.convertLocalToScene(widgetMouseEvent.getPoint()));
            return blArray[0] ? WidgetAction.State.CONSUMED : WidgetAction.State.REJECTED;
        }
    }

    private class FlowAcceptProvider
    implements AcceptProvider {
        private FlowAcceptProvider() {
        }

        public ConnectorState isAcceptable(final Widget widget, Point point, final Transferable transferable) {
            if (widget == null) {
                return ConnectorState.REJECT_AND_STOP;
            }
            final ConnectorState[] connectorStateArray = new ConnectorState[]{ConnectorState.REJECT};
            FlowScene.this.document.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    if (widget == FlowScene.this) {
                        DesignComponent designComponent = FlowScene.this.document.getRootComponent();
                        FlowDescriptor flowDescriptor = new FlowDescriptor(designComponent, "accept"){};
                        Collection collection = designComponent.getPresenters(FlowScenePresenter.class);
                        for (FlowScenePresenter flowScenePresenter : collection) {
                            FlowDescriptor.AcceptActionBehaviour acceptActionBehaviour;
                            FlowDescriptor.Behaviour behaviour = flowScenePresenter.getBehavior();
                            if (!(behaviour instanceof FlowDescriptor.AcceptActionBehaviour) || !(acceptActionBehaviour = (FlowDescriptor.AcceptActionBehaviour)behaviour).isAcceptable(flowDescriptor, transferable)) continue;
                            connectorStateArray[0] = ConnectorState.ACCEPT;
                            break;
                        }
                    } else {
                        FlowDescriptor flowDescriptor = (FlowDescriptor)FlowScene.this.findObject(widget);
                        FlowDescriptor.AcceptActionBehaviour acceptActionBehaviour = (FlowDescriptor.AcceptActionBehaviour)FlowScene.this.getAbstractBehaviour(flowDescriptor, FlowDescriptor.AcceptActionBehaviour.class);
                        if (acceptActionBehaviour != null && acceptActionBehaviour.isAcceptable(flowDescriptor, transferable)) {
                            connectorStateArray[0] = ConnectorState.ACCEPT;
                        }
                    }
                }
            });
            return connectorStateArray[0];
        }

        public void accept(final Widget widget, Point point, final Transferable transferable) {
            if (widget == null) {
                return;
            }
            long l = FlowScene.this.document.getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    if (widget == FlowScene.this) {
                        DesignComponent designComponent = FlowScene.this.document.getRootComponent();
                        FlowDescriptor flowDescriptor = new FlowDescriptor(designComponent, "accept"){};
                        Collection collection = designComponent.getPresenters(FlowScenePresenter.class);
                        for (FlowScenePresenter flowScenePresenter : collection) {
                            FlowDescriptor.AcceptActionBehaviour acceptActionBehaviour;
                            FlowDescriptor.Behaviour behaviour = flowScenePresenter.getBehavior();
                            if (!(behaviour instanceof FlowDescriptor.AcceptActionBehaviour) || !(acceptActionBehaviour = (FlowDescriptor.AcceptActionBehaviour)behaviour).isAcceptable(flowDescriptor, transferable)) continue;
                            acceptActionBehaviour.accept(flowDescriptor, transferable);
                        }
                    } else {
                        FlowDescriptor flowDescriptor = (FlowDescriptor)FlowScene.this.findObject(widget);
                        FlowDescriptor.AcceptActionBehaviour acceptActionBehaviour = (FlowDescriptor.AcceptActionBehaviour)FlowScene.this.getAbstractBehaviour(flowDescriptor, FlowDescriptor.AcceptActionBehaviour.class);
                        if (acceptActionBehaviour != null) {
                            acceptActionBehaviour.accept(flowDescriptor, transferable);
                        }
                    }
                }
            });
            FlowScene.this.preferredNodeLocationMap.put(l, widget.convertLocalToScene(point));
            PaletteSupport.getPaletteController((DesignDocument)FlowScene.this.document).clearSelection();
        }
    }

    private class FlowObjectSceneListener
    implements ObjectSceneListener {
        private FlowObjectSceneListener() {
        }

        public void objectAdded(ObjectSceneEvent objectSceneEvent, Object object) {
        }

        public void objectRemoved(ObjectSceneEvent objectSceneEvent, Object object) {
        }

        public void objectStateChanged(ObjectSceneEvent objectSceneEvent, Object object, ObjectState objectState, ObjectState objectState2) {
        }

        public void selectionChanged(ObjectSceneEvent objectSceneEvent, Set<Object> set, Set<Object> set2) {
            HashSet hashSet = new HashSet();
            for (Object object : set2) {
                if (FlowScene.this.isNode(object)) {
                    for (FlowPinDescriptor flowPinDescriptor : FlowScene.this.getNodePins((FlowNodeDescriptor)object)) {
                        hashSet.addAll(FlowScene.this.findPinEdges(flowPinDescriptor, true, true));
                    }
                    continue;
                }
                if (!FlowScene.this.isPin(object)) continue;
                hashSet.addAll(FlowScene.this.findPinEdges((FlowPinDescriptor)object, true, true));
            }
            FlowScene.this.setHighlightedObjects(hashSet);
        }

        public void highlightingChanged(ObjectSceneEvent objectSceneEvent, Set<Object> set, Set<Object> set2) {
        }

        public void hoverChanged(ObjectSceneEvent objectSceneEvent, Object object, Object object2) {
        }

        public void focusChanged(ObjectSceneEvent objectSceneEvent, Object object, Object object2) {
        }
    }
}

