/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.svg;

import org.netbeans.microedition.svg.SVGComponent;
import org.netbeans.microedition.svg.SVGForm;
import org.netbeans.microedition.svg.SVGLabel;
import org.netbeans.microedition.svg.SVGList;
import org.netbeans.microedition.svg.SVGListCellRenderer;
import org.netbeans.microedition.svg.TextRenderer;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGLocatableElement;

public class SVGDefaultListCellRenderer
extends TextRenderer
implements SVGListCellRenderer {
    private static final String HEIGHT = "height";
    private static final String WIDTH = "width";
    private static final String STROKE = "stroke";
    private static final String STROKE_WIDTH = "stroke-width";
    private static final String FILL = "fill";
    private static final float ASCENT_SELECTION = 2.0f;
    private static final float DESCENT_SELECTION = 2.0f;
    private float myX;
    private float myY;
    private float myHeight;
    private float myTextWidth = -1.0f;

    SVGDefaultListCellRenderer(float height, SVGForm form, SVGLocatableElement hiddenText) {
        super(form, hiddenText);
        this.myHeight = height;
        this.initEmpiricalLetterWidth(hiddenText);
    }

    public SVGComponent getCellRendererComponent(SVGList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        SVGLocatableElement content = list.getContent();
        SVGLocatableElement hiddenText = list.getHiddenText();
        if (hiddenText == null) {
            throw new IllegalArgumentException("List argument doesn't contain hidden text for access to fontcharacteristics. Unable render any value.");
        }
        this.myX = hiddenText.getFloatTrait("x");
        this.myY = hiddenText.getFloatTrait("y");
        if (list.getBoundsElement().getBBox() != null && hiddenText.getBBox() != null && this.myTextWidth == -1.0f) {
            this.myTextWidth = list.getBoundsElement().getBBox().getWidth() + 0.5f - (hiddenText.getBBox().getX() - list.getBoundsElement().getBBox().getX()) * 2.0f;
        }
        if (isSelected) {
            this.showSelection(list, index, cellHasFocus);
        }
        SVGLocatableElement textElement = (SVGLocatableElement)list.getForm().getDocument().createElementNS("http://www.w3.org/2000/svg", "text");
        textElement.setFloatTrait("x", this.myX);
        textElement.setFloatTrait("y", this.myY + (float)index * this.myHeight);
        textElement.setFloatTrait("font-size", hiddenText.getFloatTrait("font-size"));
        textElement.setTrait("font-family", hiddenText.getTrait("font-family"));
        textElement.setTrait("visibility", "inherit");
        if (value == null) {
            textElement.setTrait("#text", "");
        } else if (this.myTextWidth == -1.0f) {
            textElement.setTrait("#text", value.toString());
        } else {
            String text = this.truncateToShownText(value.toString(), this.myTextWidth);
            textElement.setTrait("#text", text);
        }
        content.appendChild((Node)textElement);
        return new SVGLabel(list.getForm(), textElement);
    }

    private void showSelection(SVGList list, int index, boolean focused) {
        SVGLocatableElement selection = list.getSelection();
        if (selection == null) {
            throw new IllegalArgumentException("List argument doesn't contain nested 'selection' element. Unable render any value.");
        }
        selection = this.createSelection(list, selection, index, focused);
        list.getCurrentSelection().appendChild((Node)selection);
    }

    private SVGLocatableElement createSelection(SVGList list, SVGLocatableElement selection, int index, boolean focused) {
        SVGLocatableElement result = (SVGLocatableElement)list.getForm().getDocument().createElementNS("http://www.w3.org/2000/svg", "rect");
        result.setFloatTrait("x", selection.getFloatTrait("x"));
        result.setFloatTrait(WIDTH, selection.getFloatTrait(WIDTH));
        result.setRGBColorTrait(FILL, selection.getRGBColorTrait(FILL));
        result.setTrait("visibility", "inherit");
        result.setFloatTrait("y", this.myY + (float)(index - 1) * this.myHeight + 2.0f);
        result.setFloatTrait(HEIGHT, this.myHeight + 2.0f);
        if (focused) {
            result.setRGBColorTrait(STROKE, selection.getRGBColorTrait(STROKE));
            result.setFloatTrait(STROKE_WIDTH, selection.getFloatTrait(STROKE_WIDTH));
        }
        if (!list.isSlave()) {
            result.setTrait("visibility", "visible");
        }
        return result;
    }
}

