/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.javascript.plugins;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.text.Document;
import org.mozilla.nb.javascript.Node;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.api.UiUtils;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.support.ModificationResult;
import org.netbeans.modules.javascript.editing.AstElement;
import org.netbeans.modules.javascript.editing.AstPath;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.Element;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.ParseTreeVisitor;
import org.netbeans.modules.javascript.editing.ParseTreeWalker;
import org.netbeans.modules.javascript.editing.VariableVisitor;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.javascript.JsElementCtx;
import org.netbeans.modules.refactoring.javascript.RetoucheUtils;
import org.netbeans.modules.refactoring.javascript.WhereUsedElement;
import org.netbeans.modules.refactoring.javascript.api.WhereUsedQueryConstants;
import org.netbeans.modules.refactoring.javascript.plugins.JsRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class JsWhereUsedQueryPlugin
extends JsRefactoringPlugin {
    private WhereUsedQuery refactoring;
    private JsElementCtx searchHandle;
    private String targetName;

    public JsWhereUsedQueryPlugin(WhereUsedQuery whereUsedQuery) {
        this.refactoring = whereUsedQuery;
        this.searchHandle = (JsElementCtx)whereUsedQuery.getRefactoringSource().lookup(JsElementCtx.class);
        this.targetName = this.searchHandle.getSimpleName();
    }

    public Problem preCheck() {
        if (!this.searchHandle.getFileObject().isValid()) {
            return new Problem(true, NbBundle.getMessage(JsWhereUsedQueryPlugin.class, (String)"DSC_ElNotAvail"));
        }
        return null;
    }

    private Set<FileObject> getRelevantFiles(JsElementCtx jsElementCtx) {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        FileObject fileObject = jsElementCtx.getFileObject();
        if (fileObject != null) {
            hashSet.add(fileObject);
            boolean bl = false;
            if (jsElementCtx.getKind() == ElementKind.PARAMETER) {
                bl = true;
            } else if (jsElementCtx.getKind() == ElementKind.VARIABLE) {
                for (Node node = jsElementCtx.getNode(); node != null; node = node.getParentNode()) {
                    if (node.getType() != 108) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                hashSet.addAll(RetoucheUtils.getJsFilesInProject(fileObject));
            }
        }
        return hashSet;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        Set<FileObject> set = this.getRelevantFiles(this.searchHandle);
        this.fireProgressListenerStart(1, set.size());
        this.processFiles(set, new FindTask(refactoringElementsBag));
        this.fireProgressListenerStop();
        return null;
    }

    public Problem fastCheckParameters() {
        if (this.targetName == null) {
            return new Problem(true, "Cannot determine target name. Please file a bug with detailed information on how to reproduce (preferably including the current source file and the cursor position)");
        }
        if (this.searchHandle.getKind() == ElementKind.METHOD) {
            return this.checkParametersForMethod(this.isFindOverridingMethods(), this.isFindUsages());
        }
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    private Problem checkParametersForMethod(boolean bl, boolean bl2) {
        if (!bl2 && !bl) {
            return new Problem(true, NbBundle.getMessage(JsWhereUsedQueryPlugin.class, (String)"MSG_NothingToFind"));
        }
        return null;
    }

    private boolean isFindSubclasses() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_SUBCLASSES);
    }

    private boolean isFindUsages() {
        return this.refactoring.getBooleanValue((Object)"FIND_REFERENCES");
    }

    private boolean isFindDirectSubclassesOnly() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_DIRECT_SUBCLASSES);
    }

    private boolean isFindOverridingMethods() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_OVERRIDING_METHODS);
    }

    private boolean isSearchFromBaseClass() {
        return false;
    }

    private boolean isSearchInComments() {
        return this.refactoring.getBooleanValue((Object)"SEARCH_IN_COMMENTS");
    }

    private class FindTask
    extends JsRefactoringPlugin.TransformTask {
        private RefactoringElementsBag elements;

        public FindTask(RefactoringElementsBag refactoringElementsBag) {
            this.elements = refactoringElementsBag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Collection<ModificationResult> process(JsParseResult jsParseResult) {
            ImageIcon imageIcon;
            Object object;
            List list;
            Object object2;
            String string;
            if (JsWhereUsedQueryPlugin.this.isCancelled()) {
                return null;
            }
            Object object3 = null;
            JsElementCtx jsElementCtx = JsWhereUsedQueryPlugin.this.searchHandle;
            Node node = jsParseResult.getRootNode();
            if (node == null && (string = ((Object)jsParseResult.getSnapshot().getText()).toString()) != null && string.indexOf(JsWhereUsedQueryPlugin.this.targetName) != -1) {
                int n = 0;
                int n2 = 0;
                object2 = "Parse error in file which contains " + JsWhereUsedQueryPlugin.this.targetName + " reference - skipping it";
                list = jsParseResult.getDiagnostics();
                if (list.size() > 0) {
                    object = list.iterator();
                    while (object.hasNext()) {
                        imageIcon = (Error)object.next();
                        if (imageIcon.getSeverity() != Severity.ERROR) continue;
                        object3 = imageIcon;
                        break;
                    }
                    if (object3 == null) {
                        object3 = (Error)list.get(0);
                    }
                    if (((String)(object = object3.getDisplayName())).length() > 80) {
                        object = ((String)object).substring(0, 77) + "...";
                    }
                    object2 = (String)object2 + "; " + (String)object;
                    n = object3.getStartPosition();
                    if ((n = LexUtilities.getLexerOffset((JsParseResult)jsParseResult, (int)n)) == -1) {
                        n = 0;
                    }
                    n2 = n;
                }
                object = Collections.emptySet();
                imageIcon = UiUtils.getElementIcon((ElementKind)ElementKind.ERROR, (Collection)object);
                OffsetRange offsetRange = new OffsetRange(n, n2);
                WhereUsedElement whereUsedElement = WhereUsedElement.create(jsParseResult, JsWhereUsedQueryPlugin.this.targetName, (String)object2, offsetRange, imageIcon);
                this.elements.add((AbstractRefactoring)JsWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)whereUsedElement);
            }
            if (object3 == null && JsWhereUsedQueryPlugin.this.isSearchInComments() && (string = RetoucheUtils.getDocument((Parser.Result)jsParseResult)) != null) {
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)((Object)string));
                TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                tokenSequence.move(0);
                this.searchTokenSequence(jsParseResult, tokenSequence);
            }
            if (node == null) {
                return Collections.emptySet();
            }
            string = GsfUtilities.getDocument((FileObject)jsParseResult.getSnapshot().getSource().getFileObject(), (boolean)true);
            AstElement astElement = null;
            try {
                if (string != null) {
                    string.readLock();
                }
                astElement = AstElement.getElement((JsParseResult)jsParseResult, (Node)node);
            }
            finally {
                if (string != null) {
                    string.readUnlock();
                }
            }
            Node node2 = jsElementCtx.getNode();
            object2 = new JsElementCtx(node, node2, (Element)astElement, jsParseResult.getSnapshot().getSource().getFileObject(), jsParseResult);
            if (JsWhereUsedQueryPlugin.this.isFindUsages()) {
                list = null;
                if (node2.getType() == 39 || node2.getType() == 49 || node2.getType() == 163) {
                    object = node2;
                    while (object.getParentNode() != null) {
                        object = object.getParentNode();
                    }
                    imageIcon = new VariableVisitor();
                    new ParseTreeWalker((ParseTreeVisitor)imageIcon).walk((Node)object);
                    list = imageIcon.getDefiningScope(node2);
                }
                if (list != null && list.getType() == 108) {
                    this.findLocal(jsElementCtx, (JsElementCtx)object2, (Node)list, JsWhereUsedQueryPlugin.this.targetName);
                } else {
                    object = new AstPath();
                    object.descend(node);
                    this.find((AstPath)object, jsElementCtx, (JsElementCtx)object2, node, JsWhereUsedQueryPlugin.this.targetName);
                    object.ascend();
                }
            } else if (JsWhereUsedQueryPlugin.this.isFindOverridingMethods() || JsWhereUsedQueryPlugin.this.isSearchFromBaseClass()) {
                // empty if block
            }
            return Collections.emptySet();
        }

        private void searchTokenSequence(JsParseResult jsParseResult, TokenSequence<?> tokenSequence) {
            if (tokenSequence.moveNext()) {
                do {
                    CharSequence charSequence;
                    Token token;
                    TokenId tokenId;
                    String string;
                    if ("comment".equals(string = (tokenId = (token = tokenSequence.token()).id()).primaryCategory()) || "block-comment".equals(string)) {
                        int n;
                        assert (JsWhereUsedQueryPlugin.this.targetName != null);
                        charSequence = token.text();
                        if (charSequence == null || JsWhereUsedQueryPlugin.this.targetName == null || (n = TokenUtilities.indexOf((CharSequence)charSequence, (CharSequence)JsWhereUsedQueryPlugin.this.targetName)) == -1) continue;
                        String string2 = ((Object)charSequence).toString();
                        if (n != 0 && Character.isLetterOrDigit(string2.charAt(n - 1)) || n + JsWhereUsedQueryPlugin.this.targetName.length() < string2.length() && Character.isLetterOrDigit(string2.charAt(n + JsWhereUsedQueryPlugin.this.targetName.length()))) continue;
                        int n2 = tokenSequence.offset() + n;
                        int n3 = n2 + JsWhereUsedQueryPlugin.this.targetName.length();
                        Set set = Collections.emptySet();
                        if (JsWhereUsedQueryPlugin.this.searchHandle.getElement() != null) {
                            set = JsWhereUsedQueryPlugin.this.searchHandle.getElement().getModifiers();
                        }
                        ImageIcon imageIcon = UiUtils.getElementIcon((ElementKind)JsWhereUsedQueryPlugin.this.searchHandle.getKind(), (Collection)set);
                        OffsetRange offsetRange = new OffsetRange(n2, n3);
                        WhereUsedElement whereUsedElement = WhereUsedElement.create(jsParseResult, JsWhereUsedQueryPlugin.this.targetName, offsetRange, imageIcon);
                        this.elements.add((AbstractRefactoring)JsWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)whereUsedElement);
                        continue;
                    }
                    charSequence = tokenSequence.embedded();
                    if (charSequence == null) continue;
                    this.searchTokenSequence(jsParseResult, (TokenSequence<?>)charSequence);
                } while (tokenSequence.moveNext());
            }
        }

        private void find(AstPath astPath, JsElementCtx jsElementCtx, JsElementCtx jsElementCtx2, Node node, String string) {
            switch (node.getType()) {
                case 165: {
                    if (node.getString().equals(string) && AstUtilities.isLabelledFunction((Node)node)) {
                        JsElementCtx jsElementCtx3 = new JsElementCtx(jsElementCtx2, node);
                        this.elements.add((AbstractRefactoring)JsWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)WhereUsedElement.create(jsElementCtx3));
                    }
                    return;
                }
                case 164: {
                    boolean bl;
                    if (!node.getString().equals(string) || (bl = false)) break;
                    JsElementCtx jsElementCtx4 = new JsElementCtx(jsElementCtx2, node);
                    this.elements.add((AbstractRefactoring)JsWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)WhereUsedElement.create(jsElementCtx4));
                    break;
                }
                case 30: 
                case 38: {
                    String string2 = AstUtilities.getCallName((Node)node, (boolean)false);
                    if (!string2.equals(string)) break;
                    JsElementCtx jsElementCtx4 = new JsElementCtx(jsElementCtx2, node);
                    this.elements.add((AbstractRefactoring)JsWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)WhereUsedElement.create(jsElementCtx4));
                    break;
                }
                case 39: {
                    if (node.getParentNode().getType() == 38 || node.getParentNode().getType() == 30) break;
                }
                case 41: {
                    int n = node.getParentNode().getType();
                    if (n != 33 && n != 35) break;
                }
                case 49: {
                    if (!node.getString().equals(string)) break;
                    JsElementCtx jsElementCtx5 = new JsElementCtx(jsElementCtx2, node);
                    this.elements.add((AbstractRefactoring)JsWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)WhereUsedElement.create(jsElementCtx5));
                }
            }
            if (node.hasChildren()) {
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                    this.find(astPath, jsElementCtx, jsElementCtx2, node2, string);
                }
            }
        }

        private void findLocal(JsElementCtx jsElementCtx, JsElementCtx jsElementCtx2, Node node, String string) {
            Object object;
            switch (node.getType()) {
                case 39: {
                    if ((node.getParentNode().getType() == 38 || node.getParentNode().getType() == 30) && node.getParentNode().getFirstChild() == node) break;
                }
                case 49: 
                case 163: {
                    if (!node.getString().equals(string)) break;
                    object = new JsElementCtx(jsElementCtx2, node);
                    this.elements.add((AbstractRefactoring)JsWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)WhereUsedElement.create((JsElementCtx)object));
                }
            }
            if (node.hasChildren()) {
                for (object = node.getFirstChild(); object != null; object = object.getNext()) {
                    this.findLocal(jsElementCtx, jsElementCtx2, (Node)object, string);
                }
            }
        }
    }
}

