/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.wizard.imports;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.modules.mobility.project.J2MEProjectGenerator;
import org.netbeans.modules.mobility.project.ui.wizard.Utils;
import org.netbeans.modules.mobility.project.ui.wizard.imports.SourcesPanel;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class WtkPanel
extends JPanel {
    private static final Dimension PREF_DIM = new Dimension(500, 340);
    public static final String WTK_LOCATION = "WtkLocation";
    public static final String APP_LOCATION = "AppLocation";
    private static String DEFAULT_WTK_LOCATION = null;
    private DefaultListModel listModel;
    private JButton bBrowse;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JList lApps;
    private JTextField tLocation;

    public WtkPanel() {
        this.initComponents();
        this.initAccessibility();
        this.listModel = new DefaultListModel();
        this.lApps.setModel(this.listModel);
        this.lApps.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                ListItem item = (ListItem)value;
                JLabel label = new JLabel("<html><b>" + item.toString() + "</b><br>" + item.getPath());
                label.setOpaque(true);
                label.setBackground(UIManager.getDefaults().getColor(isSelected ? "List.selectionBackground" : "List.background"));
                if (cellHasFocus) {
                    JPanel panel = new JPanel();
                    panel.setBackground(UIManager.getDefaults().getColor(isSelected ? "List.selectionBackground" : "List.background"));
                    panel.setLayout(new GridBagLayout());
                    panel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 5, 5));
                    panel.setBorder(new LineBorder(UIManager.getDefaults().getColor("Button.focus"), 1));
                    return panel;
                }
                label.setBorder(new EmptyBorder(6, 6, 6, 6));
                return label;
            }
        });
    }

    public void addListener(DocumentListener documentListener, ListSelectionListener listSelectionListener) {
        this.tLocation.getDocument().addDocumentListener(documentListener);
        this.lApps.addListSelectionListener(listSelectionListener);
    }

    public void removeListener(DocumentListener documentListener, ListSelectionListener listSelectionListener) {
        this.tLocation.getDocument().removeDocumentListener(documentListener);
        this.lApps.removeListSelectionListener(listSelectionListener);
    }

    public static String getWTKInstalationDirs() {
        String[] installDirs;
        String baseDir;
        JavaPlatform[] plat = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2me", null, null));
        for (int i = 0; i < plat.length; ++i) {
            String path;
            String name;
            if (!(plat[i] instanceof J2MEPlatform) || ((name = ((J2MEPlatform)plat[i]).getName().toLowerCase()).indexOf("wireless") < 0 || name.indexOf("toolkit") < 0) && name.indexOf("wtk") < 0 || !new File(path = ((J2MEPlatform)plat[i]).getHomePath(), "apps").isDirectory()) continue;
            return path;
        }
        String[] unixInstallDirs = new String[]{"WTK2.3", "WTK2.2", "WTK2.1", "WTK2.0", "WTK104"};
        String[] winInstallDirs = new String[]{"WTK23", "WTK22", "WTK21", "WTK20", "WTK104"};
        if (Utilities.isUnix()) {
            baseDir = System.getProperty("user.home", "") + System.getProperty("file.separator");
            installDirs = unixInstallDirs;
        } else {
            baseDir = "c:\\";
            installDirs = winInstallDirs;
        }
        for (int i = 0; i < installDirs.length; ++i) {
            String wtkDir = baseDir + installDirs[i];
            if (!new File(wtkDir).isDirectory()) continue;
            return wtkDir;
        }
        return null;
    }

    public void readData(TemplateWizard object) {
        String tmp = (String)object.getProperty(WTK_LOCATION);
        if (tmp == null) {
            tmp = DEFAULT_WTK_LOCATION;
        }
        if (tmp == null) {
            tmp = WtkPanel.getWTKInstalationDirs();
        }
        if (tmp == null) {
            tmp = System.getProperty("user.home", "");
        }
        this.tLocation.setText(tmp);
        tmp = (String)object.getProperty(APP_LOCATION);
        if (tmp != null) {
            for (int a = 0; a < this.listModel.getSize(); ++a) {
                ListItem item = (ListItem)this.listModel.getElementAt(a);
                if (!tmp.equals(item.getPath())) continue;
                this.lApps.setSelectedIndex(a);
                break;
            }
        }
    }

    public void storeData(TemplateWizard object) {
        object.putProperty(WTK_LOCATION, (Object)this.tLocation.getText());
        DEFAULT_WTK_LOCATION = this.tLocation.getText();
        ListItem item = (ListItem)this.lApps.getSelectedValue();
        String app = item != null ? item.getPath() : null;
        object.putProperty(APP_LOCATION, (Object)app);
        String name = null;
        if (item != null) {
            name = item.getName();
        } else if (app != null) {
            name = new File(app).getName();
        }
        object.putProperty("ProjectName", (Object)("Imported Project" + (name != null ? " - " + name + '1' : "1")));
        String detectedConfiguration = null;
        String detectedProfile = null;
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            J2MEProjectGenerator.loadJadAndManifest(map, J2MEProjectGenerator.findWtkJadFile(app), J2MEProjectGenerator.findWtkManifestFile(app));
            detectedConfiguration = (String)map.get("MicroEdition-Configuration");
            detectedProfile = (String)map.get("MicroEdition-Profile");
        }
        catch (IOException e) {
            // empty catch block
        }
        object.putProperty("RequiredConfiguration", detectedConfiguration);
        object.putProperty("RequiredProfile", detectedProfile);
    }

    public String getLocationText() {
        return this.tLocation.getText();
    }

    public void setAppList(ArrayList<ListItem> items) {
        this.listModel.clear();
        for (int a = 0; a < items.size(); ++a) {
            this.listModel.addElement(items.get(a));
        }
        if (items.size() > 0) {
            this.lApps.setSelectedIndex(0);
        }
    }

    public int getAppCount() {
        return this.listModel.size();
    }

    public ListItem getSelectedApp() {
        return (ListItem)this.lApps.getSelectedValue();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.tLocation = new JTextField();
        this.bBrowse = new JButton();
        this.jLabel4 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lApps = new JList();
        this.setName(NbBundle.getMessage(WtkPanel.class, (String)"TITLE_Wtk"));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(WtkPanel.class, (String)"LBL_Wtk_Info"));
        this.jLabel1.setVerticalAlignment(1);
        this.jLabel1.setPreferredSize(new Dimension(400, 72));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setLabelFor(this.tLocation);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(WtkPanel.class, (String)"LBL_Wtk_Location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 5, 6);
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.add((Component)this.tLocation, gridBagConstraints);
        this.tLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WtkPanel.class, (String)"ACSD_WTK_Location"));
        Mnemonics.setLocalizedText((AbstractButton)this.bBrowse, (String)NbBundle.getMessage(WtkPanel.class, (String)"LBL_Wtk_Browse"));
        this.bBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WtkPanel.this.bBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 6, 5, 0);
        this.add((Component)this.bBrowse, gridBagConstraints);
        this.bBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WtkPanel.class, (String)"ACSD_WTK_Browse"));
        this.jLabel4.setLabelFor(this.lApps);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(WtkPanel.class, (String)"LBL_Wtk_DetectedApps"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 6);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.lApps.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.lApps);
        this.lApps.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WtkPanel.class, (String)"ACSD_WTK_Apps"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WtkPanel.class, (String)"ACSN_Wtk"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WtkPanel.class, (String)"ACSD_Wtk"));
    }

    @Override
    public Dimension getPreferredSize() {
        return PREF_DIM;
    }

    private void bBrowseActionPerformed(ActionEvent evt) {
        String folder = Utils.browseFolder(this, this.tLocation.getText(), NbBundle.getMessage(WtkPanel.class, (String)"TITLE_Wtk_Location"));
        if (folder != null) {
            this.tLocation.setText(folder);
        }
    }

    static class WizardPanel
    implements WizardDescriptor.FinishablePanel,
    DocumentListener,
    ListSelectionListener {
        WtkPanel component;
        TemplateWizard wizard;
        Collection<ChangeListener> listeners = new ArrayList<ChangeListener>();
        boolean valid = false;

        WizardPanel() {
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.listeners.add(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.listeners.remove(changeListener);
        }

        public Component getComponent() {
            if (this.component == null) {
                this.component = new WtkPanel();
                this.component.addListener(this, this);
                this.checkValid();
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(WtkPanel.class);
        }

        public boolean isFinishPanel() {
            return false;
        }

        public void showError(String message) {
            if (this.wizard != null) {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)message);
            }
        }

        public boolean isValid() {
            Project other;
            WtkPanel panel = (WtkPanel)this.getComponent();
            File f = new File(panel.getLocationText());
            boolean valid = f.exists();
            if (!valid) {
                this.showError(NbBundle.getMessage(WtkPanel.class, (String)"ERR_Wtk_InvalidLocation"));
                return false;
            }
            int count = panel.getAppCount();
            if (count <= 0) {
                this.showError(NbBundle.getMessage(WtkPanel.class, (String)"ERR_Wtk_NoAppFound"));
                return false;
            }
            ListItem app = panel.getSelectedApp();
            if (app == null) {
                this.showError(NbBundle.getMessage(WtkPanel.class, (String)"ERR_Wtk_NoAppSelected"));
                return false;
            }
            f = new File(app.path + File.separator + "src").getAbsoluteFile();
            f = f.isDirectory() ? FileUtil.normalizeFile((File)f) : null;
            FileObject srcRoot = f == null ? null : FileUtil.toFileObject((File)f);
            Project project = other = srcRoot == null ? null : FileOwnerQuery.getOwner((FileObject)srcRoot);
            if (other != null && Arrays.asList(OpenProjects.getDefault().getOpenProjects()).contains(other)) {
                ProjectInformation pi = (ProjectInformation)other.getLookup().lookup(ProjectInformation.class);
                String name = pi == null ? other.getProjectDirectory().getPath() : pi.getDisplayName();
                this.showError(NbBundle.getMessage(SourcesPanel.class, (String)"WARN_WTK_SourcesClashing", (Object)name));
            } else {
                this.showError(null);
            }
            return true;
        }

        public void readSettings(Object obj) {
            this.wizard = (TemplateWizard)obj;
            ((WtkPanel)this.getComponent()).readData(this.wizard);
            Component component = this.getComponent();
            Object substitute = ((JComponent)component).getClientProperty("NewProjectWizard_Title");
            if (substitute != null) {
                this.wizard.putProperty("NewProjectWizard_Title", substitute);
            }
        }

        public void storeSettings(Object obj) {
            this.wizard = (TemplateWizard)obj;
            ((WtkPanel)this.getComponent()).storeData(this.wizard);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireStateChange() {
            ChangeListener[] ll;
            WizardPanel wizardPanel = this;
            synchronized (wizardPanel) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                ll = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            ChangeEvent ev = new ChangeEvent(this);
            for (int i = 0; i < ll.length; ++i) {
                ll[i].stateChanged(ev);
            }
        }

        void checkValid() {
            if (this.isValid() != this.valid) {
                this.valid ^= true;
                this.fireStateChange();
            }
        }

        public ListItem getWtkProjectDirectory(File project) {
            boolean isValid;
            String desc;
            String name;
            block9: {
                if (!(project.exists() && project.isDirectory() && project.canRead())) {
                    return null;
                }
                name = project.getName();
                desc = null;
                isValid = false;
                File bin = new File(project, "bin");
                File[] files = bin.listFiles();
                File file = Utils.findSubFile(files, project.getName() + ".jad");
                if (file == null) {
                    file = Utils.findAnyFile(files, "jad");
                }
                if (file != null && file.exists() && file.isFile()) {
                    isValid = true;
                    BufferedReader reader = null;
                    try {
                        String line;
                        reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                        while ((line = reader.readLine()) != null) {
                            int i = line.indexOf(58);
                            if (i < 0) continue;
                            String property = line.substring(0, i).trim();
                            if ("MIDlet-Name".equals(property)) {
                                name = line.substring(i + 1).trim();
                            }
                            if (!"MIDlet-Description".equals(property)) continue;
                            desc = line.substring(i + 1).trim();
                        }
                    }
                    catch (IOException e) {
                        if (reader == null) break block9;
                        try {
                            reader.close();
                        }
                        catch (IOException ee) {
                            // empty catch block
                        }
                    }
                }
            }
            return isValid ? new ListItem(name, desc, project.getAbsolutePath()) : null;
        }

        public void updateApps() {
            ListItem item;
            File[] files;
            File apps;
            WtkPanel panel = (WtkPanel)this.getComponent();
            ArrayList<ListItem> list = new ArrayList<ListItem>();
            String location = panel.getLocationText();
            File wtk = new File(location);
            if (wtk.exists() && wtk.isDirectory() && (apps = new File(wtk, "apps")).exists() && apps.isDirectory() && wtk.canRead() && (files = apps.listFiles()) != null) {
                for (int a = 0; a < files.length; ++a) {
                    ListItem item2 = this.getWtkProjectDirectory(files[a]);
                    if (item2 == null) continue;
                    list.add(item2);
                }
            }
            if (list.size() <= 0 && (item = this.getWtkProjectDirectory(wtk)) != null) {
                list.add(item);
            }
            panel.setAppList(list);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateApps();
            this.checkValid();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateApps();
            this.checkValid();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateApps();
            this.checkValid();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.checkValid();
        }
    }

    static class ListItem {
        String name;
        String desc;
        String path;

        public ListItem(String name, String desc, String path) {
            this.name = name;
            this.desc = desc;
            this.path = path;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public String toString() {
            if (this.desc != null) {
                return this.name + " - " + this.desc;
            }
            return this.name;
        }
    }
}

