/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.util.Collections;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateFilter;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.editor.CompletionContextFinder;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class PHPCodeTemplateFilter
extends UserTask
implements CodeTemplateFilter {
    private volatile boolean accept = false;
    private int caretOffset;
    private CompletionContextFinder.CompletionContext context;
    private static final RequestProcessor requestProcessor = new RequestProcessor("PHPCodeTemplateFilter");
    private final RequestProcessor.Task postedTask;

    public PHPCodeTemplateFilter(final JTextComponent component, int offset) {
        this.caretOffset = offset;
        this.postedTask = requestProcessor.post(new Runnable(){

            @Override
            public void run() {
                PHPCodeTemplateFilter.this.parseDocument(component);
            }
        });
    }

    public boolean accept(CodeTemplate template) {
        try {
            if (this.postedTask.waitFinished(300L)) {
                if (this.context == CompletionContextFinder.CompletionContext.CLASS_CONTEXT_KEYWORDS) {
                    return template.getAbbreviation().equals("fnc");
                }
                return this.accept;
            }
            this.postedTask.cancel();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    public void run(ResultIterator resultIterator) throws Exception {
        ParserResult parameter = null;
        String mimeType = resultIterator.getSnapshot().getMimeType();
        if (!mimeType.equals("text/x-php5")) {
            for (Embedding e : resultIterator.getEmbeddings()) {
                if (!e.getMimeType().equals("text/x-php5")) continue;
                resultIterator = resultIterator.getResultIterator(e);
                break;
            }
            mimeType = resultIterator.getSnapshot().getMimeType();
        }
        if (mimeType.equals("text/x-php5") && (parameter = (ParserResult)resultIterator.getParserResult()) != null) {
            this.context = CompletionContextFinder.findCompletionContext(parameter, this.caretOffset);
            switch (this.context) {
                case EXPRESSION: {
                    this.accept = true;
                    break;
                }
                case CLASS_CONTEXT_KEYWORDS: {
                    this.accept = true;
                }
            }
        }
    }

    private void parseDocument(JTextComponent component) {
        try {
            ParserManager.parseWhenScanFinished(Collections.singleton(Source.create((Document)component.getDocument())), (UserTask)this);
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static final class Factory
    implements CodeTemplateFilter.Factory {
        public CodeTemplateFilter createFilter(JTextComponent component, int offset) {
            return new PHPCodeTemplateFilter(component, offset);
        }
    }
}

