/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.mobility.project.ui.customizer.ProjectProperties;
import org.netbeans.modules.j2me.cdc.platform.CDCDevice;
import org.netbeans.modules.j2me.cdc.platform.CDCPlatform;
import org.netbeans.spi.mobility.project.ui.customizer.CustomizerPanel;
import org.netbeans.spi.mobility.project.ui.customizer.VisualPropertyGroup;
import org.netbeans.spi.mobility.project.ui.customizer.support.VisualPropertySupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CDCPlatformCustomizer
extends JPanel
implements CustomizerPanel,
VisualPropertyGroup,
ActionListener {
    private static final String[] PROPERTY_NAMES = new String[]{"platform.active", "platform.active.description", "platform.device", "platform.profile", "platform.bootclasspath", "platform.type", "javac.source", "javac.target", "platform.fat.jar"};
    private Map<String, Object> props;
    private VisualPropertySupport vps;
    private String configuration;
    private String[] platformNames;
    private HashMap<String, CDCPlatform> name2platform;
    private HashMap<String, CDCDevice> name2device;
    private HashMap<String, CDCDevice.CDCProfile> name2profile;
    private boolean useDefault;
    private JButton jButton1;
    private JComboBox jComboBoxDevice;
    private JComboBox jComboBoxProfile;
    private JComboBox jComboBoxTarget;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabelTarget;
    private JPanel jPanel1;

    public CDCPlatformCustomizer() {
        this.initComponents();
        this.initAll();
    }

    public void initValues(ProjectProperties props, String configuration) {
        this.props = props;
        this.vps = VisualPropertySupport.getDefault((Map)props);
        this.configuration = configuration;
    }

    public void initGroupValues(boolean useDefault) {
        this.jComboBoxTarget.removeActionListener(this);
        if (this.platformNames.length > 0) {
            this.useDefault = useDefault;
            this.vps.register(this.jComboBoxTarget, (Object[])this.platformNames, "platform.active", useDefault);
            this.jComboBoxTarget.addActionListener(this);
        } else {
            this.jComboBoxTarget.removeAllItems();
            String errorMessage = NbBundle.getMessage(CDCPlatformCustomizer.class, (String)"ERR_CDCCust_NoPlatform");
            this.jComboBoxTarget.addItem(errorMessage);
            this.jComboBoxTarget.setSelectedItem(errorMessage);
            this.jComboBoxTarget.setEnabled(false);
        }
        this.initDevices((String)this.jComboBoxTarget.getSelectedItem());
        this.enableLabels(!useDefault);
    }

    private synchronized void initAll() {
        this.name2platform = new HashMap();
        this.name2device = new HashMap();
        this.name2profile = new HashMap();
        JavaPlatform[] platforms = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("cdc", null));
        for (int i = 0; i < platforms.length; ++i) {
            if (!(platforms[i] instanceof CDCPlatform)) continue;
            CDCPlatform platform = (CDCPlatform)platforms[i];
            this.name2platform.put(platform.getDisplayName(), platform);
        }
        this.platformNames = this.name2platform.keySet().toArray(new String[this.name2platform.size()]);
        Arrays.sort(this.platformNames);
    }

    private synchronized void initDevices(String platformName) {
        this.jComboBoxDevice.removeActionListener(this);
        CDCPlatform platform = this.name2platform.get(platformName);
        if (platform != null) {
            this.props.put(VisualPropertySupport.translatePropertyName((String)this.configuration, (String)"platform.active.description", (boolean)this.useDefault), platform.getDisplayName());
            this.props.put(VisualPropertySupport.translatePropertyName((String)this.configuration, (String)"platform.fat.jar", (boolean)this.useDefault), platform.isFatJar());
            this.props.put(VisualPropertySupport.translatePropertyName((String)this.configuration, (String)"javac.source", (boolean)this.useDefault), platform.getClassVersion());
            this.props.put(VisualPropertySupport.translatePropertyName((String)this.configuration, (String)"javac.target", (boolean)this.useDefault), platform.getClassVersion());
            this.props.put(VisualPropertySupport.translatePropertyName((String)this.configuration, (String)"platform.type", (boolean)this.useDefault), platform.getType());
            CDCDevice[] devices = platform.getDevices();
            this.name2device = new HashMap();
            for (int i = 0; i < devices.length; ++i) {
                this.name2device.put(devices[i].getName(), devices[i]);
            }
            Object[] devNames = this.name2device.keySet().toArray(new String[this.name2device.size()]);
            Arrays.sort(devNames);
            this.vps.register(this.jComboBoxDevice, devNames, "platform.device", this.useDefault);
            this.initProfiles((String)this.jComboBoxDevice.getSelectedItem());
            this.jComboBoxDevice.addActionListener(this);
        } else {
            this.jComboBoxDevice.removeAllItems();
            this.jComboBoxDevice.setEnabled(false);
            this.enableLabels(false);
        }
    }

    private synchronized void initProfiles(String deviceName) {
        this.jComboBoxProfile.removeActionListener(this);
        CDCDevice device = this.name2device.get(deviceName);
        if (device != null) {
            CDCDevice.CDCProfile[] profiles = device.getProfiles();
            this.name2profile = new HashMap();
            for (int i = 0; i < profiles.length; ++i) {
                this.name2profile.put(profiles[i].getName(), profiles[i]);
            }
            Object[] profNames = this.name2profile.keySet().toArray(new String[this.name2profile.size()]);
            Arrays.sort(profNames);
            this.vps.register(this.jComboBoxProfile, profNames, "platform.profile", this.useDefault);
            this.jComboBoxProfile.addActionListener(this);
        } else {
            this.jComboBoxProfile.removeAllItems();
            this.jComboBoxProfile.setEnabled(false);
        }
        this.saveClassPath();
    }

    private void saveClassPath() {
        CDCDevice.CDCProfile profile = this.name2profile.get(this.jComboBoxProfile.getSelectedItem());
        if (profile != null) {
            this.props.put(VisualPropertySupport.translatePropertyName((String)this.configuration, (String)"platform.bootclasspath", (boolean)this.useDefault), profile.getBootClassPath());
        }
    }

    public String[] getGroupPropertyNames() {
        return PROPERTY_NAMES;
    }

    private void enableLabels(boolean enabled) {
        this.jLabel1.setEnabled(enabled);
        this.jLabel2.setEnabled(enabled);
        this.jLabelTarget.setEnabled(enabled);
        this.jButton1.setEnabled(enabled);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.jComboBoxTarget.equals(e.getSource())) {
            this.initDevices((String)this.jComboBoxTarget.getSelectedItem());
        } else if (this.jComboBoxDevice.equals(e.getSource())) {
            this.initProfiles((String)this.jComboBoxDevice.getSelectedItem());
        } else if (this.jComboBoxProfile.equals(e.getSource())) {
            this.saveClassPath();
        }
    }

    private void initComponents() {
        this.jLabelTarget = new JLabel();
        this.jComboBoxTarget = new JComboBox();
        this.jButton1 = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jComboBoxDevice = new JComboBox();
        this.jComboBoxProfile = new JComboBox();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jLabelTarget.setLabelFor(this.jComboBoxTarget);
        Mnemonics.setLocalizedText((JLabel)this.jLabelTarget, (String)NbBundle.getMessage(CDCPlatformCustomizer.class, (String)"CDCPlatformCustomizer.jLabelTarget.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 12);
        this.add((Component)this.jLabelTarget, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jComboBoxTarget, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(CDCPlatformCustomizer.class, (String)"CDCPlatformCustomizer.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CDCPlatformCustomizer.this.jButton1createNewPlatform(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.add((Component)this.jButton1, gridBagConstraints);
        this.jLabel1.setLabelFor(this.jComboBoxDevice);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CDCPlatformCustomizer.class, (String)"CDCPlatformCustomizer.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 12);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setLabelFor(this.jComboBoxProfile);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(CDCPlatformCustomizer.class, (String)"CDCPlatformCustomizer.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jComboBoxDevice, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jComboBoxProfile, gridBagConstraints);
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(0, 400, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(0, 227, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void jButton1createNewPlatform(ActionEvent evt) {
        PlatformsCustomizer.showCustomizer((JavaPlatform)((JavaPlatform)this.name2platform.get(this.jComboBoxTarget.getSelectedItem())));
        this.initAll();
        this.initGroupValues(this.useDefault);
    }
}

