/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.IoHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class VariableSubstitutor
implements Serializable {
    private static final long serialVersionUID = 3907213762447685687L;
    protected transient Properties variables;
    protected boolean bracesRequired = false;
    protected static final int TYPE_PLAIN = 0;
    protected static final int TYPE_JAVA_PROPERTIES = 1;
    protected static final int TYPE_XML = 2;
    protected static final int TYPE_SHELL = 3;
    protected static final int TYPE_AT = 4;
    public static final String PLAIN = "plain";
    protected static final Map typeNameToConstantMap = new HashMap();

    public VariableSubstitutor(Properties variables) {
        this.variables = variables;
    }

    public boolean areBracesRequired() {
        return this.bracesRequired;
    }

    public void setBracesRequired(boolean braces) {
        this.bracesRequired = braces;
    }

    public String substitute(String str, String type) throws IllegalArgumentException {
        if (str == null) {
            return null;
        }
        StringReader reader = new StringReader(str);
        StringWriter writer = new StringWriter();
        try {
            this.substitute(reader, writer, type);
        }
        catch (IOException e) {
            throw new Error("Unexpected I/O exception when reading/writing memory buffer; nested exception is: " + e);
        }
        return writer.getBuffer().toString();
    }

    public int substitute(InputStream in, OutputStream out, String type, String encoding) throws IllegalArgumentException, UnsupportedEncodingException, IOException {
        if (encoding == null) {
            int t = this.getTypeConstant(type);
            switch (t) {
                case 1: {
                    encoding = "ISO-8859-1";
                    break;
                }
                case 2: {
                    encoding = "UTF-8";
                }
            }
        }
        InputStreamReader reader = encoding != null ? new InputStreamReader(in, encoding) : new InputStreamReader(in);
        OutputStreamWriter writer = encoding != null ? new OutputStreamWriter(out, encoding) : new OutputStreamWriter(out);
        int subs = this.substitute(reader, writer, type);
        writer.flush();
        return subs;
    }

    public String substitute(InputStream in, String type) throws IllegalArgumentException, UnsupportedEncodingException, IOException {
        String encoding = PLAIN;
        int t = this.getTypeConstant(type);
        switch (t) {
            case 1: {
                encoding = "ISO-8859-1";
                break;
            }
            case 2: {
                encoding = "UTF-8";
            }
        }
        InputStreamReader reader = encoding != null ? new InputStreamReader(in, encoding) : new InputStreamReader(in);
        StringWriter writer = new StringWriter();
        this.substitute(reader, writer, type);
        writer.flush();
        return writer.getBuffer().toString();
    }

    public int substitute(Reader reader, Writer writer, String type) throws IllegalArgumentException, IOException {
        int t = this.getTypeConstant(type);
        int variable_start = 36;
        if (t == 3) {
            variable_start = 37;
        } else if (t == 4) {
            variable_start = 64;
        }
        int subs = 0;
        int c = reader.read();
        while (true) {
            if (c != -1 && c != variable_start) {
                writer.write(c);
                c = reader.read();
                continue;
            }
            if (c == -1) {
                return subs;
            }
            boolean braces = false;
            c = reader.read();
            if (c == 123) {
                braces = true;
                c = reader.read();
            } else {
                if (this.bracesRequired) {
                    writer.write(variable_start);
                    continue;
                }
                if (c == -1) {
                    writer.write(variable_start);
                    return subs;
                }
            }
            StringBuffer nameBuffer = new StringBuffer();
            while (c != -1 && braces && c != 125 || c >= 97 && c <= 122 || c >= 65 && c <= 90 || braces && c == 91 || c == 93 || (c >= 48 && c <= 57 || c == 95) && nameBuffer.length() > 0) {
                nameBuffer.append((char)c);
                c = reader.read();
            }
            String name = nameBuffer.toString();
            String varvalue = null;
            if (!(braces && c != 125 || name.length() <= 0)) {
                varvalue = braces && name.startsWith("ENV[") && name.lastIndexOf(93) == name.length() - 1 ? IoHelper.getenv(name.substring(4, name.length() - 1)) : this.variables.getProperty(name);
                ++subs;
            }
            if (varvalue != null) {
                writer.write(this.escapeSpecialChars(varvalue, t));
                if (!braces) continue;
                c = reader.read();
                continue;
            }
            writer.write(variable_start);
            if (braces) {
                writer.write(123);
            }
            writer.write(name);
        }
    }

    protected int getTypeConstant(String type) {
        if (type == null) {
            return 0;
        }
        Integer integer = (Integer)typeNameToConstantMap.get(type);
        if (integer == null) {
            throw new IllegalArgumentException("Unknown file type " + type);
        }
        return integer;
    }

    protected String escapeSpecialChars(String str, int type) {
        switch (type) {
            case 0: 
            case 3: 
            case 4: {
                return str;
            }
            case 1: {
                StringBuffer buffer = new StringBuffer(str);
                int len = str.length();
                for (int i = 0; i < len; ++i) {
                    char c = buffer.charAt(i);
                    if (c == '\t' || c == '\n' || c == '\r') {
                        char tag = c == '\t' ? (char)'t' : (c == '\n' ? (char)'n' : 'r');
                        buffer.replace(i, i + 1, "\\" + tag);
                        ++len;
                        ++i;
                    }
                    if (c != '\\' && c != '\"' && c != '\'' && c != ' ') continue;
                    buffer.insert(i, '\\');
                    ++len;
                    ++i;
                }
                return buffer.toString();
            }
            case 2: {
                StringBuffer buffer = new StringBuffer(str);
                int len = str.length();
                for (int i = 0; i < len; ++i) {
                    String r = null;
                    char c = buffer.charAt(i);
                    switch (c) {
                        case '<': {
                            r = "&lt;";
                            break;
                        }
                        case '>': {
                            r = "&gt;";
                            break;
                        }
                        case '&': {
                            r = "&amp;";
                            break;
                        }
                        case '\'': {
                            r = "&apos;";
                            break;
                        }
                        case '\"': {
                            r = "&quot;";
                        }
                    }
                    if (r == null) continue;
                    buffer.replace(i, i + 1, r);
                    len = buffer.length();
                    i += r.length() - 1;
                }
                return buffer.toString();
            }
        }
        throw new Error("Unknown file type constant " + type);
    }

    static {
        typeNameToConstantMap.put(PLAIN, new Integer(0));
        typeNameToConstantMap.put("javaprop", new Integer(1));
        typeNameToConstantMap.put("xml", new Integer(2));
        typeNameToConstantMap.put("shell", new Integer(3));
        typeNameToConstantMap.put("at", new Integer(4));
    }
}

