/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.spi;

import com.sun.source.util.TreePath;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.prefs.Preferences;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.jackpot.impl.MessageImpl;
import org.netbeans.modules.java.hints.jackpot.impl.RulesManager;
import org.netbeans.modules.java.hints.jackpot.spi.HintMetadata;
import org.netbeans.modules.java.hints.options.HintsSettings;
import org.netbeans.modules.java.hints.spi.AbstractHint;

public class HintContext {
    private final CompilationInfo info;
    private final Preferences preferences;
    private final AbstractHint.HintSeverity severity;
    private final HintMetadata metadata;
    private final TreePath path;
    private final Map<String, TreePath> variables;
    private final Map<String, Collection<? extends TreePath>> multiVariables;
    private final Map<String, String> variableNames;
    private final Collection<? super MessageImpl> messages;

    public HintContext(CompilationInfo compilationInfo, HintMetadata hintMetadata, TreePath treePath, Map<String, TreePath> map, Map<String, Collection<? extends TreePath>> map2, Map<String, String> map3) {
        this(compilationInfo, hintMetadata, treePath, map, map2, map3, new LinkedList());
    }

    public HintContext(CompilationInfo compilationInfo, HintMetadata hintMetadata, TreePath treePath, Map<String, TreePath> map, Map<String, Collection<? extends TreePath>> map2, Map<String, String> map3, Collection<? super MessageImpl> collection) {
        this.info = compilationInfo;
        this.preferences = hintMetadata != null ? RulesManager.getPreferences(hintMetadata.id, HintsSettings.getCurrentProfileId()) : null;
        this.severity = this.preferences != null ? HintsSettings.getSeverity(hintMetadata, this.preferences) : AbstractHint.HintSeverity.ERROR;
        this.metadata = hintMetadata;
        this.path = treePath;
        map = new HashMap<String, TreePath>(map);
        map.put("$_", treePath);
        this.variables = map;
        this.multiVariables = map2;
        this.variableNames = map3;
        this.messages = collection;
    }

    public CompilationInfo getInfo() {
        return this.info;
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public AbstractHint.HintSeverity getSeverity() {
        return this.severity;
    }

    public TreePath getPath() {
        return this.path;
    }

    public Map<String, TreePath> getVariables() {
        return this.variables;
    }

    public Map<String, Collection<? extends TreePath>> getMultiVariables() {
        return this.multiVariables;
    }

    public Map<String, String> getVariableNames() {
        return this.variableNames;
    }

    public HintMetadata getHintMetadata() {
        return this.metadata;
    }

    public void reportMessage(MessageKind messageKind, String string) {
        this.messages.add(new MessageImpl(messageKind, string));
    }

    public static HintContext create(CompilationInfo compilationInfo, HintMetadata hintMetadata, TreePath treePath, Map<String, TreePath> map, Map<String, Collection<? extends TreePath>> map2, Map<String, String> map3) {
        return new HintContext(compilationInfo, hintMetadata, treePath, map, map2, map3);
    }

    public static enum MessageKind {
        WARNING,
        ERROR;

    }
}

