/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.shell;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.javacard.shell.APDUSender;
import org.netbeans.modules.javacard.shell.CommandManager;
import org.netbeans.modules.javacard.shell.NoWrapTextPane;
import org.netbeans.modules.javacard.shell.ShellException;
import org.netbeans.modules.javacard.spi.Card;
import org.netbeans.modules.javacard.spi.CardState;
import org.netbeans.modules.javacard.spi.CardStateObserver;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

final class ShellPanel
extends JPanel
implements CardStateObserver,
KeyListener {
    private static final String STYLE_COMMAND = "command";
    private static final String STYLE_COPYRIGHT = "copyright";
    private static final String STYLE_ERROR = "error";
    private static final String STYLE_KEYWORD = "keyword";
    private static final String STYLE_NORMAL = "normal";
    private static final String STYLE_PROMPT = "prompt";
    private static final String STYLE_RESPONSE = "response";
    private StringBuffer command = new StringBuffer();
    private int guardPos = 0;
    private Vector<String> history = new Vector();
    private int historyIndex = 0;
    private Card card = null;
    private final CommandManager commandManager = new CommandManager();
    Random random = new Random();
    private ArrayList<String> hintsList = new ArrayList();
    private int hintIndex = 0;
    private JLabel hintLabel;
    private JScrollPane jScrollPane2;
    private NoWrapTextPane shellTextPane;
    private String PROMPT = "\n>";

    public ShellPanel() {
        this.initComponents();
        this.addStyles();
        this.shellTextPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable clipboardContent = clipboard.getContents(this);
                if (clipboardContent != null && clipboardContent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    try {
                        String tempString = (String)clipboardContent.getTransferData(DataFlavor.stringFlavor);
                        ShellPanel.this.appendPastedString(tempString);
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }, KeyStroke.getKeyStroke(86, 2), 0);
        Font f = UIManager.getFont("controlFont");
        int size = f == null ? 13 : f.getSize();
        this.shellTextPane.setFont(new Font("Monospaced", 0, size));
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public void setServer(Card server) {
        this.card = server;
        server.addCardStateObserver((CardStateObserver)this);
        this.clear();
    }

    public Card getCard() {
        return this.card;
    }

    @Override
    public void requestFocus() {
        this.shellTextPane.requestFocus();
    }

    @Override
    public boolean requestFocus(boolean temporary) {
        return this.shellTextPane.requestFocus(temporary);
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.shellTextPane.requestFocusInWindow();
    }

    private void clear() {
        this.append(this.card.toString(), STYLE_COPYRIGHT);
        this.append(APDUSender.getString("INITIAL_TEXT"), STYLE_COPYRIGHT);
        this.prompt();
    }

    public Vector<String> getHistory() {
        return this.history;
    }

    private void appendPastedString(String str) {
        int cp = this.shellTextPane.getCaretPosition();
        if (cp < this.guardPos) {
            this.shellTextPane.setCaretPosition(this.shellTextPane.getDocument().getLength());
            cp = this.shellTextPane.getCaretPosition();
        }
        for (char ch : str.toCharArray()) {
            this.processKeyChar(ch, null);
            try {
                this.shellTextPane.getDocument().insertString(this.shellTextPane.getCaretPosition(), "" + ch, null);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void append(String str, String styleName) {
        try {
            int end = this.shellTextPane.getDocument().getLength();
            this.shellTextPane.getDocument().insertString(end, str, this.shellTextPane.getStyle(styleName));
            Rectangle r = this.shellTextPane.modelToView(end);
            if (r != null) {
                this.shellTextPane.scrollRectToVisible(r);
            }
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void addStyles() {
        Style style = null;
        style = this.shellTextPane.addStyle(STYLE_COPYRIGHT, null);
        StyleConstants.setForeground(style, Color.GRAY);
        style = this.shellTextPane.addStyle(STYLE_NORMAL, null);
        StyleConstants.setForeground(style, Color.BLACK);
        style = this.shellTextPane.addStyle(STYLE_KEYWORD, null);
        StyleConstants.setForeground(style, Color.MAGENTA);
        StyleConstants.setBold(style, true);
        StyleConstants.setUnderline(style, true);
        style = this.shellTextPane.addStyle(STYLE_PROMPT, null);
        StyleConstants.setForeground(style, Color.BLACK);
        StyleConstants.setBold(style, true);
        style = this.shellTextPane.addStyle(STYLE_COMMAND, null);
        StyleConstants.setForeground(style, Color.BLACK);
        StyleConstants.setBold(style, true);
        style = this.shellTextPane.addStyle(STYLE_RESPONSE, null);
        StyleConstants.setForeground(style, Color.BLUE);
        style = this.shellTextPane.addStyle(STYLE_ERROR, null);
        StyleConstants.setForeground(style, Color.RED);
    }

    private void historyUp() {
        if (this.historyIndex > 0) {
            --this.historyIndex;
        }
        this.updateCommandFromHistroy(this.history.elementAt(this.historyIndex));
    }

    private void histroyDown() {
        if (this.historyIndex < this.history.size()) {
            ++this.historyIndex;
        }
        if (this.historyIndex < this.history.size()) {
            this.command.append(this.history.elementAt(this.historyIndex));
            this.updateCommandFromHistroy(this.history.elementAt(this.historyIndex));
        } else {
            this.updateCommandFromHistroy("");
        }
    }

    private void prompt() {
        this.append(this.PROMPT, STYLE_PROMPT);
        this.guardPos = this.shellTextPane.getDocument().getLength();
    }

    private void executeCommand(String cmd) throws ShellException {
        this.append("\n", STYLE_RESPONSE);
        boolean addToHistory = true;
        if (addToHistory) {
            this.history.addElement(cmd);
            this.historyIndex = this.history.size();
        }
        if ("cls".equals(cmd) || "clear".equals(cmd)) {
            this.prompt();
            this.shellTextPane.setSelectionStart(0);
            this.shellTextPane.setSelectionEnd(this.guardPos);
            this.shellTextPane.replaceSelection("");
            this.append(this.card.toString(), STYLE_COPYRIGHT);
            this.append(APDUSender.getString("INITIAL_TEXT"), STYLE_COPYRIGHT);
            return;
        }
        if (cmd.startsWith("!")) {
            int index = 0;
            try {
                index = Integer.parseInt(cmd.substring(1));
            }
            catch (NumberFormatException e) {
                index = -1;
            }
            if (index < 0 || index >= this.history.size()) {
                this.append(APDUSender.getString("INVALID_INDEX"), STYLE_ERROR);
                return;
            }
            cmd = this.history.elementAt(index);
        }
        this.append(this.commandManager.execute(this, cmd), STYLE_RESPONSE);
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.shellTextPane = new NoWrapTextPane();
        this.hintLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jScrollPane2.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getDefaults().getColor("controlShadow")));
        this.jScrollPane2.setViewportBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.shellTextPane.addKeyListener(this);
        this.jScrollPane2.setViewportView(this.shellTextPane);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.ipady = 100;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.weighty = 0.9;
        this.add((Component)this.jScrollPane2, gridBagConstraints);
        this.hintLabel.setFont(new Font("Monospaced", 0, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 40;
        gridBagConstraints.ipady = 14;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.hintLabel, gridBagConstraints);
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        if (evt.getSource() == this.shellTextPane) {
            this.shellTextPaneKeyPressed(evt);
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        if (evt.getSource() == this.shellTextPane) {
            this.shellTextPaneKeyReleased(evt);
        }
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        if (evt.getSource() == this.shellTextPane) {
            this.shellTextPaneKeyTyped(evt);
        }
    }

    private void shellTextPaneKeyTyped(KeyEvent evt) {
        this.processKeyChar(evt.getKeyChar(), evt);
    }

    private void shellTextPaneKeyReleased(KeyEvent evt) {
        this.tryHighlighting();
        evt.consume();
    }

    private void shellTextPaneKeyPressed(KeyEvent evt) {
        int cp;
        int key = evt.getKeyCode();
        if (key == 38) {
            if (evt.isControlDown()) {
                this.previousHint();
            } else {
                this.historyUp();
                this.hintsUpdate();
            }
            evt.consume();
            return;
        }
        if (key == 40) {
            if (evt.isControlDown()) {
                this.nextHint();
            } else {
                this.histroyDown();
                this.hintsUpdate();
            }
            evt.consume();
            return;
        }
        if (evt.isControlDown()) {
            if (key == 67 || key == 88) {
                return;
            }
            if (key == 86) {
                return;
            }
        }
        if (key == 8 && (cp = this.shellTextPane.getCaretPosition()) <= this.guardPos) {
            evt.consume();
            return;
        }
        if (key == 127 && (cp = this.shellTextPane.getCaretPosition()) < this.guardPos) {
            evt.consume();
            return;
        }
        if (evt.getKeyCode() == 8) {
            int len;
            cp = this.shellTextPane.getCaretPosition();
            int index = cp - this.guardPos;
            if (index <= (len = this.command.length())) {
                this.command.deleteCharAt(index - 1);
                this.hintsUpdate();
            }
            return;
        }
        if (evt.getKeyCode() == 127) {
            int len;
            cp = this.shellTextPane.getCaretPosition();
            int index = cp - this.guardPos;
            if (index < (len = this.command.length())) {
                this.command.deleteCharAt(index);
                this.hintsUpdate();
            }
            return;
        }
        if (evt.getKeyCode() == 10) {
            if (evt.isControlDown() && this.hintsList.size() > 0) {
                this.updateCommandFromHistroy(this.hintsList.get(this.hintIndex));
                this.tryHighlighting();
            }
            if (this.command.length() > 0) {
                try {
                    this.executeCommand(this.command.toString());
                }
                catch (ShellException ex) {
                    this.append("\n" + ex.getLocalizedMessage(), STYLE_ERROR);
                }
                this.command.setLength(0);
                this.hintsUpdate();
            }
            this.prompt();
            this.shellTextPane.setCaretPosition(this.shellTextPane.getDocument().getLength());
            evt.consume();
            return;
        }
    }

    private void processKeyChar(char ch, KeyEvent evt) {
        if (evt != null && evt.isControlDown()) {
            return;
        }
        if (ch >= ' ' && ch <= '~') {
            int len;
            int index;
            int cp = this.shellTextPane.getCaretPosition();
            if (cp < this.guardPos) {
                this.shellTextPane.setCaretPosition(this.shellTextPane.getDocument().getLength());
                cp = this.shellTextPane.getCaretPosition();
            }
            if ((index = cp - this.guardPos) < (len = this.command.length())) {
                this.command.insert(index, ch);
                this.hintsUpdate();
            } else {
                this.shellTextPane.setCaretPosition(this.shellTextPane.getDocument().getLength());
                this.command.append(ch);
                this.hintsUpdate();
            }
            this.tryHighlighting();
        }
    }

    private void hintsUpdate() {
        this.hintsList.clear();
        this.hintIndex = -1;
        String cstr = this.command.toString();
        if (cstr.length() > 0) {
            for (String str : this.history) {
                if (!str.startsWith(cstr)) continue;
                this.hintsList.add(str);
            }
        }
        if (this.hintsList.size() > 0) {
            this.hintIndex = 0;
            this.hintLabel.setText(NbBundle.getMessage(ShellPanel.class, (String)"HINT", (Object)(this.hintIndex + 1), (Object)this.hintsList.size(), (Object)this.hintsList.get(this.hintIndex)));
        } else {
            this.hintLabel.setText(" ");
        }
    }

    private void nextHint() {
        if (this.hintsList.size() <= 0) {
            return;
        }
        if (this.hintIndex < this.hintsList.size() - 1) {
            ++this.hintIndex;
            this.hintLabel.setText(NbBundle.getMessage(ShellPanel.class, (String)"HINT", (Object)(this.hintIndex + 1), (Object)this.hintsList.size(), (Object)this.hintsList.get(this.hintIndex)));
        }
    }

    private void previousHint() {
        if (this.hintsList.size() <= 0) {
            return;
        }
        if (this.hintIndex > 0) {
            --this.hintIndex;
            this.hintLabel.setText(NbBundle.getMessage(ShellPanel.class, (String)"HINT", (Object)(this.hintIndex + 1), (Object)this.hintsList.size(), (Object)this.hintsList.get(this.hintIndex)));
        }
    }

    private void tryHighlighting() {
        int len = this.command.length();
        int i = 0;
        int s = 0;
        int e = 0;
        StyledDocument sd = this.shellTextPane.getStyledDocument();
        while (i < len) {
            while (i < len && this.command.charAt(i) == ' ') {
                ++i;
            }
            s = i;
            while (i < len && this.command.charAt(i) != ' ') {
                String token;
                if (this.commandManager.isValidCommand(token = this.command.substring(s, e = ++i))) {
                    sd.setCharacterAttributes(this.guardPos + s, e - s, this.shellTextPane.getStyle(STYLE_KEYWORD), true);
                    continue;
                }
                sd.setCharacterAttributes(this.guardPos + s, e - s, this.shellTextPane.getStyle(STYLE_NORMAL), true);
            }
        }
    }

    private void updateCommandFromHistroy(String nc) {
        this.shellTextPane.setSelectionStart(this.guardPos);
        this.shellTextPane.setSelectionEnd(this.guardPos + this.command.length());
        this.shellTextPane.replaceSelection(nc);
        this.command.setLength(0);
        this.command.append(nc);
    }

    public void onStateChange(Card card, CardState old, CardState nue) {
        this.shellTextPane.setEnabled(nue == CardState.RUNNING || nue == CardState.RUNNING_IN_DEBUG_MODE);
    }

    void removeFromCard() {
        this.card.removeCardStateObserver((CardStateObserver)this);
    }
}

