/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.moduleinstall;

import java.io.IOException;
import java.util.HashMap;
import org.netbeans.modules.apisupport.project.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

final class DataModel
extends BasicWizardIterator.BasicDataModel {
    static final String OPENIDE_MODULE_INSTALL = "OpenIDE-Module-Install";
    static final String BUNDLE_ACTIVATOR = "Bundle-Activator";
    static final String IMPORT_PACKAGE = "Import-Package";
    private static final String INSTALLER_CLASS_NAME = "Installer";
    private CreatedModifiedFiles cmf;

    DataModel(WizardDescriptor wiz) {
        super(wiz);
    }

    CreatedModifiedFiles getCreatedModifiedFiles() {
        if (this.cmf == null) {
            this.regenerate();
        }
        return this.cmf;
    }

    private void regenerate() {
        FileObject template;
        this.cmf = new CreatedModifiedFiles(this.getProject());
        boolean osgi = false;
        try {
            osgi = ((NbModuleProvider)this.getProject().getLookup().lookup(NbModuleProvider.class)).hasDependency("org.netbeans.libs.osgi");
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        String className = INSTALLER_CLASS_NAME;
        String path = this.getDefaultPackagePath(className + ".java", false);
        int i = 0;
        while (this.alreadyExist(path)) {
            className = "Installer_" + ++i;
            path = this.getDefaultPackagePath(className + ".java", false);
        }
        HashMap<String, String> basicTokens = new HashMap<String, String>();
        basicTokens.put("PACKAGE_NAME", this.getPackageName());
        basicTokens.put("CLASS_NAME", className);
        if (osgi) {
            template = CreatedModifiedFiles.getTemplate("moduleActivator.java");
        } else {
            template = CreatedModifiedFiles.getTemplate("moduleInstall.java");
            this.cmf.add(this.cmf.addModuleDependency("org.openide.modules"));
            this.cmf.add(this.cmf.addModuleDependency("org.openide.util"));
        }
        this.cmf.add(this.cmf.createFileWithSubstitutions(path, template, basicTokens));
        HashMap<String, String> attribs = new HashMap<String, String>();
        if (osgi) {
            attribs.put(BUNDLE_ACTIVATOR, this.getPackageName() + '.' + className);
            attribs.put(IMPORT_PACKAGE, "org.osgi.framework");
        } else {
            attribs.put(OPENIDE_MODULE_INSTALL, this.getPackageName().replace('.', '/') + '/' + className + ".class");
        }
        this.cmf.add(this.cmf.manifestModification(null, attribs));
    }

    private void reset() {
        this.cmf = null;
    }

    @Override
    public void setPackageName(String packageName) {
        super.setPackageName(packageName);
        this.reset();
    }

    private boolean alreadyExist(String relPath) {
        return this.getProject().getProjectDirectory().getFileObject(relPath) != null;
    }
}

