/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swing;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.util.Map;
import org.xhtmlrenderer.extend.FontContext;
import org.xhtmlrenderer.extend.OutputDevice;
import org.xhtmlrenderer.extend.TextRenderer;
import org.xhtmlrenderer.render.FSFont;
import org.xhtmlrenderer.render.FSFontMetrics;
import org.xhtmlrenderer.render.LineMetricsAdapter;
import org.xhtmlrenderer.swing.AWTFSFont;
import org.xhtmlrenderer.swing.Java2DFontContext;
import org.xhtmlrenderer.swing.Java2DOutputDevice;
import org.xhtmlrenderer.util.Configuration;

public class Java2DTextRenderer
implements TextRenderer {
    protected float scale = Configuration.valueAsFloat("xr.text.scale", 1.0f);
    protected float threshold = Configuration.valueAsFloat("xr.text.aa-fontsize-threshhold", 25.0f);
    protected int level = Configuration.valueAsInt("xr.text.aa-smoothing-level", 3);
    protected Object antiAliasRenderingHint;

    public Java2DTextRenderer() {
        Object dummy = new Object();
        Object aaHint = Configuration.valueFromClassConstant("xr.text.aa-rendering-hint", dummy);
        if (aaHint == dummy) {
            try {
                Map map = null;
                Toolkit tk = Toolkit.getDefaultToolkit();
                map = (Map)tk.getDesktopProperty("awt.font.desktophints");
                this.antiAliasRenderingHint = map.get(RenderingHints.KEY_TEXT_ANTIALIASING);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.antiAliasRenderingHint == null) {
            this.antiAliasRenderingHint = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
        }
    }

    public void drawString(OutputDevice outputDevice, String string, float x, float y) {
        Object prevHint = null;
        Graphics2D graphics = ((Java2DOutputDevice)outputDevice).getGraphics();
        if ((float)graphics.getFont().getSize() > this.threshold && this.level > 0) {
            prevHint = graphics.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.antiAliasRenderingHint);
        }
        graphics.drawString(string, (int)x, (int)y);
        if ((float)graphics.getFont().getSize() > this.threshold && this.level > 0) {
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, prevHint);
        }
    }

    public void setup(FontContext fontContext) {
        ((Java2DFontContext)fontContext).getGraphics().setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
    }

    public void setFontScale(float scale) {
        this.scale = scale;
    }

    public void setSmoothingThreshold(float fontsize) {
        this.threshold = fontsize;
    }

    public void setSmoothingLevel(int level) {
        this.level = level;
    }

    public FSFontMetrics getFSFontMetrics(FontContext fc, FSFont font, String string) {
        Graphics2D graphics = ((Java2DFontContext)fc).getGraphics();
        return new LineMetricsAdapter(((AWTFSFont)font).getAWTFont().getLineMetrics(string, graphics.getFontRenderContext()));
    }

    public int getWidth(FontContext fc, FSFont font, String string) {
        Graphics2D graphics = ((Java2DFontContext)fc).getGraphics();
        Font awtFont = ((AWTFSFont)font).getAWTFont();
        return (int)Math.ceil(graphics.getFontMetrics(awtFont).getStringBounds(string, graphics).getWidth());
    }

    public float getFontScale() {
        return this.scale;
    }

    public int getSmoothingLevel() {
        return this.level;
    }

    public Object getRenderingHints() {
        return this.antiAliasRenderingHint;
    }

    public void setRenderingHints(Object renderingHints) {
        this.antiAliasRenderingHint = renderingHints;
    }
}

