/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.util.concurrent.Callable;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.checkout.CheckoutCommand;
import org.netbeans.lib.cvsclient.command.export.ExportCommand;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.util.IndexingBridge;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.ErrorManager;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;

class CommandRunnable
implements Runnable,
Cancellable {
    private final Client client;
    private final GlobalOptions options;
    private final Command cmd;
    private Throwable failure;
    private boolean aborted;
    private ExecutorSupport support;
    private static boolean testRetry = Boolean.getBoolean("netbeans.debug.cvs.io.retry");

    public CommandRunnable(Client client, GlobalOptions options, Command cmd, ExecutorSupport support) {
        this.client = client;
        this.options = options;
        this.cmd = cmd;
        this.support = support;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CommandRunnable commandRunnable = this;
        synchronized (commandRunnable) {
            if (this.isAborted()) {
                return;
            }
            this.support.commandStarted(this);
        }
        CounterRunnable counterUpdater = new CounterRunnable();
        RequestProcessor.Task counterTask = CvsVersioningSystem.getInstance().getParallelRequestProcessor().create((Runnable)counterUpdater);
        counterUpdater.initTask(counterTask);
        try {
            counterTask.schedule(500);
            if (testRetry && !this.support.t9yRetryFlag) {
                this.support.t9yRetryFlag = true;
                String msg = "Testing retry logic. Retry attempt will be OK. (-Dnetbeans.debug.cvs.io.retry=true)";
                throw new AuthenticationException(msg, msg);
            }
            Utils.logVCSClientEvent((String)"CVS", (String)"JAVALIB");
            this.execute();
        }
        catch (Throwable e) {
            this.failure = e;
        }
        finally {
            counterTask.cancel();
            try {
                this.client.getConnection().close();
            }
            catch (Throwable e) {
                ErrorManager.getDefault().notify(16, e);
            }
        }
    }

    private void execute() throws Throwable {
        Callable<Object> c = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                CommandRunnable.this.client.executeCommand(CommandRunnable.this.cmd, CommandRunnable.this.options);
                return null;
            }
        };
        String cmdName = this.cmd.getCVSCommand();
        if (cmdName == null) {
            cmdName = "";
        }
        boolean blockIndexing = cmdName.startsWith("update") && (this.options == null || !this.options.isDoNoChanges()) || cmdName.startsWith("export") || cmdName.startsWith("remove") || cmdName.startsWith("checkout") && (!(this.cmd instanceof CheckoutCommand) || !((CheckoutCommand)this.cmd).isPipeToOutput());
        File[] files = null;
        if (blockIndexing) {
            if (this.cmd instanceof BasicCommand) {
                BasicCommand bc = (BasicCommand)this.cmd;
                files = bc.getFiles();
            } else if (this.cmd instanceof ExportCommand) {
                ExportCommand ec = (ExportCommand)this.cmd;
                files = new File[]{new File(ec.getExportDirectory())};
            }
        }
        if (blockIndexing) {
            IndexingBridge.getInstance().runWithoutIndexing((Callable)c, files);
        } else {
            c.call();
        }
    }

    public Throwable getFailure() {
        return this.failure;
    }

    public synchronized boolean isAborted() {
        return this.aborted;
    }

    public synchronized boolean cancel() {
        if (this.aborted) {
            return false;
        }
        this.aborted = true;
        this.client.abort();
        return true;
    }

    public String toString() {
        return "CommandRunnable command=" + this.cmd.getCVSCommand();
    }

    private class CounterRunnable
    implements Runnable {
        private RequestProcessor.Task task;
        private long counter;

        private CounterRunnable() {
        }

        @Override
        public void run() {
            long current = CommandRunnable.this.client.getCounter();
            long delta = current - this.counter;
            this.counter = current;
            CommandRunnable.this.support.increaseDataCounter(delta);
            this.task.schedule(500);
        }

        void initTask(RequestProcessor.Task task) {
            this.task = task;
        }
    }
}

