/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.options;

import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public final class MavenCommandSettings {
    private static final MavenCommandSettings INSTANCE = new MavenCommandSettings();
    public static final String COMMAND_CREATE_ARCHETYPE = "createArchetype";
    public static final String COMMAND_CREATE_ARCHETYPENG = "createArchetypeNG";
    public static final String COMMAND_INSTALL_FILE = "installFile";
    public static final String COMMAND_SCM_CHECKOUT = "scmCheckout";

    public static MavenCommandSettings getDefault() {
        return INSTANCE;
    }

    protected final Preferences getPreferences() {
        return NbPreferences.root().node("org/netbeans/modules/maven/commands");
    }

    protected final String putProperty(String key, String value) {
        String retval = this.getProperty(key);
        if (value != null) {
            this.getPreferences().put(key, value);
        } else {
            this.getPreferences().remove(key);
        }
        return retval;
    }

    protected final String getProperty(String key) {
        return this.getPreferences().get(key, null);
    }

    private MavenCommandSettings() {
    }

    public String getCommand(String command) {
        String toRet = this.getProperty(command);
        if (toRet == null) {
            if (COMMAND_INSTALL_FILE.equals(command)) {
                toRet = "install:install-file";
            } else if (COMMAND_CREATE_ARCHETYPENG.equals(command)) {
                toRet = "org.apache.maven.plugins:maven-archetype-plugin:2.0-alpha-4:generate";
            } else if (COMMAND_SCM_CHECKOUT.equals(command)) {
                toRet = "org.apache.maven.plugins:maven-scm-plugin:1.0:checkout";
            }
        }
        assert (toRet != null) : "Command " + command + " needs implementation.";
        return toRet;
    }
}

